// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.services.ec2.model.CreateInstanceExportTaskRequest
import aws.sdk.kotlin.services.ec2.model.ExportEnvironment
import aws.sdk.kotlin.services.ec2.model.ExportToS3TaskSpecification
import aws.sdk.kotlin.services.ec2.model.TagSpecification
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlFlattened
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateInstanceExportTaskOperationSerializer: HttpSerialize<CreateInstanceExportTaskRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateInstanceExportTaskRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateInstanceExportTaskOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        return builder
    }
}

private fun serializeCreateInstanceExportTaskOperationBody(context: ExecutionContext, input: CreateInstanceExportTaskRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Description"))
    val EXPORTTOS3TASK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("ExportToS3"))
    val INSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("InstanceId"))
    val TAGSPECIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("TagSpecification"), FormUrlFlattened)
    val TARGETENVIRONMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TargetEnvironment"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("CreateInstanceExportTaskRequest"))
        trait(QueryLiteral("Action", "CreateInstanceExportTask"))
        trait(QueryLiteral("Version", "2016-11-15"))
        field(DESCRIPTION_DESCRIPTOR)
        field(EXPORTTOS3TASK_DESCRIPTOR)
        field(INSTANCEID_DESCRIPTOR)
        field(TAGSPECIFICATIONS_DESCRIPTOR)
        field(TARGETENVIRONMENT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.exportToS3Task?.let { field(EXPORTTOS3TASK_DESCRIPTOR, it, ::serializeExportToS3TaskSpecificationDocument) }
        input.instanceId?.let { field(INSTANCEID_DESCRIPTOR, it) }
        if (input.tagSpecifications != null) {
            listField(TAGSPECIFICATIONS_DESCRIPTOR) {
                for (el0 in input.tagSpecifications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagSpecificationDocument))
                }
            }
        }
        input.targetEnvironment?.let { field(TARGETENVIRONMENT_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
