// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseEc2QueryErrorResponse
import aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue
import aws.sdk.kotlin.services.ec2.model.AttributeValue
import aws.sdk.kotlin.services.ec2.model.DescribeInstanceAttributeResponse
import aws.sdk.kotlin.services.ec2.model.Ec2Exception
import aws.sdk.kotlin.services.ec2.model.EnclaveOptions
import aws.sdk.kotlin.services.ec2.model.GroupIdentifier
import aws.sdk.kotlin.services.ec2.model.InstanceBlockDeviceMapping
import aws.sdk.kotlin.services.ec2.model.ProductCode
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeInstanceAttributeOperationDeserializer: HttpDeserialize<DescribeInstanceAttributeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeInstanceAttributeResponse {
        if (!response.status.isSuccess()) {
            throwDescribeInstanceAttributeError(context, response)
        }
        val builder = DescribeInstanceAttributeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeInstanceAttributeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeInstanceAttributeOperationBody(builder: DescribeInstanceAttributeResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val BLOCKDEVICEMAPPINGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("blockDeviceMapping"), XmlCollectionName("item"))
    val DISABLEAPITERMINATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("disableApiTermination"))
    val EBSOPTIMIZED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ebsOptimized"))
    val ENASUPPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("enaSupport"))
    val ENCLAVEOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("enclaveOptions"))
    val GROUPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("groupSet"), XmlCollectionName("item"))
    val INSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("instanceId"))
    val INSTANCEINITIATEDSHUTDOWNBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("instanceInitiatedShutdownBehavior"))
    val INSTANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("instanceType"))
    val KERNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("kernel"))
    val PRODUCTCODES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("productCodes"), XmlCollectionName("item"))
    val RAMDISKID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ramdisk"))
    val ROOTDEVICENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("rootDeviceName"))
    val SOURCEDESTCHECK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("sourceDestCheck"))
    val SRIOVNETSUPPORT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("sriovNetSupport"))
    val USERDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("userData"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ec2.amazonaws.com/doc/2016-11-15"))
        trait(XmlSerialName("DescribeInstanceAttributeResult"))
        field(BLOCKDEVICEMAPPINGS_DESCRIPTOR)
        field(DISABLEAPITERMINATION_DESCRIPTOR)
        field(EBSOPTIMIZED_DESCRIPTOR)
        field(ENASUPPORT_DESCRIPTOR)
        field(ENCLAVEOPTIONS_DESCRIPTOR)
        field(GROUPS_DESCRIPTOR)
        field(INSTANCEID_DESCRIPTOR)
        field(INSTANCEINITIATEDSHUTDOWNBEHAVIOR_DESCRIPTOR)
        field(INSTANCETYPE_DESCRIPTOR)
        field(KERNELID_DESCRIPTOR)
        field(PRODUCTCODES_DESCRIPTOR)
        field(RAMDISKID_DESCRIPTOR)
        field(ROOTDEVICENAME_DESCRIPTOR)
        field(SOURCEDESTCHECK_DESCRIPTOR)
        field(SRIOVNETSUPPORT_DESCRIPTOR)
        field(USERDATA_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOCKDEVICEMAPPINGS_DESCRIPTOR.index -> builder.blockDeviceMappings =
                    deserializer.deserializeList(BLOCKDEVICEMAPPINGS_DESCRIPTOR) {
                        val col0 = mutableListOf<InstanceBlockDeviceMapping>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeInstanceBlockDeviceMappingDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DISABLEAPITERMINATION_DESCRIPTOR.index -> builder.disableApiTermination = deserializeAttributeBooleanValueDocument(deserializer)
                EBSOPTIMIZED_DESCRIPTOR.index -> builder.ebsOptimized = deserializeAttributeBooleanValueDocument(deserializer)
                ENASUPPORT_DESCRIPTOR.index -> builder.enaSupport = deserializeAttributeBooleanValueDocument(deserializer)
                ENCLAVEOPTIONS_DESCRIPTOR.index -> builder.enclaveOptions = deserializeEnclaveOptionsDocument(deserializer)
                GROUPS_DESCRIPTOR.index -> builder.groups =
                    deserializer.deserializeList(GROUPS_DESCRIPTOR) {
                        val col0 = mutableListOf<GroupIdentifier>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeGroupIdentifierDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                INSTANCEID_DESCRIPTOR.index -> builder.instanceId = deserializeString()
                INSTANCEINITIATEDSHUTDOWNBEHAVIOR_DESCRIPTOR.index -> builder.instanceInitiatedShutdownBehavior = deserializeAttributeValueDocument(deserializer)
                INSTANCETYPE_DESCRIPTOR.index -> builder.instanceType = deserializeAttributeValueDocument(deserializer)
                KERNELID_DESCRIPTOR.index -> builder.kernelId = deserializeAttributeValueDocument(deserializer)
                PRODUCTCODES_DESCRIPTOR.index -> builder.productCodes =
                    deserializer.deserializeList(PRODUCTCODES_DESCRIPTOR) {
                        val col0 = mutableListOf<ProductCode>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProductCodeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RAMDISKID_DESCRIPTOR.index -> builder.ramdiskId = deserializeAttributeValueDocument(deserializer)
                ROOTDEVICENAME_DESCRIPTOR.index -> builder.rootDeviceName = deserializeAttributeValueDocument(deserializer)
                SOURCEDESTCHECK_DESCRIPTOR.index -> builder.sourceDestCheck = deserializeAttributeBooleanValueDocument(deserializer)
                SRIOVNETSUPPORT_DESCRIPTOR.index -> builder.sriovNetSupport = deserializeAttributeValueDocument(deserializer)
                USERDATA_DESCRIPTOR.index -> builder.userData = deserializeAttributeValueDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeInstanceAttributeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseEc2QueryErrorResponse(payload)
    } catch (ex: Exception) {
        throw Ec2Exception("Failed to parse response as 'ec2Query' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    throw Ec2Exception(errorDetails.message)
}
