// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.xml.parseEc2QueryErrorResponse
import aws.sdk.kotlin.services.ec2.model.CreateVolumePermission
import aws.sdk.kotlin.services.ec2.model.DescribeSnapshotAttributeResponse
import aws.sdk.kotlin.services.ec2.model.Ec2Exception
import aws.sdk.kotlin.services.ec2.model.ProductCode
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlCollectionName
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName


internal class DescribeSnapshotAttributeOperationDeserializer: HttpDeserialize<DescribeSnapshotAttributeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeSnapshotAttributeResponse {
        if (!response.status.isSuccess()) {
            throwDescribeSnapshotAttributeError(context, response)
        }
        val builder = DescribeSnapshotAttributeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSnapshotAttributeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeDescribeSnapshotAttributeOperationBody(builder: DescribeSnapshotAttributeResponse.Builder, payload: ByteArray) {
    val deserializer = XmlDeserializer(payload)
    val CREATEVOLUMEPERMISSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("createVolumePermission"), XmlCollectionName("item"))
    val PRODUCTCODES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, XmlSerialName("productCodes"), XmlCollectionName("item"))
    val SNAPSHOTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("snapshotId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlNamespace("http://ec2.amazonaws.com/doc/2016-11-15"))
        trait(XmlSerialName("DescribeSnapshotAttributeResult"))
        field(CREATEVOLUMEPERMISSIONS_DESCRIPTOR)
        field(PRODUCTCODES_DESCRIPTOR)
        field(SNAPSHOTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATEVOLUMEPERMISSIONS_DESCRIPTOR.index -> builder.createVolumePermissions =
                    deserializer.deserializeList(CREATEVOLUMEPERMISSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<CreateVolumePermission>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCreateVolumePermissionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PRODUCTCODES_DESCRIPTOR.index -> builder.productCodes =
                    deserializer.deserializeList(PRODUCTCODES_DESCRIPTOR) {
                        val col0 = mutableListOf<ProductCode>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeProductCodeDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SNAPSHOTID_DESCRIPTOR.index -> builder.snapshotId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwDescribeSnapshotAttributeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseEc2QueryErrorResponse(payload)
    } catch (ex: Exception) {
        throw Ec2Exception("Failed to parse response as 'ec2Query' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    throw Ec2Exception(errorDetails.message)
}
