// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.transform

import aws.sdk.kotlin.services.ec2.model.DiskImageDetail
import aws.sdk.kotlin.services.ec2.model.ImportVolumeRequest
import aws.sdk.kotlin.services.ec2.model.VolumeDetail
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ImportVolumeOperationSerializer: HttpSerialize<ImportVolumeRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ImportVolumeRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeImportVolumeOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        return builder
    }
}

private fun serializeImportVolumeOperationBody(context: ExecutionContext, input: ImportVolumeRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val AVAILABILITYZONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("AvailabilityZone"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Description"))
    val DRYRUN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, FormUrlSerialName("DryRun"))
    val IMAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("Image"))
    val VOLUME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, FormUrlSerialName("Volume"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("ImportVolumeRequest"))
        trait(QueryLiteral("Action", "ImportVolume"))
        trait(QueryLiteral("Version", "2016-11-15"))
        field(AVAILABILITYZONE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DRYRUN_DESCRIPTOR)
        field(IMAGE_DESCRIPTOR)
        field(VOLUME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.availabilityZone?.let { field(AVAILABILITYZONE_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.dryRun?.let { field(DRYRUN_DESCRIPTOR, it) }
        input.image?.let { field(IMAGE_DESCRIPTOR, it, ::serializeDiskImageDetailDocument) }
        input.volume?.let { field(VOLUME_DESCRIPTOR, it, ::serializeVolumeDetailDocument) }
    }
    return serializer.toByteArray()
}
