// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Information about an authorization rule.
 */
class AuthorizationRule private constructor(builder: Builder) {
    /**
     * Indicates whether the authorization rule grants access to all clients.
     */
    val accessAll: kotlin.Boolean? = builder.accessAll
    /**
     * The ID of the Client VPN endpoint with which the authorization rule is associated.
     */
    val clientVpnEndpointId: kotlin.String? = builder.clientVpnEndpointId
    /**
     * A brief description of the authorization rule.
     */
    val description: kotlin.String? = builder.description
    /**
     * The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
     */
    val destinationCidr: kotlin.String? = builder.destinationCidr
    /**
     * The ID of the Active Directory group to which the authorization rule grants access.
     */
    val groupId: kotlin.String? = builder.groupId
    /**
     * The current state of the authorization rule.
     */
    val status: aws.sdk.kotlin.services.ec2.model.ClientVpnAuthorizationRuleStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.AuthorizationRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuthorizationRule(")
        append("accessAll=$accessAll,")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("description=$description,")
        append("destinationCidr=$destinationCidr,")
        append("groupId=$groupId,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessAll?.hashCode() ?: 0
        result = 31 * result + (clientVpnEndpointId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationCidr?.hashCode() ?: 0)
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuthorizationRule

        if (accessAll != other.accessAll) return false
        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (description != other.description) return false
        if (destinationCidr != other.destinationCidr) return false
        if (groupId != other.groupId) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.AuthorizationRule = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether the authorization rule grants access to all clients.
         */
        var accessAll: kotlin.Boolean? = null
        /**
         * The ID of the Client VPN endpoint with which the authorization rule is associated.
         */
        var clientVpnEndpointId: kotlin.String? = null
        /**
         * A brief description of the authorization rule.
         */
        var description: kotlin.String? = null
        /**
         * The IPv4 address range, in CIDR notation, of the network to which the authorization rule applies.
         */
        var destinationCidr: kotlin.String? = null
        /**
         * The ID of the Active Directory group to which the authorization rule grants access.
         */
        var groupId: kotlin.String? = null
        /**
         * The current state of the authorization rule.
         */
        var status: aws.sdk.kotlin.services.ec2.model.ClientVpnAuthorizationRuleStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.AuthorizationRule) : this() {
            this.accessAll = x.accessAll
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.description = x.description
            this.destinationCidr = x.destinationCidr
            this.groupId = x.groupId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.AuthorizationRule = AuthorizationRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ClientVpnAuthorizationRuleStatus] inside the given [block]
         */
        fun status(block: aws.sdk.kotlin.services.ec2.model.ClientVpnAuthorizationRuleStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.ec2.model.ClientVpnAuthorizationRuleStatus.invoke(block)
        }
    }
}
