// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for BundleInstance.
 */
class BundleInstanceRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The ID of the instance to bundle.
     *
     * Type: String
     *
     * Default: None
     *
     * Required: Yes
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
     */
    val storage: aws.sdk.kotlin.services.ec2.model.Storage? = builder.storage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.BundleInstanceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BundleInstanceRequest(")
        append("dryRun=$dryRun,")
        append("instanceId=$instanceId,")
        append("storage=$storage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (storage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BundleInstanceRequest

        if (dryRun != other.dryRun) return false
        if (instanceId != other.instanceId) return false
        if (storage != other.storage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.BundleInstanceRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The ID of the instance to bundle.
         *
         * Type: String
         *
         * Default: None
         *
         * Required: Yes
         */
        var instanceId: kotlin.String? = null
        /**
         * The bucket in which to store the AMI. You can specify a bucket that you already own or a new bucket that Amazon EC2 creates on your behalf. If you specify a bucket that belongs to someone else, Amazon EC2 returns an error.
         */
        var storage: aws.sdk.kotlin.services.ec2.model.Storage? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.BundleInstanceRequest) : this() {
            this.dryRun = x.dryRun
            this.instanceId = x.instanceId
            this.storage = x.storage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.BundleInstanceRequest = BundleInstanceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.Storage] inside the given [block]
         */
        fun storage(block: aws.sdk.kotlin.services.ec2.model.Storage.Builder.() -> kotlin.Unit) {
            this.storage = aws.sdk.kotlin.services.ec2.model.Storage.invoke(block)
        }
    }
}
