// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes an instance's Capacity Reservation targeting option. You can specify only one parameter at a time. If you specify `CapacityReservationPreference` and `CapacityReservationTarget`, the request fails.
 *
 * Use the `CapacityReservationPreference` parameter to configure the instance to run as an On-Demand Instance or to run in any `open` Capacity Reservation that has matching attributes (instance type, platform, Availability Zone). Use the `CapacityReservationTarget` parameter to explicitly target a specific Capacity Reservation or a Capacity Reservation group.
 */
class CapacityReservationSpecification private constructor(builder: Builder) {
    /**
     * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
     * + `open` - The instance can run in any `open` Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
     * + `none` - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.
     */
    val capacityReservationPreference: aws.sdk.kotlin.services.ec2.model.CapacityReservationPreference? = builder.capacityReservationPreference
    /**
     * Information about the target Capacity Reservation or Capacity Reservation group.
     */
    val capacityReservationTarget: aws.sdk.kotlin.services.ec2.model.CapacityReservationTarget? = builder.capacityReservationTarget

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapacityReservationSpecification(")
        append("capacityReservationPreference=$capacityReservationPreference,")
        append("capacityReservationTarget=$capacityReservationTarget)")
    }

    override fun hashCode(): kotlin.Int {
        var result = capacityReservationPreference?.hashCode() ?: 0
        result = 31 * result + (capacityReservationTarget?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapacityReservationSpecification

        if (capacityReservationPreference != other.capacityReservationPreference) return false
        if (capacityReservationTarget != other.capacityReservationTarget) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates the instance's Capacity Reservation preferences. Possible preferences include:
         * + `open` - The instance can run in any `open` Capacity Reservation that has matching attributes (instance type, platform, Availability Zone).
         * + `none` - The instance avoids running in a Capacity Reservation even if one is available. The instance runs as an On-Demand Instance.
         */
        var capacityReservationPreference: aws.sdk.kotlin.services.ec2.model.CapacityReservationPreference? = null
        /**
         * Information about the target Capacity Reservation or Capacity Reservation group.
         */
        var capacityReservationTarget: aws.sdk.kotlin.services.ec2.model.CapacityReservationTarget? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecification) : this() {
            this.capacityReservationPreference = x.capacityReservationPreference
            this.capacityReservationTarget = x.capacityReservationTarget
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecification = CapacityReservationSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CapacityReservationTarget] inside the given [block]
         */
        fun capacityReservationTarget(block: aws.sdk.kotlin.services.ec2.model.CapacityReservationTarget.Builder.() -> kotlin.Unit) {
            this.capacityReservationTarget = aws.sdk.kotlin.services.ec2.model.CapacityReservationTarget.invoke(block)
        }
    }
}
