// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

class CreateCapacityReservationRequest private constructor(builder: Builder) {
    /**
     * The Availability Zone in which to create the Capacity Reservation.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The ID of the Availability Zone in which to create the Capacity Reservation.
     */
    val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [Ensure Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.
     */
    val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to `expired` when it reaches its end date and time.
     *
     * You must provide an `EndDate` value if `EndDateType` is `limited`. Omit `EndDate` if `EndDateType` is `unlimited`.
     *
     * If the `EndDateType` is `limited`, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
     */
    val endDate: aws.smithy.kotlin.runtime.time.Instant? = builder.endDate
    /**
     * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:
     * + `unlimited` - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an `EndDate` if the `EndDateType` is `unlimited`.
     * + `limited` - The Capacity Reservation expires automatically at a specified date and time. You must provide an `EndDate` value if the `EndDateType` value is `limited`.
     */
    val endDateType: aws.sdk.kotlin.services.ec2.model.EndDateType? = builder.endDateType
    /**
     * Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
     */
    val ephemeralStorage: kotlin.Boolean? = builder.ephemeralStorage
    /**
     * The number of instances for which to reserve capacity.
     *
     * Valid range: 1 - 1000
     */
    val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
     * + `open` - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.
     * + `targeted` - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.
     *
     * Default: `open`
     */
    val instanceMatchCriteria: aws.sdk.kotlin.services.ec2.model.InstanceMatchCriteria? = builder.instanceMatchCriteria
    /**
     * The type of operating system for which to reserve capacity.
     */
    val instancePlatform: aws.sdk.kotlin.services.ec2.model.CapacityReservationInstancePlatform? = builder.instancePlatform
    /**
     * The instance type for which to reserve capacity. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide*.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
     */
    val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation. For more information, see [ Capacity Reservations for cluster placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html) in the *Amazon EC2 User Guide*.
     */
    val placementGroupArn: kotlin.String? = builder.placementGroupArn
    /**
     * The tags to apply to the Capacity Reservation during launch.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:
     * + `default` - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
     * + `dedicated` - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
     */
    val tenancy: aws.sdk.kotlin.services.ec2.model.CapacityReservationTenancy? = builder.tenancy

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateCapacityReservationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCapacityReservationRequest(")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("ebsOptimized=$ebsOptimized,")
        append("endDate=$endDate,")
        append("endDateType=$endDateType,")
        append("ephemeralStorage=$ephemeralStorage,")
        append("instanceCount=$instanceCount,")
        append("instanceMatchCriteria=$instanceMatchCriteria,")
        append("instancePlatform=$instancePlatform,")
        append("instanceType=$instanceType,")
        append("outpostArn=$outpostArn,")
        append("placementGroupArn=$placementGroupArn,")
        append("tagSpecifications=$tagSpecifications,")
        append("tenancy=$tenancy)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (endDateType?.hashCode() ?: 0)
        result = 31 * result + (ephemeralStorage?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceMatchCriteria?.hashCode() ?: 0)
        result = 31 * result + (instancePlatform?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (placementGroupArn?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (tenancy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCapacityReservationRequest

        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (endDate != other.endDate) return false
        if (endDateType != other.endDateType) return false
        if (ephemeralStorage != other.ephemeralStorage) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceMatchCriteria != other.instanceMatchCriteria) return false
        if (instancePlatform != other.instancePlatform) return false
        if (instanceType != other.instanceType) return false
        if (outpostArn != other.outpostArn) return false
        if (placementGroupArn != other.placementGroupArn) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (tenancy != other.tenancy) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateCapacityReservationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zone in which to create the Capacity Reservation.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The ID of the Availability Zone in which to create the Capacity Reservation.
         */
        var availabilityZoneId: kotlin.String? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [Ensure Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        var clientToken: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * Indicates whether the Capacity Reservation supports EBS-optimized instances. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS- optimized instance.
         */
        var ebsOptimized: kotlin.Boolean? = null
        /**
         * The date and time at which the Capacity Reservation expires. When a Capacity Reservation expires, the reserved capacity is released and you can no longer launch instances into it. The Capacity Reservation's state changes to `expired` when it reaches its end date and time.
         *
         * You must provide an `EndDate` value if `EndDateType` is `limited`. Omit `EndDate` if `EndDateType` is `unlimited`.
         *
         * If the `EndDateType` is `limited`, the Capacity Reservation is cancelled within an hour from the specified time. For example, if you specify 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end between 13:30:55 and 14:30:55 on 5/31/2019.
         */
        var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates the way in which the Capacity Reservation ends. A Capacity Reservation can have one of the following end types:
         * + `unlimited` - The Capacity Reservation remains active until you explicitly cancel it. Do not provide an `EndDate` if the `EndDateType` is `unlimited`.
         * + `limited` - The Capacity Reservation expires automatically at a specified date and time. You must provide an `EndDate` value if the `EndDateType` value is `limited`.
         */
        var endDateType: aws.sdk.kotlin.services.ec2.model.EndDateType? = null
        /**
         * Indicates whether the Capacity Reservation supports instances with temporary, block-level storage.
         */
        var ephemeralStorage: kotlin.Boolean? = null
        /**
         * The number of instances for which to reserve capacity.
         *
         * Valid range: 1 - 1000
         */
        var instanceCount: kotlin.Int? = null
        /**
         * Indicates the type of instance launches that the Capacity Reservation accepts. The options include:
         * + `open` - The Capacity Reservation automatically matches all instances that have matching attributes (instance type, platform, and Availability Zone). Instances that have matching attributes run in the Capacity Reservation automatically without specifying any additional parameters.
         * + `targeted` - The Capacity Reservation only accepts instances that have matching attributes (instance type, platform, and Availability Zone), and explicitly target the Capacity Reservation. This ensures that only permitted instances can use the reserved capacity.
         *
         * Default: `open`
         */
        var instanceMatchCriteria: aws.sdk.kotlin.services.ec2.model.InstanceMatchCriteria? = null
        /**
         * The type of operating system for which to reserve capacity.
         */
        var instancePlatform: aws.sdk.kotlin.services.ec2.model.CapacityReservationInstancePlatform? = null
        /**
         * The instance type for which to reserve capacity. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide*.
         */
        var instanceType: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost on which to create the Capacity Reservation.
         */
        var outpostArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the cluster placement group in which to create the Capacity Reservation. For more information, see [ Capacity Reservations for cluster placement groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/cr-cpg.html) in the *Amazon EC2 User Guide*.
         */
        var placementGroupArn: kotlin.String? = null
        /**
         * The tags to apply to the Capacity Reservation during launch.
         */
        var tagSpecifications: List<TagSpecification>? = null
        /**
         * Indicates the tenancy of the Capacity Reservation. A Capacity Reservation can have one of the following tenancy settings:
         * + `default` - The Capacity Reservation is created on hardware that is shared with other Amazon Web Services accounts.
         * + `dedicated` - The Capacity Reservation is created on single-tenant hardware that is dedicated to a single Amazon Web Services account.
         */
        var tenancy: aws.sdk.kotlin.services.ec2.model.CapacityReservationTenancy? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateCapacityReservationRequest) : this() {
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.ebsOptimized = x.ebsOptimized
            this.endDate = x.endDate
            this.endDateType = x.endDateType
            this.ephemeralStorage = x.ephemeralStorage
            this.instanceCount = x.instanceCount
            this.instanceMatchCriteria = x.instanceMatchCriteria
            this.instancePlatform = x.instancePlatform
            this.instanceType = x.instanceType
            this.outpostArn = x.outpostArn
            this.placementGroupArn = x.placementGroupArn
            this.tagSpecifications = x.tagSpecifications
            this.tenancy = x.tenancy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateCapacityReservationRequest = CreateCapacityReservationRequest(this)
    }
}
