// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateClientVpnRouteRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to ensure idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The ID of the Client VPN endpoint to which to add the route.
     */
    val clientVpnEndpointId: kotlin.String? = builder.clientVpnEndpointId
    /**
     * A brief description of the route.
     */
    val description: kotlin.String? = builder.description
    /**
     * The IPv4 address range, in CIDR notation, of the route destination. For example:
     * + To add a route for Internet access, enter `0.0.0.0/0`
     * + To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range
     * + To add a route for an on-premises network, enter the Amazon Web Services Site-to-Site VPN connection's IPv4 CIDR range
     * + To add a route for the local network, enter the client CIDR range
     */
    val destinationCidrBlock: kotlin.String? = builder.destinationCidrBlock
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The ID of the subnet through which you want to route traffic. The specified subnet must be an existing target network of the Client VPN endpoint.
     *
     * Alternatively, if you're adding a route for the local network, specify `local`.
     */
    val targetVpcSubnetId: kotlin.String? = builder.targetVpcSubnetId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateClientVpnRouteRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClientVpnRouteRequest(")
        append("clientToken=$clientToken,")
        append("clientVpnEndpointId=$clientVpnEndpointId,")
        append("description=$description,")
        append("destinationCidrBlock=$destinationCidrBlock,")
        append("dryRun=$dryRun,")
        append("targetVpcSubnetId=$targetVpcSubnetId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (clientVpnEndpointId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (destinationCidrBlock?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (targetVpcSubnetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClientVpnRouteRequest

        if (clientToken != other.clientToken) return false
        if (clientVpnEndpointId != other.clientVpnEndpointId) return false
        if (description != other.description) return false
        if (destinationCidrBlock != other.destinationCidrBlock) return false
        if (dryRun != other.dryRun) return false
        if (targetVpcSubnetId != other.targetVpcSubnetId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateClientVpnRouteRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to ensure idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        var clientToken: kotlin.String? = null
        /**
         * The ID of the Client VPN endpoint to which to add the route.
         */
        var clientVpnEndpointId: kotlin.String? = null
        /**
         * A brief description of the route.
         */
        var description: kotlin.String? = null
        /**
         * The IPv4 address range, in CIDR notation, of the route destination. For example:
         * + To add a route for Internet access, enter `0.0.0.0/0`
         * + To add a route for a peered VPC, enter the peered VPC's IPv4 CIDR range
         * + To add a route for an on-premises network, enter the Amazon Web Services Site-to-Site VPN connection's IPv4 CIDR range
         * + To add a route for the local network, enter the client CIDR range
         */
        var destinationCidrBlock: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The ID of the subnet through which you want to route traffic. The specified subnet must be an existing target network of the Client VPN endpoint.
         *
         * Alternatively, if you're adding a route for the local network, specify `local`.
         */
        var targetVpcSubnetId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateClientVpnRouteRequest) : this() {
            this.clientToken = x.clientToken
            this.clientVpnEndpointId = x.clientVpnEndpointId
            this.description = x.description
            this.destinationCidrBlock = x.destinationCidrBlock
            this.dryRun = x.dryRun
            this.targetVpcSubnetId = x.targetVpcSubnetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateClientVpnRouteRequest = CreateClientVpnRouteRequest(this)
    }
}
