// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateFlowLogsRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to ensure idempotency](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
     *
     * If you specify `LogDestinationType` as `s3`, do not specify `DeliverLogsPermissionArn` or `LogGroupName`.
     */
    val deliverLogsPermissionArn: kotlin.String? = builder.deliverLogsPermissionArn
    /**
     * The destination options.
     */
    val destinationOptions: aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest? = builder.destinationOptions
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The destination to which the flow log data is to be published. Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for `LogDestinationType`.
     *
     * If `LogDestinationType` is not specified or `cloud-watch-logs`, specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called `my-logs`, specify `arn:aws:logs:us-east-1:123456789012:log-group:my-logs`. Alternatively, use `LogGroupName` instead.
     *
     * If LogDestinationType is `s3`, specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: `bucket_ARN/subfolder_name/`. For example, to specify a subfolder named `my-logs` in a bucket named `my-bucket`, use the following ARN: `arn:aws:s3:::my-bucket/my-logs/`. You cannot use `AWSLogs` as a subfolder name. This is a reserved term.
     */
    val logDestination: kotlin.String? = builder.logDestination
    /**
     * The type of destination to which the flow log data is to be published. Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify `cloud-watch-logs`. To publish flow log data to Amazon S3, specify `s3`.
     *
     * If you specify `LogDestinationType` as `s3`, do not specify `DeliverLogsPermissionArn` or `LogGroupName`.
     *
     * Default: `cloud-watch-logs`
     */
    val logDestinationType: aws.sdk.kotlin.services.ec2.model.LogDestinationType? = builder.logDestinationType
    /**
     * The fields to include in the flow log record, in the order in which they should appear. For a list of available fields, see [Flow log records](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records). If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.
     *
     * Specify the fields using the `${field-id}` format, separated by spaces. For the CLI, surround this parameter value with single quotes on Linux or double quotes on Windows.
     */
    val logFormat: kotlin.String? = builder.logFormat
    /**
     * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
     *
     * If you specify `LogDestinationType` as `s3`, do not specify `DeliverLogsPermissionArn` or `LogGroupName`.
     */
    val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
     *
     * When a network interface is attached to a [Nitro-based instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances), the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
     *
     * Default: 600
     */
    val maxAggregationInterval: kotlin.Int? = builder.maxAggregationInterval
    /**
     * The ID of the subnet, network interface, or VPC for which you want to create a flow log.
     *
     * Constraints: Maximum of 1000 resources
     */
    val resourceIds: List<String>? = builder.resourceIds
    /**
     * The type of resource for which to create the flow log. For example, if you specified a VPC ID for the `ResourceId` property, specify `VPC` for this property.
     */
    val resourceType: aws.sdk.kotlin.services.ec2.model.FlowLogsResourceType? = builder.resourceType
    /**
     * The tags to apply to the flow logs.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The type of traffic to log. You can log traffic that the resource accepts or rejects, or all traffic.
     */
    val trafficType: aws.sdk.kotlin.services.ec2.model.TrafficType? = builder.trafficType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateFlowLogsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFlowLogsRequest(")
        append("clientToken=$clientToken,")
        append("deliverLogsPermissionArn=$deliverLogsPermissionArn,")
        append("destinationOptions=$destinationOptions,")
        append("dryRun=$dryRun,")
        append("logDestination=$logDestination,")
        append("logDestinationType=$logDestinationType,")
        append("logFormat=$logFormat,")
        append("logGroupName=$logGroupName,")
        append("maxAggregationInterval=$maxAggregationInterval,")
        append("resourceIds=$resourceIds,")
        append("resourceType=$resourceType,")
        append("tagSpecifications=$tagSpecifications,")
        append("trafficType=$trafficType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (deliverLogsPermissionArn?.hashCode() ?: 0)
        result = 31 * result + (destinationOptions?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (logDestination?.hashCode() ?: 0)
        result = 31 * result + (logDestinationType?.hashCode() ?: 0)
        result = 31 * result + (logFormat?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (maxAggregationInterval ?: 0)
        result = 31 * result + (resourceIds?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (trafficType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFlowLogsRequest

        if (clientToken != other.clientToken) return false
        if (deliverLogsPermissionArn != other.deliverLogsPermissionArn) return false
        if (destinationOptions != other.destinationOptions) return false
        if (dryRun != other.dryRun) return false
        if (logDestination != other.logDestination) return false
        if (logDestinationType != other.logDestinationType) return false
        if (logFormat != other.logFormat) return false
        if (logGroupName != other.logGroupName) return false
        if (maxAggregationInterval != other.maxAggregationInterval) return false
        if (resourceIds != other.resourceIds) return false
        if (resourceType != other.resourceType) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (trafficType != other.trafficType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateFlowLogsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to ensure idempotency](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
         */
        var clientToken: kotlin.String? = null
        /**
         * The ARN for the IAM role that permits Amazon EC2 to publish flow logs to a CloudWatch Logs log group in your account.
         *
         * If you specify `LogDestinationType` as `s3`, do not specify `DeliverLogsPermissionArn` or `LogGroupName`.
         */
        var deliverLogsPermissionArn: kotlin.String? = null
        /**
         * The destination options.
         */
        var destinationOptions: aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The destination to which the flow log data is to be published. Flow log data can be published to a CloudWatch Logs log group or an Amazon S3 bucket. The value specified for this parameter depends on the value specified for `LogDestinationType`.
         *
         * If `LogDestinationType` is not specified or `cloud-watch-logs`, specify the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For example, to publish to a log group called `my-logs`, specify `arn:aws:logs:us-east-1:123456789012:log-group:my-logs`. Alternatively, use `LogGroupName` instead.
         *
         * If LogDestinationType is `s3`, specify the ARN of the Amazon S3 bucket. You can also specify a subfolder in the bucket. To specify a subfolder in the bucket, use the following ARN format: `bucket_ARN/subfolder_name/`. For example, to specify a subfolder named `my-logs` in a bucket named `my-bucket`, use the following ARN: `arn:aws:s3:::my-bucket/my-logs/`. You cannot use `AWSLogs` as a subfolder name. This is a reserved term.
         */
        var logDestination: kotlin.String? = null
        /**
         * The type of destination to which the flow log data is to be published. Flow log data can be published to CloudWatch Logs or Amazon S3. To publish flow log data to CloudWatch Logs, specify `cloud-watch-logs`. To publish flow log data to Amazon S3, specify `s3`.
         *
         * If you specify `LogDestinationType` as `s3`, do not specify `DeliverLogsPermissionArn` or `LogGroupName`.
         *
         * Default: `cloud-watch-logs`
         */
        var logDestinationType: aws.sdk.kotlin.services.ec2.model.LogDestinationType? = null
        /**
         * The fields to include in the flow log record, in the order in which they should appear. For a list of available fields, see [Flow log records](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records). If you omit this parameter, the flow log is created using the default format. If you specify this parameter, you must specify at least one field.
         *
         * Specify the fields using the `${field-id}` format, separated by spaces. For the CLI, surround this parameter value with single quotes on Linux or double quotes on Windows.
         */
        var logFormat: kotlin.String? = null
        /**
         * The name of a new or existing CloudWatch Logs log group where Amazon EC2 publishes your flow logs.
         *
         * If you specify `LogDestinationType` as `s3`, do not specify `DeliverLogsPermissionArn` or `LogGroupName`.
         */
        var logGroupName: kotlin.String? = null
        /**
         * The maximum interval of time during which a flow of packets is captured and aggregated into a flow log record. You can specify 60 seconds (1 minute) or 600 seconds (10 minutes).
         *
         * When a network interface is attached to a [Nitro-based instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances), the aggregation interval is always 60 seconds or less, regardless of the value that you specify.
         *
         * Default: 600
         */
        var maxAggregationInterval: kotlin.Int? = null
        /**
         * The ID of the subnet, network interface, or VPC for which you want to create a flow log.
         *
         * Constraints: Maximum of 1000 resources
         */
        var resourceIds: List<String>? = null
        /**
         * The type of resource for which to create the flow log. For example, if you specified a VPC ID for the `ResourceId` property, specify `VPC` for this property.
         */
        var resourceType: aws.sdk.kotlin.services.ec2.model.FlowLogsResourceType? = null
        /**
         * The tags to apply to the flow logs.
         */
        var tagSpecifications: List<TagSpecification>? = null
        /**
         * The type of traffic to log. You can log traffic that the resource accepts or rejects, or all traffic.
         */
        var trafficType: aws.sdk.kotlin.services.ec2.model.TrafficType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateFlowLogsRequest) : this() {
            this.clientToken = x.clientToken
            this.deliverLogsPermissionArn = x.deliverLogsPermissionArn
            this.destinationOptions = x.destinationOptions
            this.dryRun = x.dryRun
            this.logDestination = x.logDestination
            this.logDestinationType = x.logDestinationType
            this.logFormat = x.logFormat
            this.logGroupName = x.logGroupName
            this.maxAggregationInterval = x.maxAggregationInterval
            this.resourceIds = x.resourceIds
            this.resourceType = x.resourceType
            this.tagSpecifications = x.tagSpecifications
            this.trafficType = x.trafficType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateFlowLogsRequest = CreateFlowLogsRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest] inside the given [block]
         */
        fun destinationOptions(block: aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest.Builder.() -> kotlin.Unit) {
            this.destinationOptions = aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest.invoke(block)
        }
    }
}
