// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateInstanceEventWindowRequest private constructor(builder: Builder) {
    /**
     * The cron expression for the event window, for example, `* 0-4,20-23 * * 1,5`. If you specify a cron expression, you can't specify a time range.
     *
     * Constraints:
     * + Only hour and day of the week values are supported.
     * + For day of the week values, you can specify either integers `0` through `6`, or alternative single values `SUN` through `SAT`.
     * + The minute, month, and year must be specified by `*`.
     * + The hour value must be one or a multiple range, for example, `0-4` or `0-4,20-23`.
     * + Each hour range must be >= 2 hours, for example, `0-2` or `20-23`.
     * + The event window must be >= 4 hours. The combined total time ranges in the event window must be >= 4 hours.
     *
     * For more information about cron expressions, see [cron](https://en.wikipedia.org/wiki/Cron) on the *Wikipedia website*.
     */
    val cronExpression: kotlin.String? = builder.cronExpression
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The name of the event window.
     */
    val name: kotlin.String? = builder.name
    /**
     * The tags to apply to the event window.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The time range for the event window. If you specify a time range, you can't specify a cron expression.
     */
    val timeRanges: List<InstanceEventWindowTimeRangeRequest>? = builder.timeRanges

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateInstanceEventWindowRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateInstanceEventWindowRequest(")
        append("cronExpression=$cronExpression,")
        append("dryRun=$dryRun,")
        append("name=$name,")
        append("tagSpecifications=$tagSpecifications,")
        append("timeRanges=$timeRanges)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cronExpression?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (timeRanges?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateInstanceEventWindowRequest

        if (cronExpression != other.cronExpression) return false
        if (dryRun != other.dryRun) return false
        if (name != other.name) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (timeRanges != other.timeRanges) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateInstanceEventWindowRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The cron expression for the event window, for example, `* 0-4,20-23 * * 1,5`. If you specify a cron expression, you can't specify a time range.
         *
         * Constraints:
         * + Only hour and day of the week values are supported.
         * + For day of the week values, you can specify either integers `0` through `6`, or alternative single values `SUN` through `SAT`.
         * + The minute, month, and year must be specified by `*`.
         * + The hour value must be one or a multiple range, for example, `0-4` or `0-4,20-23`.
         * + Each hour range must be >= 2 hours, for example, `0-2` or `20-23`.
         * + The event window must be >= 4 hours. The combined total time ranges in the event window must be >= 4 hours.
         *
         * For more information about cron expressions, see [cron](https://en.wikipedia.org/wiki/Cron) on the *Wikipedia website*.
         */
        var cronExpression: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The name of the event window.
         */
        var name: kotlin.String? = null
        /**
         * The tags to apply to the event window.
         */
        var tagSpecifications: List<TagSpecification>? = null
        /**
         * The time range for the event window. If you specify a time range, you can't specify a cron expression.
         */
        var timeRanges: List<InstanceEventWindowTimeRangeRequest>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateInstanceEventWindowRequest) : this() {
            this.cronExpression = x.cronExpression
            this.dryRun = x.dryRun
            this.name = x.name
            this.tagSpecifications = x.tagSpecifications
            this.timeRanges = x.timeRanges
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateInstanceEventWindowRequest = CreateInstanceEventWindowRequest(this)
    }
}
