// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateIpamPoolRequest private constructor(builder: Builder) {
    /**
     * The IP protocol assigned to this IPAM pool. You must choose either IPv4 or IPv6 protocol for a pool.
     */
    val addressFamily: aws.sdk.kotlin.services.ec2.model.AddressFamily? = builder.addressFamily
    /**
     * The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
     */
    val allocationDefaultNetmaskLength: kotlin.Int? = builder.allocationDefaultNetmaskLength
    /**
     * The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. The maximum netmask length must be greater than the minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
     */
    val allocationMaxNetmaskLength: kotlin.Int? = builder.allocationMaxNetmaskLength
    /**
     * The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. The minimum netmask length must be less than the maximum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
     */
    val allocationMinNetmaskLength: kotlin.Int? = builder.allocationMinNetmaskLength
    /**
     * Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
     */
    val allocationResourceTags: List<RequestIpamResourceTag>? = builder.allocationResourceTags
    /**
     * If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only.
     *
     * A locale must be set on the pool for this feature to work.
     */
    val autoImport: kotlin.Boolean? = builder.autoImport
    /**
     * Limits which service in Amazon Web Services that the pool can be used in. "ec2", for example, allows users to use space for Elastic IP addresses and VPCs.
     */
    val awsService: aws.sdk.kotlin.services.ec2.model.IpamPoolAwsService? = builder.awsService
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [Ensuring Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * A description for the IPAM pool.
     */
    val description: kotlin.String? = builder.description
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The ID of the scope in which you would like to create the IPAM pool.
     */
    val ipamScopeId: kotlin.String? = builder.ipamScopeId
    /**
     * In IPAM, the locale is the Amazon Web Services Region where you want to make an IPAM pool available for allocations. Only resources in the same Region as the locale of the pool can get IP address allocations from the pool. You can only allocate a CIDR for a VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that once you choose a Locale for a pool, you cannot modify it. If you do not choose a locale, resources in Regions others than the IPAM's home region cannot use CIDRs from this pool.
     *
     * Possible values: Any Amazon Web Services Region, such as us-east-1.
     */
    val locale: kotlin.String? = builder.locale
    /**
     * Determines if the pool is publicly advertisable. This option is not available for pools with AddressFamily set to `ipv4`.
     */
    val publiclyAdvertisable: kotlin.Boolean? = builder.publiclyAdvertisable
    /**
     * The ID of the source IPAM pool. Use this option to create a pool within an existing pool. Note that the CIDR you provision for the pool within the source pool must be available in the source pool's CIDR range.
     */
    val sourceIpamPoolId: kotlin.String? = builder.sourceIpamPoolId
    /**
     * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateIpamPoolRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIpamPoolRequest(")
        append("addressFamily=$addressFamily,")
        append("allocationDefaultNetmaskLength=$allocationDefaultNetmaskLength,")
        append("allocationMaxNetmaskLength=$allocationMaxNetmaskLength,")
        append("allocationMinNetmaskLength=$allocationMinNetmaskLength,")
        append("allocationResourceTags=$allocationResourceTags,")
        append("autoImport=$autoImport,")
        append("awsService=$awsService,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("ipamScopeId=$ipamScopeId,")
        append("locale=$locale,")
        append("publiclyAdvertisable=$publiclyAdvertisable,")
        append("sourceIpamPoolId=$sourceIpamPoolId,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressFamily?.hashCode() ?: 0
        result = 31 * result + (allocationDefaultNetmaskLength ?: 0)
        result = 31 * result + (allocationMaxNetmaskLength ?: 0)
        result = 31 * result + (allocationMinNetmaskLength ?: 0)
        result = 31 * result + (allocationResourceTags?.hashCode() ?: 0)
        result = 31 * result + (autoImport?.hashCode() ?: 0)
        result = 31 * result + (awsService?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (ipamScopeId?.hashCode() ?: 0)
        result = 31 * result + (locale?.hashCode() ?: 0)
        result = 31 * result + (publiclyAdvertisable?.hashCode() ?: 0)
        result = 31 * result + (sourceIpamPoolId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIpamPoolRequest

        if (addressFamily != other.addressFamily) return false
        if (allocationDefaultNetmaskLength != other.allocationDefaultNetmaskLength) return false
        if (allocationMaxNetmaskLength != other.allocationMaxNetmaskLength) return false
        if (allocationMinNetmaskLength != other.allocationMinNetmaskLength) return false
        if (allocationResourceTags != other.allocationResourceTags) return false
        if (autoImport != other.autoImport) return false
        if (awsService != other.awsService) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (ipamScopeId != other.ipamScopeId) return false
        if (locale != other.locale) return false
        if (publiclyAdvertisable != other.publiclyAdvertisable) return false
        if (sourceIpamPoolId != other.sourceIpamPoolId) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateIpamPoolRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The IP protocol assigned to this IPAM pool. You must choose either IPv4 or IPv6 protocol for a pool.
         */
        var addressFamily: aws.sdk.kotlin.services.ec2.model.AddressFamily? = null
        /**
         * The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
         */
        var allocationDefaultNetmaskLength: kotlin.Int? = null
        /**
         * The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. The maximum netmask length must be greater than the minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
         */
        var allocationMaxNetmaskLength: kotlin.Int? = null
        /**
         * The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. The minimum netmask length must be less than the maximum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
         */
        var allocationMinNetmaskLength: kotlin.Int? = null
        /**
         * Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
         */
        var allocationResourceTags: List<RequestIpamResourceTag>? = null
        /**
         * If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only.
         *
         * A locale must be set on the pool for this feature to work.
         */
        var autoImport: kotlin.Boolean? = null
        /**
         * Limits which service in Amazon Web Services that the pool can be used in. "ec2", for example, allows users to use space for Elastic IP addresses and VPCs.
         */
        var awsService: aws.sdk.kotlin.services.ec2.model.IpamPoolAwsService? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [Ensuring Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        var clientToken: kotlin.String? = null
        /**
         * A description for the IPAM pool.
         */
        var description: kotlin.String? = null
        /**
         * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The ID of the scope in which you would like to create the IPAM pool.
         */
        var ipamScopeId: kotlin.String? = null
        /**
         * In IPAM, the locale is the Amazon Web Services Region where you want to make an IPAM pool available for allocations. Only resources in the same Region as the locale of the pool can get IP address allocations from the pool. You can only allocate a CIDR for a VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that once you choose a Locale for a pool, you cannot modify it. If you do not choose a locale, resources in Regions others than the IPAM's home region cannot use CIDRs from this pool.
         *
         * Possible values: Any Amazon Web Services Region, such as us-east-1.
         */
        var locale: kotlin.String? = null
        /**
         * Determines if the pool is publicly advertisable. This option is not available for pools with AddressFamily set to `ipv4`.
         */
        var publiclyAdvertisable: kotlin.Boolean? = null
        /**
         * The ID of the source IPAM pool. Use this option to create a pool within an existing pool. Note that the CIDR you provision for the pool within the source pool must be available in the source pool's CIDR range.
         */
        var sourceIpamPoolId: kotlin.String? = null
        /**
         * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         */
        var tagSpecifications: List<TagSpecification>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateIpamPoolRequest) : this() {
            this.addressFamily = x.addressFamily
            this.allocationDefaultNetmaskLength = x.allocationDefaultNetmaskLength
            this.allocationMaxNetmaskLength = x.allocationMaxNetmaskLength
            this.allocationMinNetmaskLength = x.allocationMinNetmaskLength
            this.allocationResourceTags = x.allocationResourceTags
            this.autoImport = x.autoImport
            this.awsService = x.awsService
            this.clientToken = x.clientToken
            this.description = x.description
            this.dryRun = x.dryRun
            this.ipamScopeId = x.ipamScopeId
            this.locale = x.locale
            this.publiclyAdvertisable = x.publiclyAdvertisable
            this.sourceIpamPoolId = x.sourceIpamPoolId
            this.tagSpecifications = x.tagSpecifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateIpamPoolRequest = CreateIpamPoolRequest(this)
    }
}
