// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateRestoreImageTaskRequest private constructor(builder: Builder) {
    /**
     * The name of the Amazon S3 bucket that contains the stored AMI object.
     */
    val bucket: kotlin.String? = builder.bucket
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The name for the restored AMI. The name must be unique for AMIs in the Region for this account. If you do not provide a name, the new AMI gets the same name as the original AMI.
     */
    val name: kotlin.String? = builder.name
    /**
     * The name of the stored AMI object in the bucket.
     */
    val objectKey: kotlin.String? = builder.objectKey
    /**
     * The tags to apply to the AMI and snapshots on restoration. You can tag the AMI, the snapshots, or both.
     * + To tag the AMI, the value for `ResourceType` must be `image`.
     * + To tag the snapshots, the value for `ResourceType` must be `snapshot`. The same tag is applied to all of the snapshots that are created.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateRestoreImageTaskRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRestoreImageTaskRequest(")
        append("bucket=$bucket,")
        append("dryRun=$dryRun,")
        append("name=$name,")
        append("objectKey=$objectKey,")
        append("tagSpecifications=$tagSpecifications)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (objectKey?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRestoreImageTaskRequest

        if (bucket != other.bucket) return false
        if (dryRun != other.dryRun) return false
        if (name != other.name) return false
        if (objectKey != other.objectKey) return false
        if (tagSpecifications != other.tagSpecifications) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateRestoreImageTaskRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the Amazon S3 bucket that contains the stored AMI object.
         */
        var bucket: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The name for the restored AMI. The name must be unique for AMIs in the Region for this account. If you do not provide a name, the new AMI gets the same name as the original AMI.
         */
        var name: kotlin.String? = null
        /**
         * The name of the stored AMI object in the bucket.
         */
        var objectKey: kotlin.String? = null
        /**
         * The tags to apply to the AMI and snapshots on restoration. You can tag the AMI, the snapshots, or both.
         * + To tag the AMI, the value for `ResourceType` must be `image`.
         * + To tag the snapshots, the value for `ResourceType` must be `snapshot`. The same tag is applied to all of the snapshots that are created.
         */
        var tagSpecifications: List<TagSpecification>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateRestoreImageTaskRequest) : this() {
            this.bucket = x.bucket
            this.dryRun = x.dryRun
            this.name = x.name
            this.objectKey = x.objectKey
            this.tagSpecifications = x.tagSpecifications
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateRestoreImageTaskRequest = CreateRestoreImageTaskRequest(this)
    }
}
