// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class CreateTrafficMirrorSessionRequest private constructor(builder: Builder) {
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to ensure idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The description of the Traffic Mirror session.
     */
    val description: kotlin.String? = builder.description
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The ID of the source network interface.
     */
    val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target.
     *
     * If you do not want to mirror the entire packet, use the `PacketLength` parameter to specify the number of bytes in each packet to mirror.
     */
    val packetLength: kotlin.Int? = builder.packetLength
    /**
     * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
     *
     * Valid values are 1-32766.
     */
    val sessionNumber: kotlin.Int? = builder.sessionNumber
    /**
     * The tags to assign to a Traffic Mirror session.
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The ID of the Traffic Mirror filter.
     */
    val trafficMirrorFilterId: kotlin.String? = builder.trafficMirrorFilterId
    /**
     * The ID of the Traffic Mirror target.
     */
    val trafficMirrorTargetId: kotlin.String? = builder.trafficMirrorTargetId
    /**
     * The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see [RFC 7348](https://tools.ietf.org/html/rfc7348). If you do not specify a `VirtualNetworkId`, an account-wide unique id is chosen at random.
     */
    val virtualNetworkId: kotlin.Int? = builder.virtualNetworkId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CreateTrafficMirrorSessionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTrafficMirrorSessionRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("packetLength=$packetLength,")
        append("sessionNumber=$sessionNumber,")
        append("tagSpecifications=$tagSpecifications,")
        append("trafficMirrorFilterId=$trafficMirrorFilterId,")
        append("trafficMirrorTargetId=$trafficMirrorTargetId,")
        append("virtualNetworkId=$virtualNetworkId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (packetLength ?: 0)
        result = 31 * result + (sessionNumber ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorFilterId?.hashCode() ?: 0)
        result = 31 * result + (trafficMirrorTargetId?.hashCode() ?: 0)
        result = 31 * result + (virtualNetworkId ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTrafficMirrorSessionRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (packetLength != other.packetLength) return false
        if (sessionNumber != other.sessionNumber) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (trafficMirrorFilterId != other.trafficMirrorFilterId) return false
        if (trafficMirrorTargetId != other.trafficMirrorTargetId) return false
        if (virtualNetworkId != other.virtualNetworkId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CreateTrafficMirrorSessionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to ensure idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
         */
        var clientToken: kotlin.String? = null
        /**
         * The description of the Traffic Mirror session.
         */
        var description: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The ID of the source network interface.
         */
        var networkInterfaceId: kotlin.String? = null
        /**
         * The number of bytes in each packet to mirror. These are bytes after the VXLAN header. Do not specify this parameter when you want to mirror the entire packet. To mirror a subset of the packet, set this to the length (in bytes) that you want to mirror. For example, if you set this value to 100, then the first 100 bytes that meet the filter criteria are copied to the target.
         *
         * If you do not want to mirror the entire packet, use the `PacketLength` parameter to specify the number of bytes in each packet to mirror.
         */
        var packetLength: kotlin.Int? = null
        /**
         * The session number determines the order in which sessions are evaluated when an interface is used by multiple sessions. The first session with a matching filter is the one that mirrors the packets.
         *
         * Valid values are 1-32766.
         */
        var sessionNumber: kotlin.Int? = null
        /**
         * The tags to assign to a Traffic Mirror session.
         */
        var tagSpecifications: List<TagSpecification>? = null
        /**
         * The ID of the Traffic Mirror filter.
         */
        var trafficMirrorFilterId: kotlin.String? = null
        /**
         * The ID of the Traffic Mirror target.
         */
        var trafficMirrorTargetId: kotlin.String? = null
        /**
         * The VXLAN ID for the Traffic Mirror session. For more information about the VXLAN protocol, see [RFC 7348](https://tools.ietf.org/html/rfc7348). If you do not specify a `VirtualNetworkId`, an account-wide unique id is chosen at random.
         */
        var virtualNetworkId: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CreateTrafficMirrorSessionRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.dryRun = x.dryRun
            this.networkInterfaceId = x.networkInterfaceId
            this.packetLength = x.packetLength
            this.sessionNumber = x.sessionNumber
            this.tagSpecifications = x.tagSpecifications
            this.trafficMirrorFilterId = x.trafficMirrorFilterId
            this.trafficMirrorTargetId = x.trafficMirrorTargetId
            this.virtualNetworkId = x.virtualNetworkId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CreateTrafficMirrorSessionRequest = CreateTrafficMirrorSessionRequest(this)
    }
}
