// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a customer gateway.
 */
class CustomerGateway private constructor(builder: Builder) {
    /**
     * The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
     */
    val bgpAsn: kotlin.String? = builder.bgpAsn
    /**
     * The Amazon Resource Name (ARN) for the customer gateway certificate.
     */
    val certificateArn: kotlin.String? = builder.certificateArn
    /**
     * The ID of the customer gateway.
     */
    val customerGatewayId: kotlin.String? = builder.customerGatewayId
    /**
     * The name of customer gateway device.
     */
    val deviceName: kotlin.String? = builder.deviceName
    /**
     * The Internet-routable IP address of the customer gateway's outside interface.
     */
    val ipAddress: kotlin.String? = builder.ipAddress
    /**
     * The current state of the customer gateway (`pending | available | deleting | deleted`).
     */
    val state: kotlin.String? = builder.state
    /**
     * Any tags assigned to the customer gateway.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The type of VPN connection the customer gateway supports (`ipsec.1`).
     */
    val type: kotlin.String? = builder.type

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.CustomerGateway = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomerGateway(")
        append("bgpAsn=$bgpAsn,")
        append("certificateArn=$certificateArn,")
        append("customerGatewayId=$customerGatewayId,")
        append("deviceName=$deviceName,")
        append("ipAddress=$ipAddress,")
        append("state=$state,")
        append("tags=$tags,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bgpAsn?.hashCode() ?: 0
        result = 31 * result + (certificateArn?.hashCode() ?: 0)
        result = 31 * result + (customerGatewayId?.hashCode() ?: 0)
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (ipAddress?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomerGateway

        if (bgpAsn != other.bgpAsn) return false
        if (certificateArn != other.certificateArn) return false
        if (customerGatewayId != other.customerGatewayId) return false
        if (deviceName != other.deviceName) return false
        if (ipAddress != other.ipAddress) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (type != other.type) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.CustomerGateway = Builder(this).apply(block).build()

    class Builder {
        /**
         * The customer gateway's Border Gateway Protocol (BGP) Autonomous System Number (ASN).
         */
        var bgpAsn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the customer gateway certificate.
         */
        var certificateArn: kotlin.String? = null
        /**
         * The ID of the customer gateway.
         */
        var customerGatewayId: kotlin.String? = null
        /**
         * The name of customer gateway device.
         */
        var deviceName: kotlin.String? = null
        /**
         * The Internet-routable IP address of the customer gateway's outside interface.
         */
        var ipAddress: kotlin.String? = null
        /**
         * The current state of the customer gateway (`pending | available | deleting | deleted`).
         */
        var state: kotlin.String? = null
        /**
         * Any tags assigned to the customer gateway.
         */
        var tags: List<Tag>? = null
        /**
         * The type of VPN connection the customer gateway supports (`ipsec.1`).
         */
        var type: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.CustomerGateway) : this() {
            this.bgpAsn = x.bgpAsn
            this.certificateArn = x.certificateArn
            this.customerGatewayId = x.customerGatewayId
            this.deviceName = x.deviceName
            this.ipAddress = x.ipAddress
            this.state = x.state
            this.tags = x.tags
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.CustomerGateway = CustomerGateway(this)
    }
}
