// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeHostReservationOfferingsRequest private constructor(builder: Builder) {
    /**
     * The filters.
     * + `instance-family` - The instance family of the offering (for example, `m4`).
     * + `payment-option` - The payment option (`NoUpfront` | `PartialUpfront` | `AllUpfront`).
     */
    val filter: List<Filter>? = builder.filter
    /**
     * This is the maximum duration of the reservation to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 94608000 for three years.
     */
    val maxDuration: kotlin.Int? = builder.maxDuration
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned `nextToken` value. This value can be between 5 and 500. If `maxResults` is given a larger value than 500, you receive an error.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * This is the minimum duration of the reservation you'd like to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 31536000 for one year.
     */
    val minDuration: kotlin.Int? = builder.minDuration
    /**
     * The token to use to retrieve the next page of results.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The ID of the reservation offering.
     */
    val offeringId: kotlin.String? = builder.offeringId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeHostReservationOfferingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeHostReservationOfferingsRequest(")
        append("filter=$filter,")
        append("maxDuration=$maxDuration,")
        append("maxResults=$maxResults,")
        append("minDuration=$minDuration,")
        append("nextToken=$nextToken,")
        append("offeringId=$offeringId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (maxDuration ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (minDuration ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (offeringId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeHostReservationOfferingsRequest

        if (filter != other.filter) return false
        if (maxDuration != other.maxDuration) return false
        if (maxResults != other.maxResults) return false
        if (minDuration != other.minDuration) return false
        if (nextToken != other.nextToken) return false
        if (offeringId != other.offeringId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeHostReservationOfferingsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The filters.
         * + `instance-family` - The instance family of the offering (for example, `m4`).
         * + `payment-option` - The payment option (`NoUpfront` | `PartialUpfront` | `AllUpfront`).
         */
        var filter: List<Filter>? = null
        /**
         * This is the maximum duration of the reservation to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 94608000 for three years.
         */
        var maxDuration: kotlin.Int? = null
        /**
         * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned `nextToken` value. This value can be between 5 and 500. If `maxResults` is given a larger value than 500, you receive an error.
         */
        var maxResults: kotlin.Int? = null
        /**
         * This is the minimum duration of the reservation you'd like to purchase, specified in seconds. Reservations are available in one-year and three-year terms. The number of seconds specified must be the number of seconds in a year (365x24x60x60) times one of the supported durations (1 or 3). For example, specify 31536000 for one year.
         */
        var minDuration: kotlin.Int? = null
        /**
         * The token to use to retrieve the next page of results.
         */
        var nextToken: kotlin.String? = null
        /**
         * The ID of the reservation offering.
         */
        var offeringId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeHostReservationOfferingsRequest) : this() {
            this.filter = x.filter
            this.maxDuration = x.maxDuration
            this.maxResults = x.maxResults
            this.minDuration = x.minDuration
            this.nextToken = x.nextToken
            this.offeringId = x.offeringId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeHostReservationOfferingsRequest = DescribeHostReservationOfferingsRequest(this)
    }
}
