// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeHostReservationsRequest private constructor(builder: Builder) {
    /**
     * The filters.
     * + `instance-family` - The instance family (for example, `m4`).
     * + `payment-option` - The payment option (`NoUpfront` | `PartialUpfront` | `AllUpfront`).
     * + `state` - The state of the reservation (`payment-pending` | `payment-failed` | `active` | `retired`).
     * + `tag:<key>` - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     */
    val filter: List<Filter>? = builder.filter
    /**
     * The host reservation IDs.
     */
    val hostReservationIdSet: List<String>? = builder.hostReservationIdSet
    /**
     * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned `nextToken` value. This value can be between 5 and 500. If `maxResults` is given a larger value than 500, you receive an error.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to use to retrieve the next page of results.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeHostReservationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeHostReservationsRequest(")
        append("filter=$filter,")
        append("hostReservationIdSet=$hostReservationIdSet,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = filter?.hashCode() ?: 0
        result = 31 * result + (hostReservationIdSet?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeHostReservationsRequest

        if (filter != other.filter) return false
        if (hostReservationIdSet != other.hostReservationIdSet) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeHostReservationsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The filters.
         * + `instance-family` - The instance family (for example, `m4`).
         * + `payment-option` - The payment option (`NoUpfront` | `PartialUpfront` | `AllUpfront`).
         * + `state` - The state of the reservation (`payment-pending` | `payment-failed` | `active` | `retired`).
         * + `tag:<key>` - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        var filter: List<Filter>? = null
        /**
         * The host reservation IDs.
         */
        var hostReservationIdSet: List<String>? = null
        /**
         * The maximum number of results to return for the request in a single page. The remaining results can be seen by sending another request with the returned `nextToken` value. This value can be between 5 and 500. If `maxResults` is given a larger value than 500, you receive an error.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The token to use to retrieve the next page of results.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeHostReservationsRequest) : this() {
            this.filter = x.filter
            this.hostReservationIdSet = x.hostReservationIdSet
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeHostReservationsRequest = DescribeHostReservationsRequest(this)
    }
}
