// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * <para>Describe instance event windows by InstanceEventWindow.
 */
class DescribeInstanceEventWindowsRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * One or more filters.
     * + `dedicated-host-id` - The event windows associated with the specified Dedicated Host ID.
     * + `event-window-name` - The event windows associated with the specified names.
     * + `instance-id` - The event windows associated with the specified instance ID.
     * + `instance-tag` - The event windows associated with the specified tag and value.
     * + `instance-tag-key` - The event windows associated with the specified tag key, regardless of the value.
     * + `instance-tag-value` - The event windows associated with the specified tag value, regardless of the key.
     * + `tag:<key>` - The key/value combination of a tag assigned to the event window. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `CMX`, specify `tag:Owner` for the filter name and `CMX` for the filter value.
     * + `tag-key` - The key of a tag assigned to the event window. Use this filter to find all event windows that have a tag with a specific key, regardless of the tag value.
     * + `tag-value` - The value of a tag assigned to the event window. Use this filter to find all event windows that have a tag with a specific value, regardless of the tag key.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The IDs of the event windows.
     */
    val instanceEventWindowIds: List<String>? = builder.instanceEventWindowIds
    /**
     * The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned `NextToken` value. This value can be between 20 and 500. You cannot specify this parameter and the event window IDs parameter in the same call.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to request the next page of results.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeInstanceEventWindowsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeInstanceEventWindowsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("instanceEventWindowIds=$instanceEventWindowIds,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (instanceEventWindowIds?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeInstanceEventWindowsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (instanceEventWindowIds != other.instanceEventWindowIds) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeInstanceEventWindowsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * One or more filters.
         * + `dedicated-host-id` - The event windows associated with the specified Dedicated Host ID.
         * + `event-window-name` - The event windows associated with the specified names.
         * + `instance-id` - The event windows associated with the specified instance ID.
         * + `instance-tag` - The event windows associated with the specified tag and value.
         * + `instance-tag-key` - The event windows associated with the specified tag key, regardless of the value.
         * + `instance-tag-value` - The event windows associated with the specified tag value, regardless of the key.
         * + `tag:<key>` - The key/value combination of a tag assigned to the event window. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `CMX`, specify `tag:Owner` for the filter name and `CMX` for the filter value.
         * + `tag-key` - The key of a tag assigned to the event window. Use this filter to find all event windows that have a tag with a specific key, regardless of the tag value.
         * + `tag-value` - The value of a tag assigned to the event window. Use this filter to find all event windows that have a tag with a specific value, regardless of the tag key.
         */
        var filters: List<Filter>? = null
        /**
         * The IDs of the event windows.
         */
        var instanceEventWindowIds: List<String>? = null
        /**
         * The maximum number of results to return in a single call. To retrieve the remaining results, make another call with the returned `NextToken` value. This value can be between 20 and 500. You cannot specify this parameter and the event window IDs parameter in the same call.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The token to request the next page of results.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeInstanceEventWindowsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.instanceEventWindowIds = x.instanceEventWindowIds
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeInstanceEventWindowsRequest = DescribeInstanceEventWindowsRequest(this)
    }
}
