// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeKeyPairsRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The filters.
     * + `key-pair-id` - The ID of the key pair.
     * + `fingerprint` - The fingerprint of the key pair.
     * + `key-name` - The name of the key pair.
     * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * If `true`, the public key material is included in the response.
     *
     * Default: `false`
     */
    val includePublicKey: kotlin.Boolean? = builder.includePublicKey
    /**
     * The key pair names.
     *
     * Default: Describes all of your key pairs.
     */
    val keyNames: List<String>? = builder.keyNames
    /**
     * The IDs of the key pairs.
     */
    val keyPairIds: List<String>? = builder.keyPairIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeKeyPairsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeKeyPairsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("includePublicKey=$includePublicKey,")
        append("keyNames=$keyNames,")
        append("keyPairIds=$keyPairIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (includePublicKey?.hashCode() ?: 0)
        result = 31 * result + (keyNames?.hashCode() ?: 0)
        result = 31 * result + (keyPairIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeKeyPairsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (includePublicKey != other.includePublicKey) return false
        if (keyNames != other.keyNames) return false
        if (keyPairIds != other.keyPairIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeKeyPairsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The filters.
         * + `key-pair-id` - The ID of the key pair.
         * + `fingerprint` - The fingerprint of the key pair.
         * + `key-name` - The name of the key pair.
         * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         */
        var filters: List<Filter>? = null
        /**
         * If `true`, the public key material is included in the response.
         *
         * Default: `false`
         */
        var includePublicKey: kotlin.Boolean? = null
        /**
         * The key pair names.
         *
         * Default: Describes all of your key pairs.
         */
        var keyNames: List<String>? = null
        /**
         * The IDs of the key pairs.
         */
        var keyPairIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeKeyPairsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.includePublicKey = x.includePublicKey
            this.keyNames = x.keyNames
            this.keyPairIds = x.keyPairIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeKeyPairsRequest = DescribeKeyPairsRequest(this)
    }
}
