// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeTagsRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The filters.
     * + `key` - The tag key.
     * + `resource-id` - The ID of the resource.
     * + `resource-type` - The resource type (`customer-gateway` | `dedicated-host` | `dhcp-options` | `elastic-ip` | `fleet` | `fpga-image` | `host-reservation` | `image` | `instance` | `internet-gateway` | `key-pair` | `launch-template` | `natgateway` | `network-acl` | `network-interface` | `placement-group` | `reserved-instances` | `route-table` | `security-group` | `snapshot` | `spot-instances-request` | `subnet` | `volume` | `vpc` | `vpc-endpoint` | `vpc-endpoint-service` | `vpc-peering-connection` | `vpn-connection` | `vpn-gateway`).
     * + `tag`:<key> - The key/value combination of the tag. For example, specify "tag:Owner" for the filter name and "TeamA" for the filter value to find resources with the tag "Owner=TeamA".
     * + `value` - The tag value.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return in a single call. This value can be between 5 and 1000. To retrieve the remaining results, make another call with the returned `NextToken` value.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token to retrieve the next page of results.
     */
    val nextToken: kotlin.String? = builder.nextToken

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeTagsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTagsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTagsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeTagsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The filters.
         * + `key` - The tag key.
         * + `resource-id` - The ID of the resource.
         * + `resource-type` - The resource type (`customer-gateway` | `dedicated-host` | `dhcp-options` | `elastic-ip` | `fleet` | `fpga-image` | `host-reservation` | `image` | `instance` | `internet-gateway` | `key-pair` | `launch-template` | `natgateway` | `network-acl` | `network-interface` | `placement-group` | `reserved-instances` | `route-table` | `security-group` | `snapshot` | `spot-instances-request` | `subnet` | `volume` | `vpc` | `vpc-endpoint` | `vpc-endpoint-service` | `vpc-peering-connection` | `vpn-connection` | `vpn-gateway`).
         * + `tag`:<key> - The key/value combination of the tag. For example, specify "tag:Owner" for the filter name and "TeamA" for the filter value to find resources with the tag "Owner=TeamA".
         * + `value` - The tag value.
         */
        var filters: List<Filter>? = null
        /**
         * The maximum number of results to return in a single call. This value can be between 5 and 1000. To retrieve the remaining results, make another call with the returned `NextToken` value.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The token to retrieve the next page of results.
         */
        var nextToken: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeTagsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeTagsRequest = DescribeTagsRequest(this)
    }
}
