// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class DescribeTransitGatewaysRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * One or more filters. The possible values are:
     * + `options.propagation-default-route-table-id` - The ID of the default propagation route table.
     * + `options.amazon-side-asn` - The private ASN for the Amazon side of a BGP session.
     * + `options.association-default-route-table-id` - The ID of the default association route table.
     * + `options.auto-accept-shared-attachments` - Indicates whether there is automatic acceptance of attachment requests (`enable` | `disable`).
     * + `options.default-route-table-association` - Indicates whether resource attachments are automatically associated with the default association route table (`enable` | `disable`).
     * + `options.default-route-table-propagation` - Indicates whether resource attachments automatically propagate routes to the default propagation route table (`enable` | `disable`).
     * + `options.dns-support` - Indicates whether DNS support is enabled (`enable` | `disable`).
     * + `options.vpn-ecmp-support` - Indicates whether Equal Cost Multipath Protocol support is enabled (`enable` | `disable`).
     * + `owner-id` - The ID of the Amazon Web Services account that owns the transit gateway.
     * + `state` - The state of the transit gateway (`available` | `deleted` | `deleting` | `modifying` | `pending`).
     * + `transit-gateway-id` - The ID of the transit gateway.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned `nextToken` value.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next page of results.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The IDs of the transit gateways.
     */
    val transitGatewayIds: List<String>? = builder.transitGatewayIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeTransitGatewaysRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeTransitGatewaysRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("transitGatewayIds=$transitGatewayIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeTransitGatewaysRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (transitGatewayIds != other.transitGatewayIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeTransitGatewaysRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * One or more filters. The possible values are:
         * + `options.propagation-default-route-table-id` - The ID of the default propagation route table.
         * + `options.amazon-side-asn` - The private ASN for the Amazon side of a BGP session.
         * + `options.association-default-route-table-id` - The ID of the default association route table.
         * + `options.auto-accept-shared-attachments` - Indicates whether there is automatic acceptance of attachment requests (`enable` | `disable`).
         * + `options.default-route-table-association` - Indicates whether resource attachments are automatically associated with the default association route table (`enable` | `disable`).
         * + `options.default-route-table-propagation` - Indicates whether resource attachments automatically propagate routes to the default propagation route table (`enable` | `disable`).
         * + `options.dns-support` - Indicates whether DNS support is enabled (`enable` | `disable`).
         * + `options.vpn-ecmp-support` - Indicates whether Equal Cost Multipath Protocol support is enabled (`enable` | `disable`).
         * + `owner-id` - The ID of the Amazon Web Services account that owns the transit gateway.
         * + `state` - The state of the transit gateway (`available` | `deleted` | `deleting` | `modifying` | `pending`).
         * + `transit-gateway-id` - The ID of the transit gateway.
         */
        var filters: List<Filter>? = null
        /**
         * The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned `nextToken` value.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The token for the next page of results.
         */
        var nextToken: kotlin.String? = null
        /**
         * The IDs of the transit gateways.
         */
        var transitGatewayIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeTransitGatewaysRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.transitGatewayIds = x.transitGatewayIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeTransitGatewaysRequest = DescribeTransitGatewaysRequest(this)
    }
}
