// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for DescribeVpcEndpointServices.
 */
class DescribeVpcEndpointServicesRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * One or more filters.
     * + `service-name` - The name of the service.
     * + `service-type` - The type of service (`Interface` | `Gateway`).
     * + `supported-ip-address-types` - The IP address type (`ipv4` | `ipv6`).
     * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.
     *
     * Constraint: If the value is greater than 1,000, we return only 1,000 items.
     */
    val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The token for the next set of items to return. (You received this token from a prior call.)
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * One or more service names.
     */
    val serviceNames: List<String>? = builder.serviceNames

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeVpcEndpointServicesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeVpcEndpointServicesRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("serviceNames=$serviceNames)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (serviceNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeVpcEndpointServicesRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (serviceNames != other.serviceNames) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeVpcEndpointServicesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * One or more filters.
         * + `service-name` - The name of the service.
         * + `service-type` - The type of service (`Interface` | `Gateway`).
         * + `supported-ip-address-types` - The IP address type (`ipv4` | `ipv6`).
         * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         */
        var filters: List<Filter>? = null
        /**
         * The maximum number of items to return for this request. The request returns a token that you can specify in a subsequent call to get the next set of results.
         *
         * Constraint: If the value is greater than 1,000, we return only 1,000 items.
         */
        var maxResults: kotlin.Int? = null
        /**
         * The token for the next set of items to return. (You received this token from a prior call.)
         */
        var nextToken: kotlin.String? = null
        /**
         * One or more service names.
         */
        var serviceNames: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeVpcEndpointServicesRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.serviceNames = x.serviceNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeVpcEndpointServicesRequest = DescribeVpcEndpointServicesRequest(this)
    }
}
