// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for DescribeVpnConnections.
 */
class DescribeVpnConnectionsRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * One or more filters.
     * + `customer-gateway-configuration` - The configuration information for the customer gateway.
     * + `customer-gateway-id` - The ID of a customer gateway associated with the VPN connection.
     * + `state` - The state of the VPN connection (`pending` | `available` | `deleting` | `deleted`).
     * + `option.static-routes-only` - Indicates whether the connection has static routes only. Used for devices that do not support Border Gateway Protocol (BGP).
     * + `route.destination-cidr-block` - The destination CIDR block. This corresponds to the subnet used in a customer data center.
     * + `bgp-asn` - The BGP Autonomous System Number (ASN) associated with a BGP device.
     * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
     * + `type` - The type of VPN connection. Currently the only supported type is `ipsec.1`.
     * + `vpn-connection-id` - The ID of the VPN connection.
     * + `vpn-gateway-id` - The ID of a virtual private gateway associated with the VPN connection.
     * + `transit-gateway-id` - The ID of a transit gateway associated with the VPN connection.
     */
    val filters: List<Filter>? = builder.filters
    /**
     * One or more VPN connection IDs.
     *
     * Default: Describes your VPN connections.
     */
    val vpnConnectionIds: List<String>? = builder.vpnConnectionIds

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DescribeVpnConnectionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeVpnConnectionsRequest(")
        append("dryRun=$dryRun,")
        append("filters=$filters,")
        append("vpnConnectionIds=$vpnConnectionIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (filters?.hashCode() ?: 0)
        result = 31 * result + (vpnConnectionIds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeVpnConnectionsRequest

        if (dryRun != other.dryRun) return false
        if (filters != other.filters) return false
        if (vpnConnectionIds != other.vpnConnectionIds) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DescribeVpnConnectionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * One or more filters.
         * + `customer-gateway-configuration` - The configuration information for the customer gateway.
         * + `customer-gateway-id` - The ID of a customer gateway associated with the VPN connection.
         * + `state` - The state of the VPN connection (`pending` | `available` | `deleting` | `deleted`).
         * + `option.static-routes-only` - Indicates whether the connection has static routes only. Used for devices that do not support Border Gateway Protocol (BGP).
         * + `route.destination-cidr-block` - The destination CIDR block. This corresponds to the subnet used in a customer data center.
         * + `bgp-asn` - The BGP Autonomous System Number (ASN) associated with a BGP device.
         * + `tag`:<key> - The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         * + `tag-key` - The key of a tag assigned to the resource. Use this filter to find all resources assigned a tag with a specific key, regardless of the tag value.
         * + `type` - The type of VPN connection. Currently the only supported type is `ipsec.1`.
         * + `vpn-connection-id` - The ID of the VPN connection.
         * + `vpn-gateway-id` - The ID of a virtual private gateway associated with the VPN connection.
         * + `transit-gateway-id` - The ID of a transit gateway associated with the VPN connection.
         */
        var filters: List<Filter>? = null
        /**
         * One or more VPN connection IDs.
         *
         * Default: Describes your VPN connections.
         */
        var vpnConnectionIds: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DescribeVpnConnectionsRequest) : this() {
            this.dryRun = x.dryRun
            this.filters = x.filters
            this.vpnConnectionIds = x.vpnConnectionIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DescribeVpnConnectionsRequest = DescribeVpnConnectionsRequest(this)
    }
}
