// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the destination options for a flow log.
 */
class DestinationOptionsRequest private constructor(builder: Builder) {
    /**
     * The format for the flow log. The default is `plain-text`.
     */
    val fileFormat: aws.sdk.kotlin.services.ec2.model.DestinationFileFormat? = builder.fileFormat
    /**
     * Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3. The default is `false`.
     */
    val hiveCompatiblePartitions: kotlin.Boolean? = builder.hiveCompatiblePartitions
    /**
     * Indicates whether to partition the flow log per hour. This reduces the cost and response time for queries. The default is `false`.
     */
    val perHourPartition: kotlin.Boolean? = builder.perHourPartition

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DestinationOptionsRequest(")
        append("fileFormat=$fileFormat,")
        append("hiveCompatiblePartitions=$hiveCompatiblePartitions,")
        append("perHourPartition=$perHourPartition)")
    }

    override fun hashCode(): kotlin.Int {
        var result = fileFormat?.hashCode() ?: 0
        result = 31 * result + (hiveCompatiblePartitions?.hashCode() ?: 0)
        result = 31 * result + (perHourPartition?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DestinationOptionsRequest

        if (fileFormat != other.fileFormat) return false
        if (hiveCompatiblePartitions != other.hiveCompatiblePartitions) return false
        if (perHourPartition != other.perHourPartition) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The format for the flow log. The default is `plain-text`.
         */
        var fileFormat: aws.sdk.kotlin.services.ec2.model.DestinationFileFormat? = null
        /**
         * Indicates whether to use Hive-compatible prefixes for flow logs stored in Amazon S3. The default is `false`.
         */
        var hiveCompatiblePartitions: kotlin.Boolean? = null
        /**
         * Indicates whether to partition the flow log per hour. This reduces the cost and response time for queries. The default is `false`.
         */
        var perHourPartition: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest) : this() {
            this.fileFormat = x.fileFormat
            this.hiveCompatiblePartitions = x.hiveCompatiblePartitions
            this.perHourPartition = x.perHourPartition
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.DestinationOptionsRequest = DestinationOptionsRequest(this)
    }
}
