// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a Capacity Reservation in a Capacity Reservation Fleet.
 */
class FleetCapacityReservation private constructor(builder: Builder) {
    /**
     * The Availability Zone in which the Capacity Reservation reserves capacity.
     */
    val availabilityZone: kotlin.String? = builder.availabilityZone
    /**
     * The ID of the Availability Zone in which the Capacity Reservation reserves capacity.
     */
    val availabilityZoneId: kotlin.String? = builder.availabilityZoneId
    /**
     * The ID of the Capacity Reservation.
     */
    val capacityReservationId: kotlin.String? = builder.capacityReservationId
    /**
     * The date and time at which the Capacity Reservation was created.
     */
    val createDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createDate
    /**
     * Indicates whether the Capacity Reservation reserves capacity for EBS-optimized instance types.
     */
    val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The number of capacity units fulfilled by the Capacity Reservation. For more information, see [ Total target capacity](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity) in the Amazon EC2 User Guide.
     */
    val fulfilledCapacity: kotlin.Double? = builder.fulfilledCapacity
    /**
     * The type of operating system for which the Capacity Reservation reserves capacity.
     */
    val instancePlatform: aws.sdk.kotlin.services.ec2.model.CapacityReservationInstancePlatform? = builder.instancePlatform
    /**
     * The instance type for which the Capacity Reservation reserves capacity.
     */
    val instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = builder.instanceType
    /**
     * The priority of the instance type in the Capacity Reservation Fleet. For more information, see [ Instance type priority](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority) in the Amazon EC2 User Guide.
     */
    val priority: kotlin.Int? = builder.priority
    /**
     * The total number of instances for which the Capacity Reservation reserves capacity.
     */
    val totalInstanceCount: kotlin.Int? = builder.totalInstanceCount
    /**
     * The weight of the instance type in the Capacity Reservation Fleet. For more information, see [ Instance type weight](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-weight) in the Amazon EC2 User Guide.
     */
    val weight: kotlin.Double? = builder.weight

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.FleetCapacityReservation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FleetCapacityReservation(")
        append("availabilityZone=$availabilityZone,")
        append("availabilityZoneId=$availabilityZoneId,")
        append("capacityReservationId=$capacityReservationId,")
        append("createDate=$createDate,")
        append("ebsOptimized=$ebsOptimized,")
        append("fulfilledCapacity=$fulfilledCapacity,")
        append("instancePlatform=$instancePlatform,")
        append("instanceType=$instanceType,")
        append("priority=$priority,")
        append("totalInstanceCount=$totalInstanceCount,")
        append("weight=$weight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZone?.hashCode() ?: 0
        result = 31 * result + (availabilityZoneId?.hashCode() ?: 0)
        result = 31 * result + (capacityReservationId?.hashCode() ?: 0)
        result = 31 * result + (createDate?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (fulfilledCapacity?.hashCode() ?: 0)
        result = 31 * result + (instancePlatform?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (totalInstanceCount ?: 0)
        result = 31 * result + (weight?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FleetCapacityReservation

        if (availabilityZone != other.availabilityZone) return false
        if (availabilityZoneId != other.availabilityZoneId) return false
        if (capacityReservationId != other.capacityReservationId) return false
        if (createDate != other.createDate) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (fulfilledCapacity != other.fulfilledCapacity) return false
        if (instancePlatform != other.instancePlatform) return false
        if (instanceType != other.instanceType) return false
        if (priority != other.priority) return false
        if (totalInstanceCount != other.totalInstanceCount) return false
        if (weight != other.weight) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.FleetCapacityReservation = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Availability Zone in which the Capacity Reservation reserves capacity.
         */
        var availabilityZone: kotlin.String? = null
        /**
         * The ID of the Availability Zone in which the Capacity Reservation reserves capacity.
         */
        var availabilityZoneId: kotlin.String? = null
        /**
         * The ID of the Capacity Reservation.
         */
        var capacityReservationId: kotlin.String? = null
        /**
         * The date and time at which the Capacity Reservation was created.
         */
        var createDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether the Capacity Reservation reserves capacity for EBS-optimized instance types.
         */
        var ebsOptimized: kotlin.Boolean? = null
        /**
         * The number of capacity units fulfilled by the Capacity Reservation. For more information, see [ Total target capacity](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity) in the Amazon EC2 User Guide.
         */
        var fulfilledCapacity: kotlin.Double? = null
        /**
         * The type of operating system for which the Capacity Reservation reserves capacity.
         */
        var instancePlatform: aws.sdk.kotlin.services.ec2.model.CapacityReservationInstancePlatform? = null
        /**
         * The instance type for which the Capacity Reservation reserves capacity.
         */
        var instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = null
        /**
         * The priority of the instance type in the Capacity Reservation Fleet. For more information, see [ Instance type priority](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority) in the Amazon EC2 User Guide.
         */
        var priority: kotlin.Int? = null
        /**
         * The total number of instances for which the Capacity Reservation reserves capacity.
         */
        var totalInstanceCount: kotlin.Int? = null
        /**
         * The weight of the instance type in the Capacity Reservation Fleet. For more information, see [ Instance type weight](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-weight) in the Amazon EC2 User Guide.
         */
        var weight: kotlin.Double? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.FleetCapacityReservation) : this() {
            this.availabilityZone = x.availabilityZone
            this.availabilityZoneId = x.availabilityZoneId
            this.capacityReservationId = x.capacityReservationId
            this.createDate = x.createDate
            this.ebsOptimized = x.ebsOptimized
            this.fulfilledCapacity = x.fulfilledCapacity
            this.instancePlatform = x.instancePlatform
            this.instanceType = x.instanceType
            this.priority = x.priority
            this.totalInstanceCount = x.totalInstanceCount
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.FleetCapacityReservation = FleetCapacityReservation(this)
    }
}
