// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the Amazon EC2 launch template and the launch template version that can be used by an EC2 Fleet to configure Amazon EC2 instances. For information about launch templates, see [Launching an instance from a launch template](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html) in the *Amazon EC2 User Guide*.
 */
class FleetLaunchTemplateSpecificationRequest private constructor(builder: Builder) {
    /**
     * The ID of the launch template. If you specify the template ID, you can't specify the template name.
     */
    val launchTemplateId: kotlin.String? = builder.launchTemplateId
    /**
     * The name of the launch template. If you specify the template name, you can't specify the template ID.
     */
    val launchTemplateName: kotlin.String? = builder.launchTemplateName
    /**
     * The launch template version number, `$Latest`, or `$Default`. You must specify a value, otherwise the request fails.
     *
     * If the value is `$Latest`, Amazon EC2 uses the latest version of the launch template.
     *
     * If the value is `$Default`, Amazon EC2 uses the default version of the launch template.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.FleetLaunchTemplateSpecificationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FleetLaunchTemplateSpecificationRequest(")
        append("launchTemplateId=$launchTemplateId,")
        append("launchTemplateName=$launchTemplateName,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = launchTemplateId?.hashCode() ?: 0
        result = 31 * result + (launchTemplateName?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FleetLaunchTemplateSpecificationRequest

        if (launchTemplateId != other.launchTemplateId) return false
        if (launchTemplateName != other.launchTemplateName) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.FleetLaunchTemplateSpecificationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the launch template. If you specify the template ID, you can't specify the template name.
         */
        var launchTemplateId: kotlin.String? = null
        /**
         * The name of the launch template. If you specify the template name, you can't specify the template ID.
         */
        var launchTemplateName: kotlin.String? = null
        /**
         * The launch template version number, `$Latest`, or `$Default`. You must specify a value, otherwise the request fails.
         *
         * If the value is `$Latest`, Amazon EC2 uses the latest version of the launch template.
         *
         * If the value is `$Default`, Amazon EC2 uses the default version of the launch template.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.FleetLaunchTemplateSpecificationRequest) : this() {
            this.launchTemplateId = x.launchTemplateId
            this.launchTemplateName = x.launchTemplateName
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.FleetLaunchTemplateSpecificationRequest = FleetLaunchTemplateSpecificationRequest(this)
    }
}
