// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an Amazon FPGA image (AFI).
 */
class FpgaImage private constructor(builder: Builder) {
    /**
     * The date and time the AFI was created.
     */
    val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * Indicates whether data retention support is enabled for the AFI.
     */
    val dataRetentionSupport: kotlin.Boolean? = builder.dataRetentionSupport
    /**
     * The description of the AFI.
     */
    val description: kotlin.String? = builder.description
    /**
     * The global FPGA image identifier (AGFI ID).
     */
    val fpgaImageGlobalId: kotlin.String? = builder.fpgaImageGlobalId
    /**
     * The FPGA image identifier (AFI ID).
     */
    val fpgaImageId: kotlin.String? = builder.fpgaImageId
    /**
     * The name of the AFI.
     */
    val name: kotlin.String? = builder.name
    /**
     * The alias of the AFI owner. Possible values include `self`, `amazon`, and `aws-marketplace`.
     */
    val ownerAlias: kotlin.String? = builder.ownerAlias
    /**
     * The ID of the Amazon Web Services account that owns the AFI.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * Information about the PCI bus.
     */
    val pciId: aws.sdk.kotlin.services.ec2.model.PciId? = builder.pciId
    /**
     * The product codes for the AFI.
     */
    val productCodes: List<ProductCode>? = builder.productCodes
    /**
     * Indicates whether the AFI is public.
     */
    val public: kotlin.Boolean? = builder.public
    /**
     * The version of the Amazon Web Services Shell that was used to create the bitstream.
     */
    val shellVersion: kotlin.String? = builder.shellVersion
    /**
     * Information about the state of the AFI.
     */
    val state: aws.sdk.kotlin.services.ec2.model.FpgaImageState? = builder.state
    /**
     * Any tags assigned to the AFI.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The time of the most recent update to the AFI.
     */
    val updateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updateTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.FpgaImage = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FpgaImage(")
        append("createTime=$createTime,")
        append("dataRetentionSupport=$dataRetentionSupport,")
        append("description=$description,")
        append("fpgaImageGlobalId=$fpgaImageGlobalId,")
        append("fpgaImageId=$fpgaImageId,")
        append("name=$name,")
        append("ownerAlias=$ownerAlias,")
        append("ownerId=$ownerId,")
        append("pciId=$pciId,")
        append("productCodes=$productCodes,")
        append("public=$public,")
        append("shellVersion=$shellVersion,")
        append("state=$state,")
        append("tags=$tags,")
        append("updateTime=$updateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime?.hashCode() ?: 0
        result = 31 * result + (dataRetentionSupport?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fpgaImageGlobalId?.hashCode() ?: 0)
        result = 31 * result + (fpgaImageId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerAlias?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (pciId?.hashCode() ?: 0)
        result = 31 * result + (productCodes?.hashCode() ?: 0)
        result = 31 * result + (public?.hashCode() ?: 0)
        result = 31 * result + (shellVersion?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FpgaImage

        if (createTime != other.createTime) return false
        if (dataRetentionSupport != other.dataRetentionSupport) return false
        if (description != other.description) return false
        if (fpgaImageGlobalId != other.fpgaImageGlobalId) return false
        if (fpgaImageId != other.fpgaImageId) return false
        if (name != other.name) return false
        if (ownerAlias != other.ownerAlias) return false
        if (ownerId != other.ownerId) return false
        if (pciId != other.pciId) return false
        if (productCodes != other.productCodes) return false
        if (public != other.public) return false
        if (shellVersion != other.shellVersion) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.FpgaImage = Builder(this).apply(block).build()

    class Builder {
        /**
         * The date and time the AFI was created.
         */
        var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether data retention support is enabled for the AFI.
         */
        var dataRetentionSupport: kotlin.Boolean? = null
        /**
         * The description of the AFI.
         */
        var description: kotlin.String? = null
        /**
         * The global FPGA image identifier (AGFI ID).
         */
        var fpgaImageGlobalId: kotlin.String? = null
        /**
         * The FPGA image identifier (AFI ID).
         */
        var fpgaImageId: kotlin.String? = null
        /**
         * The name of the AFI.
         */
        var name: kotlin.String? = null
        /**
         * The alias of the AFI owner. Possible values include `self`, `amazon`, and `aws-marketplace`.
         */
        var ownerAlias: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the AFI.
         */
        var ownerId: kotlin.String? = null
        /**
         * Information about the PCI bus.
         */
        var pciId: aws.sdk.kotlin.services.ec2.model.PciId? = null
        /**
         * The product codes for the AFI.
         */
        var productCodes: List<ProductCode>? = null
        /**
         * Indicates whether the AFI is public.
         */
        var public: kotlin.Boolean? = null
        /**
         * The version of the Amazon Web Services Shell that was used to create the bitstream.
         */
        var shellVersion: kotlin.String? = null
        /**
         * Information about the state of the AFI.
         */
        var state: aws.sdk.kotlin.services.ec2.model.FpgaImageState? = null
        /**
         * Any tags assigned to the AFI.
         */
        var tags: List<Tag>? = null
        /**
         * The time of the most recent update to the AFI.
         */
        var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.FpgaImage) : this() {
            this.createTime = x.createTime
            this.dataRetentionSupport = x.dataRetentionSupport
            this.description = x.description
            this.fpgaImageGlobalId = x.fpgaImageGlobalId
            this.fpgaImageId = x.fpgaImageId
            this.name = x.name
            this.ownerAlias = x.ownerAlias
            this.ownerId = x.ownerId
            this.pciId = x.pciId
            this.productCodes = x.productCodes
            this.public = x.public
            this.shellVersion = x.shellVersion
            this.state = x.state
            this.tags = x.tags
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.FpgaImage = FpgaImage(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PciId] inside the given [block]
         */
        fun pciId(block: aws.sdk.kotlin.services.ec2.model.PciId.Builder.() -> kotlin.Unit) {
            this.pciId = aws.sdk.kotlin.services.ec2.model.PciId.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.FpgaImageState] inside the given [block]
         */
        fun state(block: aws.sdk.kotlin.services.ec2.model.FpgaImageState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.ec2.model.FpgaImageState.invoke(block)
        }
    }
}
