// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class GetCapacityReservationUsageResponse private constructor(builder: Builder) {
    /**
     * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
     */
    val availableInstanceCount: kotlin.Int? = builder.availableInstanceCount
    /**
     * The ID of the Capacity Reservation.
     */
    val capacityReservationId: kotlin.String? = builder.capacityReservationId
    /**
     * The type of instance for which the Capacity Reservation reserves capacity.
     */
    val instanceType: kotlin.String? = builder.instanceType
    /**
     * Information about the Capacity Reservation usage.
     */
    val instanceUsages: List<InstanceUsage>? = builder.instanceUsages
    /**
     * The token to use to retrieve the next page of results. This value is `null` when there are no more results to return.
     */
    val nextToken: kotlin.String? = builder.nextToken
    /**
     * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
     * + `active` - The Capacity Reservation is active and the capacity is available for your use.
     * + `expired` - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.
     * + `cancelled` - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.
     * + `pending` - The Capacity Reservation request was successful but the capacity provisioning is still pending.
     * + `failed` - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
     */
    val state: aws.sdk.kotlin.services.ec2.model.CapacityReservationState? = builder.state
    /**
     * The number of instances for which the Capacity Reservation reserves capacity.
     */
    val totalInstanceCount: kotlin.Int? = builder.totalInstanceCount

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.GetCapacityReservationUsageResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCapacityReservationUsageResponse(")
        append("availableInstanceCount=$availableInstanceCount,")
        append("capacityReservationId=$capacityReservationId,")
        append("instanceType=$instanceType,")
        append("instanceUsages=$instanceUsages,")
        append("nextToken=$nextToken,")
        append("state=$state,")
        append("totalInstanceCount=$totalInstanceCount)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availableInstanceCount ?: 0
        result = 31 * result + (capacityReservationId?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (instanceUsages?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (totalInstanceCount ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCapacityReservationUsageResponse

        if (availableInstanceCount != other.availableInstanceCount) return false
        if (capacityReservationId != other.capacityReservationId) return false
        if (instanceType != other.instanceType) return false
        if (instanceUsages != other.instanceUsages) return false
        if (nextToken != other.nextToken) return false
        if (state != other.state) return false
        if (totalInstanceCount != other.totalInstanceCount) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.GetCapacityReservationUsageResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The remaining capacity. Indicates the number of instances that can be launched in the Capacity Reservation.
         */
        var availableInstanceCount: kotlin.Int? = null
        /**
         * The ID of the Capacity Reservation.
         */
        var capacityReservationId: kotlin.String? = null
        /**
         * The type of instance for which the Capacity Reservation reserves capacity.
         */
        var instanceType: kotlin.String? = null
        /**
         * Information about the Capacity Reservation usage.
         */
        var instanceUsages: List<InstanceUsage>? = null
        /**
         * The token to use to retrieve the next page of results. This value is `null` when there are no more results to return.
         */
        var nextToken: kotlin.String? = null
        /**
         * The current state of the Capacity Reservation. A Capacity Reservation can be in one of the following states:
         * + `active` - The Capacity Reservation is active and the capacity is available for your use.
         * + `expired` - The Capacity Reservation expired automatically at the date and time specified in your request. The reserved capacity is no longer available for your use.
         * + `cancelled` - The Capacity Reservation was cancelled. The reserved capacity is no longer available for your use.
         * + `pending` - The Capacity Reservation request was successful but the capacity provisioning is still pending.
         * + `failed` - The Capacity Reservation request has failed. A request might fail due to invalid request parameters, capacity constraints, or instance limit constraints. Failed requests are retained for 60 minutes.
         */
        var state: aws.sdk.kotlin.services.ec2.model.CapacityReservationState? = null
        /**
         * The number of instances for which the Capacity Reservation reserves capacity.
         */
        var totalInstanceCount: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.GetCapacityReservationUsageResponse) : this() {
            this.availableInstanceCount = x.availableInstanceCount
            this.capacityReservationId = x.capacityReservationId
            this.instanceType = x.instanceType
            this.instanceUsages = x.instanceUsages
            this.nextToken = x.nextToken
            this.state = x.state
            this.totalInstanceCount = x.totalInstanceCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.GetCapacityReservationUsageResponse = GetCapacityReservationUsageResponse(this)
    }
}
