// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the disk container object for an import image task.
 */
class ImageDiskContainer private constructor(builder: Builder) {
    /**
     * The description of the disk image.
     */
    val description: kotlin.String? = builder.description
    /**
     * The block device mapping for the disk.
     */
    val deviceName: kotlin.String? = builder.deviceName
    /**
     * The format of the disk image being imported.
     *
     * Valid values: `OVA` | `VHD` | `VHDX` | `VMDK` | `RAW`
     */
    val format: kotlin.String? = builder.format
    /**
     * The ID of the EBS snapshot to be used for importing the snapshot.
     */
    val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..) or an Amazon S3 URL (s3://..)
     */
    val url: kotlin.String? = builder.url
    /**
     * The S3 bucket for the disk image.
     */
    val userBucket: aws.sdk.kotlin.services.ec2.model.UserBucket? = builder.userBucket

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ImageDiskContainer = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImageDiskContainer(")
        append("description=$description,")
        append("deviceName=$deviceName,")
        append("format=$format,")
        append("snapshotId=$snapshotId,")
        append("url=$url,")
        append("userBucket=$userBucket)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (deviceName?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (url?.hashCode() ?: 0)
        result = 31 * result + (userBucket?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImageDiskContainer

        if (description != other.description) return false
        if (deviceName != other.deviceName) return false
        if (format != other.format) return false
        if (snapshotId != other.snapshotId) return false
        if (url != other.url) return false
        if (userBucket != other.userBucket) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ImageDiskContainer = Builder(this).apply(block).build()

    class Builder {
        /**
         * The description of the disk image.
         */
        var description: kotlin.String? = null
        /**
         * The block device mapping for the disk.
         */
        var deviceName: kotlin.String? = null
        /**
         * The format of the disk image being imported.
         *
         * Valid values: `OVA` | `VHD` | `VHDX` | `VMDK` | `RAW`
         */
        var format: kotlin.String? = null
        /**
         * The ID of the EBS snapshot to be used for importing the snapshot.
         */
        var snapshotId: kotlin.String? = null
        /**
         * The URL to the Amazon S3-based disk image being imported. The URL can either be a https URL (https://..) or an Amazon S3 URL (s3://..)
         */
        var url: kotlin.String? = null
        /**
         * The S3 bucket for the disk image.
         */
        var userBucket: aws.sdk.kotlin.services.ec2.model.UserBucket? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ImageDiskContainer) : this() {
            this.description = x.description
            this.deviceName = x.deviceName
            this.format = x.format
            this.snapshotId = x.snapshotId
            this.url = x.url
            this.userBucket = x.userBucket
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ImageDiskContainer = ImageDiskContainer(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.UserBucket] inside the given [block]
         */
        fun userBucket(block: aws.sdk.kotlin.services.ec2.model.UserBucket.Builder.() -> kotlin.Unit) {
            this.userBucket = aws.sdk.kotlin.services.ec2.model.UserBucket.invoke(block)
        }
    }
}
