// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an instance.
 */
class Instance private constructor(builder: Builder) {
    /**
     * The AMI launch index, which can be used to find this instance in the launch group.
     */
    val amiLaunchIndex: kotlin.Int? = builder.amiLaunchIndex
    /**
     * The architecture of the image.
     */
    val architecture: aws.sdk.kotlin.services.ec2.model.ArchitectureValues? = builder.architecture
    /**
     * Any block device mapping entries for the instance.
     */
    val blockDeviceMappings: List<InstanceBlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * The boot mode of the instance. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the *Amazon EC2 User Guide*.
     */
    val bootMode: aws.sdk.kotlin.services.ec2.model.BootModeValues? = builder.bootMode
    /**
     * The ID of the Capacity Reservation.
     */
    val capacityReservationId: kotlin.String? = builder.capacityReservationId
    /**
     * Information about the Capacity Reservation targeting option.
     */
    val capacityReservationSpecification: aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecificationResponse? = builder.capacityReservationSpecification
    /**
     * The idempotency token you provided when you launched the instance, if applicable.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The CPU options for the instance.
     */
    val cpuOptions: aws.sdk.kotlin.services.ec2.model.CpuOptions? = builder.cpuOptions
    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     */
    val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The Elastic GPU associated with the instance.
     */
    val elasticGpuAssociations: List<ElasticGpuAssociation>? = builder.elasticGpuAssociations
    /**
     * The elastic inference accelerator associated with the instance.
     */
    val elasticInferenceAcceleratorAssociations: List<ElasticInferenceAcceleratorAssociation>? = builder.elasticInferenceAcceleratorAssociations
    /**
     * Specifies whether enhanced networking with ENA is enabled.
     */
    val enaSupport: kotlin.Boolean? = builder.enaSupport
    /**
     * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
     */
    val enclaveOptions: aws.sdk.kotlin.services.ec2.model.EnclaveOptions? = builder.enclaveOptions
    /**
     * Indicates whether the instance is enabled for hibernation.
     */
    val hibernationOptions: aws.sdk.kotlin.services.ec2.model.HibernationOptions? = builder.hibernationOptions
    /**
     * The hypervisor type of the instance. The value `xen` is used for both Xen and Nitro hypervisors.
     */
    val hypervisor: aws.sdk.kotlin.services.ec2.model.HypervisorType? = builder.hypervisor
    /**
     * The IAM instance profile associated with the instance, if applicable.
     */
    val iamInstanceProfile: aws.sdk.kotlin.services.ec2.model.IamInstanceProfile? = builder.iamInstanceProfile
    /**
     * The ID of the AMI used to launch the instance.
     */
    val imageId: kotlin.String? = builder.imageId
    /**
     * The ID of the instance.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * Indicates whether this is a Spot Instance or a Scheduled Instance.
     */
    val instanceLifecycle: aws.sdk.kotlin.services.ec2.model.InstanceLifecycleType? = builder.instanceLifecycle
    /**
     * The instance type.
     */
    val instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = builder.instanceType
    /**
     * The IPv6 address assigned to the instance.
     */
    val ipv6Address: kotlin.String? = builder.ipv6Address
    /**
     * The kernel associated with this instance, if applicable.
     */
    val kernelId: kotlin.String? = builder.kernelId
    /**
     * The name of the key pair, if this instance was launched with an associated key pair.
     */
    val keyName: kotlin.String? = builder.keyName
    /**
     * The time the instance was launched.
     */
    val launchTime: aws.smithy.kotlin.runtime.time.Instant? = builder.launchTime
    /**
     * The license configurations for the instance.
     */
    val licenses: List<LicenseConfiguration>? = builder.licenses
    /**
     * Provides information on the recovery and maintenance options of your instance.
     */
    val maintenanceOptions: aws.sdk.kotlin.services.ec2.model.InstanceMaintenanceOptions? = builder.maintenanceOptions
    /**
     * The metadata options for the instance.
     */
    val metadataOptions: aws.sdk.kotlin.services.ec2.model.InstanceMetadataOptionsResponse? = builder.metadataOptions
    /**
     * The monitoring for the instance.
     */
    val monitoring: aws.sdk.kotlin.services.ec2.model.Monitoring? = builder.monitoring
    /**
     * &#91;EC2-VPC&#93; The network interfaces for the instance.
     */
    val networkInterfaces: List<InstanceNetworkInterface>? = builder.networkInterfaces
    /**
     * The Amazon Resource Name (ARN) of the Outpost.
     */
    val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The location where the instance launched, if applicable.
     */
    val placement: aws.sdk.kotlin.services.ec2.model.Placement? = builder.placement
    /**
     * The value is `Windows` for Windows instances; otherwise blank.
     */
    val platform: aws.sdk.kotlin.services.ec2.model.PlatformValues? = builder.platform
    /**
     * The platform details value for the instance. For more information, see [AMI billing information fields](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html) in the *Amazon EC2 User Guide*.
     */
    val platformDetails: kotlin.String? = builder.platformDetails
    /**
     * (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside the Amazon EC2 network. This name is not available until the instance enters the `running` state.
     *
     * &#91;EC2-VPC&#93; The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC, your custom domain name servers must resolve the hostname as appropriate.
     */
    val privateDnsName: kotlin.String? = builder.privateDnsName
    /**
     * The options for the instance hostname.
     */
    val privateDnsNameOptions: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsResponse? = builder.privateDnsNameOptions
    /**
     * The private IPv4 address assigned to the instance.
     */
    val privateIpAddress: kotlin.String? = builder.privateIpAddress
    /**
     * The product codes attached to this instance, if applicable.
     */
    val productCodes: List<ProductCode>? = builder.productCodes
    /**
     * (IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance enters the `running` state. For EC2-VPC, this name is only available if you've enabled DNS hostnames for your VPC.
     */
    val publicDnsName: kotlin.String? = builder.publicDnsName
    /**
     * The public IPv4 address, or the Carrier IP address assigned to the instance, if applicable.
     *
     * A Carrier IP address only applies to an instance launched in a subnet associated with a Wavelength Zone.
     */
    val publicIpAddress: kotlin.String? = builder.publicIpAddress
    /**
     * The RAM disk associated with this instance, if applicable.
     */
    val ramdiskId: kotlin.String? = builder.ramdiskId
    /**
     * The device name of the root device volume (for example, `/dev/sda1`).
     */
    val rootDeviceName: kotlin.String? = builder.rootDeviceName
    /**
     * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
     */
    val rootDeviceType: aws.sdk.kotlin.services.ec2.model.DeviceType? = builder.rootDeviceType
    /**
     * The security groups for the instance.
     */
    val securityGroups: List<GroupIdentifier>? = builder.securityGroups
    /**
     * Indicates whether source/destination checking is enabled.
     */
    val sourceDestCheck: kotlin.Boolean? = builder.sourceDestCheck
    /**
     * If the request is a Spot Instance request, the ID of the request.
     */
    val spotInstanceRequestId: kotlin.String? = builder.spotInstanceRequestId
    /**
     * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    val sriovNetSupport: kotlin.String? = builder.sriovNetSupport
    /**
     * The current state of the instance.
     */
    val state: aws.sdk.kotlin.services.ec2.model.InstanceState? = builder.state
    /**
     * The reason for the most recent state transition.
     */
    val stateReason: aws.sdk.kotlin.services.ec2.model.StateReason? = builder.stateReason
    /**
     * The reason for the most recent state transition. This might be an empty string.
     */
    val stateTransitionReason: kotlin.String? = builder.stateTransitionReason
    /**
     * &#91;EC2-VPC&#93; The ID of the subnet in which the instance is running.
     */
    val subnetId: kotlin.String? = builder.subnetId
    /**
     * Any tags assigned to the instance.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * If the instance is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the *Amazon EC2 User Guide*.
     */
    val tpmSupport: kotlin.String? = builder.tpmSupport
    /**
     * The usage operation value for the instance. For more information, see [AMI billing information fields](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html) in the *Amazon EC2 User Guide*.
     */
    val usageOperation: kotlin.String? = builder.usageOperation
    /**
     * The time that the usage operation was last updated.
     */
    val usageOperationUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.usageOperationUpdateTime
    /**
     * The virtualization type of the instance.
     */
    val virtualizationType: aws.sdk.kotlin.services.ec2.model.VirtualizationType? = builder.virtualizationType
    /**
     * &#91;EC2-VPC&#93; The ID of the VPC in which the instance is running.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.Instance = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Instance(")
        append("amiLaunchIndex=$amiLaunchIndex,")
        append("architecture=$architecture,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("bootMode=$bootMode,")
        append("capacityReservationId=$capacityReservationId,")
        append("capacityReservationSpecification=$capacityReservationSpecification,")
        append("clientToken=$clientToken,")
        append("cpuOptions=$cpuOptions,")
        append("ebsOptimized=$ebsOptimized,")
        append("elasticGpuAssociations=$elasticGpuAssociations,")
        append("elasticInferenceAcceleratorAssociations=$elasticInferenceAcceleratorAssociations,")
        append("enaSupport=$enaSupport,")
        append("enclaveOptions=$enclaveOptions,")
        append("hibernationOptions=$hibernationOptions,")
        append("hypervisor=$hypervisor,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceId=$instanceId,")
        append("instanceLifecycle=$instanceLifecycle,")
        append("instanceType=$instanceType,")
        append("ipv6Address=$ipv6Address,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("launchTime=$launchTime,")
        append("licenses=$licenses,")
        append("maintenanceOptions=$maintenanceOptions,")
        append("metadataOptions=$metadataOptions,")
        append("monitoring=$monitoring,")
        append("networkInterfaces=$networkInterfaces,")
        append("outpostArn=$outpostArn,")
        append("placement=$placement,")
        append("platform=$platform,")
        append("platformDetails=$platformDetails,")
        append("privateDnsName=$privateDnsName,")
        append("privateDnsNameOptions=$privateDnsNameOptions,")
        append("privateIpAddress=$privateIpAddress,")
        append("productCodes=$productCodes,")
        append("publicDnsName=$publicDnsName,")
        append("publicIpAddress=$publicIpAddress,")
        append("ramdiskId=$ramdiskId,")
        append("rootDeviceName=$rootDeviceName,")
        append("rootDeviceType=$rootDeviceType,")
        append("securityGroups=$securityGroups,")
        append("sourceDestCheck=$sourceDestCheck,")
        append("spotInstanceRequestId=$spotInstanceRequestId,")
        append("sriovNetSupport=$sriovNetSupport,")
        append("state=$state,")
        append("stateReason=$stateReason,")
        append("stateTransitionReason=$stateTransitionReason,")
        append("subnetId=$subnetId,")
        append("tags=$tags,")
        append("tpmSupport=$tpmSupport,")
        append("usageOperation=$usageOperation,")
        append("usageOperationUpdateTime=$usageOperationUpdateTime,")
        append("virtualizationType=$virtualizationType,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amiLaunchIndex ?: 0
        result = 31 * result + (architecture?.hashCode() ?: 0)
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (bootMode?.hashCode() ?: 0)
        result = 31 * result + (capacityReservationId?.hashCode() ?: 0)
        result = 31 * result + (capacityReservationSpecification?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (cpuOptions?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (elasticGpuAssociations?.hashCode() ?: 0)
        result = 31 * result + (elasticInferenceAcceleratorAssociations?.hashCode() ?: 0)
        result = 31 * result + (enaSupport?.hashCode() ?: 0)
        result = 31 * result + (enclaveOptions?.hashCode() ?: 0)
        result = 31 * result + (hibernationOptions?.hashCode() ?: 0)
        result = 31 * result + (hypervisor?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceLifecycle?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (ipv6Address?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (launchTime?.hashCode() ?: 0)
        result = 31 * result + (licenses?.hashCode() ?: 0)
        result = 31 * result + (maintenanceOptions?.hashCode() ?: 0)
        result = 31 * result + (metadataOptions?.hashCode() ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (platformDetails?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateDnsNameOptions?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        result = 31 * result + (productCodes?.hashCode() ?: 0)
        result = 31 * result + (publicDnsName?.hashCode() ?: 0)
        result = 31 * result + (publicIpAddress?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceName?.hashCode() ?: 0)
        result = 31 * result + (rootDeviceType?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (sourceDestCheck?.hashCode() ?: 0)
        result = 31 * result + (spotInstanceRequestId?.hashCode() ?: 0)
        result = 31 * result + (sriovNetSupport?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateReason?.hashCode() ?: 0)
        result = 31 * result + (stateTransitionReason?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tpmSupport?.hashCode() ?: 0)
        result = 31 * result + (usageOperation?.hashCode() ?: 0)
        result = 31 * result + (usageOperationUpdateTime?.hashCode() ?: 0)
        result = 31 * result + (virtualizationType?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Instance

        if (amiLaunchIndex != other.amiLaunchIndex) return false
        if (architecture != other.architecture) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (bootMode != other.bootMode) return false
        if (capacityReservationId != other.capacityReservationId) return false
        if (capacityReservationSpecification != other.capacityReservationSpecification) return false
        if (clientToken != other.clientToken) return false
        if (cpuOptions != other.cpuOptions) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (elasticGpuAssociations != other.elasticGpuAssociations) return false
        if (elasticInferenceAcceleratorAssociations != other.elasticInferenceAcceleratorAssociations) return false
        if (enaSupport != other.enaSupport) return false
        if (enclaveOptions != other.enclaveOptions) return false
        if (hibernationOptions != other.hibernationOptions) return false
        if (hypervisor != other.hypervisor) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceId != other.instanceId) return false
        if (instanceLifecycle != other.instanceLifecycle) return false
        if (instanceType != other.instanceType) return false
        if (ipv6Address != other.ipv6Address) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (launchTime != other.launchTime) return false
        if (licenses != other.licenses) return false
        if (maintenanceOptions != other.maintenanceOptions) return false
        if (metadataOptions != other.metadataOptions) return false
        if (monitoring != other.monitoring) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (outpostArn != other.outpostArn) return false
        if (placement != other.placement) return false
        if (platform != other.platform) return false
        if (platformDetails != other.platformDetails) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateDnsNameOptions != other.privateDnsNameOptions) return false
        if (privateIpAddress != other.privateIpAddress) return false
        if (productCodes != other.productCodes) return false
        if (publicDnsName != other.publicDnsName) return false
        if (publicIpAddress != other.publicIpAddress) return false
        if (ramdiskId != other.ramdiskId) return false
        if (rootDeviceName != other.rootDeviceName) return false
        if (rootDeviceType != other.rootDeviceType) return false
        if (securityGroups != other.securityGroups) return false
        if (sourceDestCheck != other.sourceDestCheck) return false
        if (spotInstanceRequestId != other.spotInstanceRequestId) return false
        if (sriovNetSupport != other.sriovNetSupport) return false
        if (state != other.state) return false
        if (stateReason != other.stateReason) return false
        if (stateTransitionReason != other.stateTransitionReason) return false
        if (subnetId != other.subnetId) return false
        if (tags != other.tags) return false
        if (tpmSupport != other.tpmSupport) return false
        if (usageOperation != other.usageOperation) return false
        if (usageOperationUpdateTime != other.usageOperationUpdateTime) return false
        if (virtualizationType != other.virtualizationType) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.Instance = Builder(this).apply(block).build()

    class Builder {
        /**
         * The AMI launch index, which can be used to find this instance in the launch group.
         */
        var amiLaunchIndex: kotlin.Int? = null
        /**
         * The architecture of the image.
         */
        var architecture: aws.sdk.kotlin.services.ec2.model.ArchitectureValues? = null
        /**
         * Any block device mapping entries for the instance.
         */
        var blockDeviceMappings: List<InstanceBlockDeviceMapping>? = null
        /**
         * The boot mode of the instance. For more information, see [Boot modes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ami-boot.html) in the *Amazon EC2 User Guide*.
         */
        var bootMode: aws.sdk.kotlin.services.ec2.model.BootModeValues? = null
        /**
         * The ID of the Capacity Reservation.
         */
        var capacityReservationId: kotlin.String? = null
        /**
         * Information about the Capacity Reservation targeting option.
         */
        var capacityReservationSpecification: aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecificationResponse? = null
        /**
         * The idempotency token you provided when you launched the instance, if applicable.
         */
        var clientToken: kotlin.String? = null
        /**
         * The CPU options for the instance.
         */
        var cpuOptions: aws.sdk.kotlin.services.ec2.model.CpuOptions? = null
        /**
         * Indicates whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
         */
        var ebsOptimized: kotlin.Boolean? = null
        /**
         * The Elastic GPU associated with the instance.
         */
        var elasticGpuAssociations: List<ElasticGpuAssociation>? = null
        /**
         * The elastic inference accelerator associated with the instance.
         */
        var elasticInferenceAcceleratorAssociations: List<ElasticInferenceAcceleratorAssociation>? = null
        /**
         * Specifies whether enhanced networking with ENA is enabled.
         */
        var enaSupport: kotlin.Boolean? = null
        /**
         * Indicates whether the instance is enabled for Amazon Web Services Nitro Enclaves.
         */
        var enclaveOptions: aws.sdk.kotlin.services.ec2.model.EnclaveOptions? = null
        /**
         * Indicates whether the instance is enabled for hibernation.
         */
        var hibernationOptions: aws.sdk.kotlin.services.ec2.model.HibernationOptions? = null
        /**
         * The hypervisor type of the instance. The value `xen` is used for both Xen and Nitro hypervisors.
         */
        var hypervisor: aws.sdk.kotlin.services.ec2.model.HypervisorType? = null
        /**
         * The IAM instance profile associated with the instance, if applicable.
         */
        var iamInstanceProfile: aws.sdk.kotlin.services.ec2.model.IamInstanceProfile? = null
        /**
         * The ID of the AMI used to launch the instance.
         */
        var imageId: kotlin.String? = null
        /**
         * The ID of the instance.
         */
        var instanceId: kotlin.String? = null
        /**
         * Indicates whether this is a Spot Instance or a Scheduled Instance.
         */
        var instanceLifecycle: aws.sdk.kotlin.services.ec2.model.InstanceLifecycleType? = null
        /**
         * The instance type.
         */
        var instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = null
        /**
         * The IPv6 address assigned to the instance.
         */
        var ipv6Address: kotlin.String? = null
        /**
         * The kernel associated with this instance, if applicable.
         */
        var kernelId: kotlin.String? = null
        /**
         * The name of the key pair, if this instance was launched with an associated key pair.
         */
        var keyName: kotlin.String? = null
        /**
         * The time the instance was launched.
         */
        var launchTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The license configurations for the instance.
         */
        var licenses: List<LicenseConfiguration>? = null
        /**
         * Provides information on the recovery and maintenance options of your instance.
         */
        var maintenanceOptions: aws.sdk.kotlin.services.ec2.model.InstanceMaintenanceOptions? = null
        /**
         * The metadata options for the instance.
         */
        var metadataOptions: aws.sdk.kotlin.services.ec2.model.InstanceMetadataOptionsResponse? = null
        /**
         * The monitoring for the instance.
         */
        var monitoring: aws.sdk.kotlin.services.ec2.model.Monitoring? = null
        /**
         * &#91;EC2-VPC&#93; The network interfaces for the instance.
         */
        var networkInterfaces: List<InstanceNetworkInterface>? = null
        /**
         * The Amazon Resource Name (ARN) of the Outpost.
         */
        var outpostArn: kotlin.String? = null
        /**
         * The location where the instance launched, if applicable.
         */
        var placement: aws.sdk.kotlin.services.ec2.model.Placement? = null
        /**
         * The value is `Windows` for Windows instances; otherwise blank.
         */
        var platform: aws.sdk.kotlin.services.ec2.model.PlatformValues? = null
        /**
         * The platform details value for the instance. For more information, see [AMI billing information fields](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html) in the *Amazon EC2 User Guide*.
         */
        var platformDetails: kotlin.String? = null
        /**
         * (IPv4 only) The private DNS hostname name assigned to the instance. This DNS hostname can only be used inside the Amazon EC2 network. This name is not available until the instance enters the `running` state.
         *
         * &#91;EC2-VPC&#93; The Amazon-provided DNS server resolves Amazon-provided private DNS hostnames if you've enabled DNS resolution and DNS hostnames in your VPC. If you are not using the Amazon-provided DNS server in your VPC, your custom domain name servers must resolve the hostname as appropriate.
         */
        var privateDnsName: kotlin.String? = null
        /**
         * The options for the instance hostname.
         */
        var privateDnsNameOptions: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsResponse? = null
        /**
         * The private IPv4 address assigned to the instance.
         */
        var privateIpAddress: kotlin.String? = null
        /**
         * The product codes attached to this instance, if applicable.
         */
        var productCodes: List<ProductCode>? = null
        /**
         * (IPv4 only) The public DNS name assigned to the instance. This name is not available until the instance enters the `running` state. For EC2-VPC, this name is only available if you've enabled DNS hostnames for your VPC.
         */
        var publicDnsName: kotlin.String? = null
        /**
         * The public IPv4 address, or the Carrier IP address assigned to the instance, if applicable.
         *
         * A Carrier IP address only applies to an instance launched in a subnet associated with a Wavelength Zone.
         */
        var publicIpAddress: kotlin.String? = null
        /**
         * The RAM disk associated with this instance, if applicable.
         */
        var ramdiskId: kotlin.String? = null
        /**
         * The device name of the root device volume (for example, `/dev/sda1`).
         */
        var rootDeviceName: kotlin.String? = null
        /**
         * The root device type used by the AMI. The AMI can use an EBS volume or an instance store volume.
         */
        var rootDeviceType: aws.sdk.kotlin.services.ec2.model.DeviceType? = null
        /**
         * The security groups for the instance.
         */
        var securityGroups: List<GroupIdentifier>? = null
        /**
         * Indicates whether source/destination checking is enabled.
         */
        var sourceDestCheck: kotlin.Boolean? = null
        /**
         * If the request is a Spot Instance request, the ID of the request.
         */
        var spotInstanceRequestId: kotlin.String? = null
        /**
         * Specifies whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         */
        var sriovNetSupport: kotlin.String? = null
        /**
         * The current state of the instance.
         */
        var state: aws.sdk.kotlin.services.ec2.model.InstanceState? = null
        /**
         * The reason for the most recent state transition.
         */
        var stateReason: aws.sdk.kotlin.services.ec2.model.StateReason? = null
        /**
         * The reason for the most recent state transition. This might be an empty string.
         */
        var stateTransitionReason: kotlin.String? = null
        /**
         * &#91;EC2-VPC&#93; The ID of the subnet in which the instance is running.
         */
        var subnetId: kotlin.String? = null
        /**
         * Any tags assigned to the instance.
         */
        var tags: List<Tag>? = null
        /**
         * If the instance is configured for NitroTPM support, the value is `v2.0`. For more information, see [NitroTPM](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nitrotpm.html) in the *Amazon EC2 User Guide*.
         */
        var tpmSupport: kotlin.String? = null
        /**
         * The usage operation value for the instance. For more information, see [AMI billing information fields](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/billing-info-fields.html) in the *Amazon EC2 User Guide*.
         */
        var usageOperation: kotlin.String? = null
        /**
         * The time that the usage operation was last updated.
         */
        var usageOperationUpdateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The virtualization type of the instance.
         */
        var virtualizationType: aws.sdk.kotlin.services.ec2.model.VirtualizationType? = null
        /**
         * &#91;EC2-VPC&#93; The ID of the VPC in which the instance is running.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.Instance) : this() {
            this.amiLaunchIndex = x.amiLaunchIndex
            this.architecture = x.architecture
            this.blockDeviceMappings = x.blockDeviceMappings
            this.bootMode = x.bootMode
            this.capacityReservationId = x.capacityReservationId
            this.capacityReservationSpecification = x.capacityReservationSpecification
            this.clientToken = x.clientToken
            this.cpuOptions = x.cpuOptions
            this.ebsOptimized = x.ebsOptimized
            this.elasticGpuAssociations = x.elasticGpuAssociations
            this.elasticInferenceAcceleratorAssociations = x.elasticInferenceAcceleratorAssociations
            this.enaSupport = x.enaSupport
            this.enclaveOptions = x.enclaveOptions
            this.hibernationOptions = x.hibernationOptions
            this.hypervisor = x.hypervisor
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceId = x.instanceId
            this.instanceLifecycle = x.instanceLifecycle
            this.instanceType = x.instanceType
            this.ipv6Address = x.ipv6Address
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.launchTime = x.launchTime
            this.licenses = x.licenses
            this.maintenanceOptions = x.maintenanceOptions
            this.metadataOptions = x.metadataOptions
            this.monitoring = x.monitoring
            this.networkInterfaces = x.networkInterfaces
            this.outpostArn = x.outpostArn
            this.placement = x.placement
            this.platform = x.platform
            this.platformDetails = x.platformDetails
            this.privateDnsName = x.privateDnsName
            this.privateDnsNameOptions = x.privateDnsNameOptions
            this.privateIpAddress = x.privateIpAddress
            this.productCodes = x.productCodes
            this.publicDnsName = x.publicDnsName
            this.publicIpAddress = x.publicIpAddress
            this.ramdiskId = x.ramdiskId
            this.rootDeviceName = x.rootDeviceName
            this.rootDeviceType = x.rootDeviceType
            this.securityGroups = x.securityGroups
            this.sourceDestCheck = x.sourceDestCheck
            this.spotInstanceRequestId = x.spotInstanceRequestId
            this.sriovNetSupport = x.sriovNetSupport
            this.state = x.state
            this.stateReason = x.stateReason
            this.stateTransitionReason = x.stateTransitionReason
            this.subnetId = x.subnetId
            this.tags = x.tags
            this.tpmSupport = x.tpmSupport
            this.usageOperation = x.usageOperation
            this.usageOperationUpdateTime = x.usageOperationUpdateTime
            this.virtualizationType = x.virtualizationType
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.Instance = Instance(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecificationResponse] inside the given [block]
         */
        fun capacityReservationSpecification(block: aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecificationResponse.Builder.() -> kotlin.Unit) {
            this.capacityReservationSpecification = aws.sdk.kotlin.services.ec2.model.CapacityReservationSpecificationResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CpuOptions] inside the given [block]
         */
        fun cpuOptions(block: aws.sdk.kotlin.services.ec2.model.CpuOptions.Builder.() -> kotlin.Unit) {
            this.cpuOptions = aws.sdk.kotlin.services.ec2.model.CpuOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.EnclaveOptions] inside the given [block]
         */
        fun enclaveOptions(block: aws.sdk.kotlin.services.ec2.model.EnclaveOptions.Builder.() -> kotlin.Unit) {
            this.enclaveOptions = aws.sdk.kotlin.services.ec2.model.EnclaveOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.HibernationOptions] inside the given [block]
         */
        fun hibernationOptions(block: aws.sdk.kotlin.services.ec2.model.HibernationOptions.Builder.() -> kotlin.Unit) {
            this.hibernationOptions = aws.sdk.kotlin.services.ec2.model.HibernationOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.IamInstanceProfile] inside the given [block]
         */
        fun iamInstanceProfile(block: aws.sdk.kotlin.services.ec2.model.IamInstanceProfile.Builder.() -> kotlin.Unit) {
            this.iamInstanceProfile = aws.sdk.kotlin.services.ec2.model.IamInstanceProfile.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceMaintenanceOptions] inside the given [block]
         */
        fun maintenanceOptions(block: aws.sdk.kotlin.services.ec2.model.InstanceMaintenanceOptions.Builder.() -> kotlin.Unit) {
            this.maintenanceOptions = aws.sdk.kotlin.services.ec2.model.InstanceMaintenanceOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceMetadataOptionsResponse] inside the given [block]
         */
        fun metadataOptions(block: aws.sdk.kotlin.services.ec2.model.InstanceMetadataOptionsResponse.Builder.() -> kotlin.Unit) {
            this.metadataOptions = aws.sdk.kotlin.services.ec2.model.InstanceMetadataOptionsResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.Monitoring] inside the given [block]
         */
        fun monitoring(block: aws.sdk.kotlin.services.ec2.model.Monitoring.Builder.() -> kotlin.Unit) {
            this.monitoring = aws.sdk.kotlin.services.ec2.model.Monitoring.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.Placement] inside the given [block]
         */
        fun placement(block: aws.sdk.kotlin.services.ec2.model.Placement.Builder.() -> kotlin.Unit) {
            this.placement = aws.sdk.kotlin.services.ec2.model.Placement.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsResponse] inside the given [block]
         */
        fun privateDnsNameOptions(block: aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsResponse.Builder.() -> kotlin.Unit) {
            this.privateDnsNameOptions = aws.sdk.kotlin.services.ec2.model.PrivateDnsNameOptionsResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceState] inside the given [block]
         */
        fun state(block: aws.sdk.kotlin.services.ec2.model.InstanceState.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.ec2.model.InstanceState.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.StateReason] inside the given [block]
         */
        fun stateReason(block: aws.sdk.kotlin.services.ec2.model.StateReason.Builder.() -> kotlin.Unit) {
            this.stateReason = aws.sdk.kotlin.services.ec2.model.StateReason.invoke(block)
        }
    }
}
