// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * In IPAM, a pool is a collection of contiguous IP addresses CIDRs. Pools enable you to organize your IP addresses according to your routing and security needs. For example, if you have separate routing and security needs for development and production applications, you can create a pool for each.
 */
class IpamPool private constructor(builder: Builder) {
    /**
     * The address family of the pool.
     */
    val addressFamily: aws.sdk.kotlin.services.ec2.model.AddressFamily? = builder.addressFamily
    /**
     * The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
     */
    val allocationDefaultNetmaskLength: kotlin.Int? = builder.allocationDefaultNetmaskLength
    /**
     * The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. The maximum netmask length must be greater than the minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
     */
    val allocationMaxNetmaskLength: kotlin.Int? = builder.allocationMaxNetmaskLength
    /**
     * The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. The minimum netmask length must be less than the maximum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
     */
    val allocationMinNetmaskLength: kotlin.Int? = builder.allocationMinNetmaskLength
    /**
     * Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
     */
    val allocationResourceTags: List<IpamResourceTag>? = builder.allocationResourceTags
    /**
     * If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only.
     *
     * A locale must be set on the pool for this feature to work.
     */
    val autoImport: kotlin.Boolean? = builder.autoImport
    /**
     * Limits which service in Amazon Web Services that the pool can be used in. "ec2", for example, allows users to use space for Elastic IP addresses and VPCs.
     */
    val awsService: aws.sdk.kotlin.services.ec2.model.IpamPoolAwsService? = builder.awsService
    /**
     * The description of the IPAM pool.
     */
    val description: kotlin.String? = builder.description
    /**
     * The ARN of the IPAM.
     */
    val ipamArn: kotlin.String? = builder.ipamArn
    /**
     * The ARN of the IPAM pool.
     */
    val ipamPoolArn: kotlin.String? = builder.ipamPoolArn
    /**
     * The ID of the IPAM pool.
     */
    val ipamPoolId: kotlin.String? = builder.ipamPoolId
    /**
     * The Amazon Web Services Region of the IPAM pool.
     */
    val ipamRegion: kotlin.String? = builder.ipamRegion
    /**
     * The ARN of the scope of the IPAM pool.
     */
    val ipamScopeArn: kotlin.String? = builder.ipamScopeArn
    /**
     * In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP addresses across multiple unconnected networks without causing IP address overlap or conflict.
     */
    val ipamScopeType: aws.sdk.kotlin.services.ec2.model.IpamScopeType? = builder.ipamScopeType
    /**
     * The locale of the IPAM pool. In IPAM, the locale is the Amazon Web Services Region where you want to make an IPAM pool available for allocations. Only resources in the same Region as the locale of the pool can get IP address allocations from the pool. You can only allocate a CIDR for a VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that once you choose a Locale for a pool, you cannot modify it. If you choose an Amazon Web Services Region for locale that has not been configured as an operating Region for the IPAM, you'll get an error.
     */
    val locale: kotlin.String? = builder.locale
    /**
     * The Amazon Web Services account ID of the owner of the IPAM pool.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * The depth of pools in your IPAM pool. The pool depth quota is 10. For more information, see [Quotas in IPAM](/vpc/latest/ipam/quotas-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    val poolDepth: kotlin.Int? = builder.poolDepth
    /**
     * Determines if a pool is publicly advertisable. This option is not available for pools with AddressFamily set to `ipv4`.
     */
    val publiclyAdvertisable: kotlin.Boolean? = builder.publiclyAdvertisable
    /**
     * The ID of the source IPAM pool. You can use this option to create an IPAM pool within an existing source pool.
     */
    val sourceIpamPoolId: kotlin.String? = builder.sourceIpamPoolId
    /**
     * The state of the IPAM pool.
     */
    val state: aws.sdk.kotlin.services.ec2.model.IpamPoolState? = builder.state
    /**
     * A message related to the failed creation of an IPAM pool.
     */
    val stateMessage: kotlin.String? = builder.stateMessage
    /**
     * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
     */
    val tags: List<Tag>? = builder.tags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.IpamPool = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IpamPool(")
        append("addressFamily=$addressFamily,")
        append("allocationDefaultNetmaskLength=$allocationDefaultNetmaskLength,")
        append("allocationMaxNetmaskLength=$allocationMaxNetmaskLength,")
        append("allocationMinNetmaskLength=$allocationMinNetmaskLength,")
        append("allocationResourceTags=$allocationResourceTags,")
        append("autoImport=$autoImport,")
        append("awsService=$awsService,")
        append("description=$description,")
        append("ipamArn=$ipamArn,")
        append("ipamPoolArn=$ipamPoolArn,")
        append("ipamPoolId=$ipamPoolId,")
        append("ipamRegion=$ipamRegion,")
        append("ipamScopeArn=$ipamScopeArn,")
        append("ipamScopeType=$ipamScopeType,")
        append("locale=$locale,")
        append("ownerId=$ownerId,")
        append("poolDepth=$poolDepth,")
        append("publiclyAdvertisable=$publiclyAdvertisable,")
        append("sourceIpamPoolId=$sourceIpamPoolId,")
        append("state=$state,")
        append("stateMessage=$stateMessage,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressFamily?.hashCode() ?: 0
        result = 31 * result + (allocationDefaultNetmaskLength ?: 0)
        result = 31 * result + (allocationMaxNetmaskLength ?: 0)
        result = 31 * result + (allocationMinNetmaskLength ?: 0)
        result = 31 * result + (allocationResourceTags?.hashCode() ?: 0)
        result = 31 * result + (autoImport?.hashCode() ?: 0)
        result = 31 * result + (awsService?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (ipamArn?.hashCode() ?: 0)
        result = 31 * result + (ipamPoolArn?.hashCode() ?: 0)
        result = 31 * result + (ipamPoolId?.hashCode() ?: 0)
        result = 31 * result + (ipamRegion?.hashCode() ?: 0)
        result = 31 * result + (ipamScopeArn?.hashCode() ?: 0)
        result = 31 * result + (ipamScopeType?.hashCode() ?: 0)
        result = 31 * result + (locale?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (poolDepth ?: 0)
        result = 31 * result + (publiclyAdvertisable?.hashCode() ?: 0)
        result = 31 * result + (sourceIpamPoolId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateMessage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IpamPool

        if (addressFamily != other.addressFamily) return false
        if (allocationDefaultNetmaskLength != other.allocationDefaultNetmaskLength) return false
        if (allocationMaxNetmaskLength != other.allocationMaxNetmaskLength) return false
        if (allocationMinNetmaskLength != other.allocationMinNetmaskLength) return false
        if (allocationResourceTags != other.allocationResourceTags) return false
        if (autoImport != other.autoImport) return false
        if (awsService != other.awsService) return false
        if (description != other.description) return false
        if (ipamArn != other.ipamArn) return false
        if (ipamPoolArn != other.ipamPoolArn) return false
        if (ipamPoolId != other.ipamPoolId) return false
        if (ipamRegion != other.ipamRegion) return false
        if (ipamScopeArn != other.ipamScopeArn) return false
        if (ipamScopeType != other.ipamScopeType) return false
        if (locale != other.locale) return false
        if (ownerId != other.ownerId) return false
        if (poolDepth != other.poolDepth) return false
        if (publiclyAdvertisable != other.publiclyAdvertisable) return false
        if (sourceIpamPoolId != other.sourceIpamPoolId) return false
        if (state != other.state) return false
        if (stateMessage != other.stateMessage) return false
        if (tags != other.tags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.IpamPool = Builder(this).apply(block).build()

    class Builder {
        /**
         * The address family of the pool.
         */
        var addressFamily: aws.sdk.kotlin.services.ec2.model.AddressFamily? = null
        /**
         * The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
         */
        var allocationDefaultNetmaskLength: kotlin.Int? = null
        /**
         * The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. The maximum netmask length must be greater than the minimum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
         */
        var allocationMaxNetmaskLength: kotlin.Int? = null
        /**
         * The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. The minimum netmask length must be less than the maximum netmask length. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.
         */
        var allocationMinNetmaskLength: kotlin.Int? = null
        /**
         * Tags that are required for resources that use CIDRs from this IPAM pool. Resources that do not have these tags will not be allowed to allocate space from the pool. If the resources have their tags changed after they have allocated space or if the allocation tagging requirements are changed on the pool, the resource may be marked as noncompliant.
         */
        var allocationResourceTags: List<IpamResourceTag>? = null
        /**
         * If selected, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only.
         *
         * A locale must be set on the pool for this feature to work.
         */
        var autoImport: kotlin.Boolean? = null
        /**
         * Limits which service in Amazon Web Services that the pool can be used in. "ec2", for example, allows users to use space for Elastic IP addresses and VPCs.
         */
        var awsService: aws.sdk.kotlin.services.ec2.model.IpamPoolAwsService? = null
        /**
         * The description of the IPAM pool.
         */
        var description: kotlin.String? = null
        /**
         * The ARN of the IPAM.
         */
        var ipamArn: kotlin.String? = null
        /**
         * The ARN of the IPAM pool.
         */
        var ipamPoolArn: kotlin.String? = null
        /**
         * The ID of the IPAM pool.
         */
        var ipamPoolId: kotlin.String? = null
        /**
         * The Amazon Web Services Region of the IPAM pool.
         */
        var ipamRegion: kotlin.String? = null
        /**
         * The ARN of the scope of the IPAM pool.
         */
        var ipamScopeArn: kotlin.String? = null
        /**
         * In IPAM, a scope is the highest-level container within IPAM. An IPAM contains two default scopes. Each scope represents the IP space for a single network. The private scope is intended for all private IP address space. The public scope is intended for all public IP address space. Scopes enable you to reuse IP addresses across multiple unconnected networks without causing IP address overlap or conflict.
         */
        var ipamScopeType: aws.sdk.kotlin.services.ec2.model.IpamScopeType? = null
        /**
         * The locale of the IPAM pool. In IPAM, the locale is the Amazon Web Services Region where you want to make an IPAM pool available for allocations. Only resources in the same Region as the locale of the pool can get IP address allocations from the pool. You can only allocate a CIDR for a VPC, for example, from an IPAM pool that shares a locale with the VPC’s Region. Note that once you choose a Locale for a pool, you cannot modify it. If you choose an Amazon Web Services Region for locale that has not been configured as an operating Region for the IPAM, you'll get an error.
         */
        var locale: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the owner of the IPAM pool.
         */
        var ownerId: kotlin.String? = null
        /**
         * The depth of pools in your IPAM pool. The pool depth quota is 10. For more information, see [Quotas in IPAM](/vpc/latest/ipam/quotas-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        var poolDepth: kotlin.Int? = null
        /**
         * Determines if a pool is publicly advertisable. This option is not available for pools with AddressFamily set to `ipv4`.
         */
        var publiclyAdvertisable: kotlin.Boolean? = null
        /**
         * The ID of the source IPAM pool. You can use this option to create an IPAM pool within an existing source pool.
         */
        var sourceIpamPoolId: kotlin.String? = null
        /**
         * The state of the IPAM pool.
         */
        var state: aws.sdk.kotlin.services.ec2.model.IpamPoolState? = null
        /**
         * A message related to the failed creation of an IPAM pool.
         */
        var stateMessage: kotlin.String? = null
        /**
         * The key/value combination of a tag assigned to the resource. Use the tag key in the filter name and the tag value as the filter value. For example, to find all resources that have a tag with the key `Owner` and the value `TeamA`, specify `tag:Owner` for the filter name and `TeamA` for the filter value.
         */
        var tags: List<Tag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.IpamPool) : this() {
            this.addressFamily = x.addressFamily
            this.allocationDefaultNetmaskLength = x.allocationDefaultNetmaskLength
            this.allocationMaxNetmaskLength = x.allocationMaxNetmaskLength
            this.allocationMinNetmaskLength = x.allocationMinNetmaskLength
            this.allocationResourceTags = x.allocationResourceTags
            this.autoImport = x.autoImport
            this.awsService = x.awsService
            this.description = x.description
            this.ipamArn = x.ipamArn
            this.ipamPoolArn = x.ipamPoolArn
            this.ipamPoolId = x.ipamPoolId
            this.ipamRegion = x.ipamRegion
            this.ipamScopeArn = x.ipamScopeArn
            this.ipamScopeType = x.ipamScopeType
            this.locale = x.locale
            this.ownerId = x.ownerId
            this.poolDepth = x.poolDepth
            this.publiclyAdvertisable = x.publiclyAdvertisable
            this.sourceIpamPoolId = x.sourceIpamPoolId
            this.state = x.state
            this.stateMessage = x.stateMessage
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.IpamPool = IpamPool(this)
    }
}
