// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a block device for an EBS volume.
 */
class LaunchTemplateEbsBlockDevice private constructor(builder: Builder) {
    /**
     * Indicates whether the EBS volume is deleted on instance termination.
     */
    val deleteOnTermination: kotlin.Boolean? = builder.deleteOnTermination
    /**
     * Indicates whether the EBS volume is encrypted.
     */
    val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The number of I/O operations per second (IOPS) that the volume supports.
     */
    val iops: kotlin.Int? = builder.iops
    /**
     * The ARN of the Key Management Service (KMS) CMK used for encryption.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The ID of the snapshot.
     */
    val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The throughput that the volume supports, in MiB/s.
     */
    val throughput: kotlin.Int? = builder.throughput
    /**
     * The size of the volume, in GiB.
     */
    val volumeSize: kotlin.Int? = builder.volumeSize
    /**
     * The volume type.
     */
    val volumeType: aws.sdk.kotlin.services.ec2.model.VolumeType? = builder.volumeType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.LaunchTemplateEbsBlockDevice = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LaunchTemplateEbsBlockDevice(")
        append("deleteOnTermination=$deleteOnTermination,")
        append("encrypted=$encrypted,")
        append("iops=$iops,")
        append("kmsKeyId=$kmsKeyId,")
        append("snapshotId=$snapshotId,")
        append("throughput=$throughput,")
        append("volumeSize=$volumeSize,")
        append("volumeType=$volumeType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deleteOnTermination?.hashCode() ?: 0
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (iops ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (throughput ?: 0)
        result = 31 * result + (volumeSize ?: 0)
        result = 31 * result + (volumeType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LaunchTemplateEbsBlockDevice

        if (deleteOnTermination != other.deleteOnTermination) return false
        if (encrypted != other.encrypted) return false
        if (iops != other.iops) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (snapshotId != other.snapshotId) return false
        if (throughput != other.throughput) return false
        if (volumeSize != other.volumeSize) return false
        if (volumeType != other.volumeType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.LaunchTemplateEbsBlockDevice = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether the EBS volume is deleted on instance termination.
         */
        var deleteOnTermination: kotlin.Boolean? = null
        /**
         * Indicates whether the EBS volume is encrypted.
         */
        var encrypted: kotlin.Boolean? = null
        /**
         * The number of I/O operations per second (IOPS) that the volume supports.
         */
        var iops: kotlin.Int? = null
        /**
         * The ARN of the Key Management Service (KMS) CMK used for encryption.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The ID of the snapshot.
         */
        var snapshotId: kotlin.String? = null
        /**
         * The throughput that the volume supports, in MiB/s.
         */
        var throughput: kotlin.Int? = null
        /**
         * The size of the volume, in GiB.
         */
        var volumeSize: kotlin.Int? = null
        /**
         * The volume type.
         */
        var volumeType: aws.sdk.kotlin.services.ec2.model.VolumeType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.LaunchTemplateEbsBlockDevice) : this() {
            this.deleteOnTermination = x.deleteOnTermination
            this.encrypted = x.encrypted
            this.iops = x.iops
            this.kmsKeyId = x.kmsKeyId
            this.snapshotId = x.snapshotId
            this.throughput = x.throughput
            this.volumeSize = x.volumeSize
            this.volumeType = x.volumeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.LaunchTemplateEbsBlockDevice = LaunchTemplateEbsBlockDevice(this)
    }
}
