// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a local gateway virtual interface.
 */
class LocalGatewayVirtualInterface private constructor(builder: Builder) {
    /**
     * The local address.
     */
    val localAddress: kotlin.String? = builder.localAddress
    /**
     * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
     */
    val localBgpAsn: kotlin.Int? = builder.localBgpAsn
    /**
     * The ID of the local gateway.
     */
    val localGatewayId: kotlin.String? = builder.localGatewayId
    /**
     * The ID of the virtual interface.
     */
    val localGatewayVirtualInterfaceId: kotlin.String? = builder.localGatewayVirtualInterfaceId
    /**
     * The ID of the Amazon Web Services account that owns the local gateway virtual interface.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * The peer address.
     */
    val peerAddress: kotlin.String? = builder.peerAddress
    /**
     * The peer BGP ASN.
     */
    val peerBgpAsn: kotlin.Int? = builder.peerBgpAsn
    /**
     * The tags assigned to the virtual interface.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VLAN.
     */
    val vlan: kotlin.Int? = builder.vlan

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.LocalGatewayVirtualInterface = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LocalGatewayVirtualInterface(")
        append("localAddress=$localAddress,")
        append("localBgpAsn=$localBgpAsn,")
        append("localGatewayId=$localGatewayId,")
        append("localGatewayVirtualInterfaceId=$localGatewayVirtualInterfaceId,")
        append("ownerId=$ownerId,")
        append("peerAddress=$peerAddress,")
        append("peerBgpAsn=$peerBgpAsn,")
        append("tags=$tags,")
        append("vlan=$vlan)")
    }

    override fun hashCode(): kotlin.Int {
        var result = localAddress?.hashCode() ?: 0
        result = 31 * result + (localBgpAsn ?: 0)
        result = 31 * result + (localGatewayId?.hashCode() ?: 0)
        result = 31 * result + (localGatewayVirtualInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (peerAddress?.hashCode() ?: 0)
        result = 31 * result + (peerBgpAsn ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vlan ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LocalGatewayVirtualInterface

        if (localAddress != other.localAddress) return false
        if (localBgpAsn != other.localBgpAsn) return false
        if (localGatewayId != other.localGatewayId) return false
        if (localGatewayVirtualInterfaceId != other.localGatewayVirtualInterfaceId) return false
        if (ownerId != other.ownerId) return false
        if (peerAddress != other.peerAddress) return false
        if (peerBgpAsn != other.peerBgpAsn) return false
        if (tags != other.tags) return false
        if (vlan != other.vlan) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.LocalGatewayVirtualInterface = Builder(this).apply(block).build()

    class Builder {
        /**
         * The local address.
         */
        var localAddress: kotlin.String? = null
        /**
         * The Border Gateway Protocol (BGP) Autonomous System Number (ASN) of the local gateway.
         */
        var localBgpAsn: kotlin.Int? = null
        /**
         * The ID of the local gateway.
         */
        var localGatewayId: kotlin.String? = null
        /**
         * The ID of the virtual interface.
         */
        var localGatewayVirtualInterfaceId: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the local gateway virtual interface.
         */
        var ownerId: kotlin.String? = null
        /**
         * The peer address.
         */
        var peerAddress: kotlin.String? = null
        /**
         * The peer BGP ASN.
         */
        var peerBgpAsn: kotlin.Int? = null
        /**
         * The tags assigned to the virtual interface.
         */
        var tags: List<Tag>? = null
        /**
         * The ID of the VLAN.
         */
        var vlan: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.LocalGatewayVirtualInterface) : this() {
            this.localAddress = x.localAddress
            this.localBgpAsn = x.localBgpAsn
            this.localGatewayId = x.localGatewayId
            this.localGatewayVirtualInterfaceId = x.localGatewayVirtualInterfaceId
            this.ownerId = x.ownerId
            this.peerAddress = x.peerAddress
            this.peerBgpAsn = x.peerBgpAsn
            this.tags = x.tags
            this.vlan = x.vlan
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.LocalGatewayVirtualInterface = LocalGatewayVirtualInterface(this)
    }
}
