// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ModifyInstanceAttributeRequest private constructor(builder: Builder) {
    /**
     * The name of the attribute.
     */
    val attribute: aws.sdk.kotlin.services.ec2.model.InstanceAttributeName? = builder.attribute
    /**
     * Modifies the `DeleteOnTermination` attribute for volumes that are currently attached. The volume must be owned by the caller. If no value is specified for `DeleteOnTermination`, the default is `true` and the volume is deleted when the instance is terminated.
     *
     * To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the instance. For more information, see [Update the block device mapping when launching an instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM) in the *Amazon EC2 User Guide*.
     */
    val blockDeviceMappings: List<InstanceBlockDeviceMappingSpecification>? = builder.blockDeviceMappings
    /**
     * Indicates whether an instance is enabled for stop protection. For more information, see [Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
     */
    val disableApiStop: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue? = builder.disableApiStop
    /**
     * If the value is `true`, you can't terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. You cannot use this parameter for Spot Instances.
     */
    val disableApiTermination: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue? = builder.disableApiTermination
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * Specifies whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     */
    val ebsOptimized: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue? = builder.ebsOptimized
    /**
     * Set to `true` to enable enhanced networking with ENA for the instance.
     *
     * This option is supported only for HVM instances. Specifying this option with a PV instance can make it unreachable.
     */
    val enaSupport: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue? = builder.enaSupport
    /**
     * &#91;EC2-VPC&#93; Replaces the security groups of the instance with the specified security groups. You must specify at least one security group, even if it's just the default security group for the VPC. You must specify the security group ID, not the security group name.
     */
    val groups: List<String>? = builder.groups
    /**
     * The ID of the instance.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
     */
    val instanceInitiatedShutdownBehavior: aws.sdk.kotlin.services.ec2.model.AttributeValue? = builder.instanceInitiatedShutdownBehavior
    /**
     * Changes the instance type to the specified value. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide*. If the instance type is not valid, the error returned is `InvalidInstanceAttributeValue`.
     */
    val instanceType: aws.sdk.kotlin.services.ec2.model.AttributeValue? = builder.instanceType
    /**
     * Changes the instance's kernel to the specified value. We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [PV-GRUB](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html).
     */
    val kernel: aws.sdk.kotlin.services.ec2.model.AttributeValue? = builder.kernel
    /**
     * Changes the instance's RAM disk to the specified value. We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [PV-GRUB](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html).
     */
    val ramdisk: aws.sdk.kotlin.services.ec2.model.AttributeValue? = builder.ramdisk
    /**
     * Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives. If the value is `true`, source/destination checks are enabled; otherwise, they are disabled. The default value is `true`. You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
     */
    val sourceDestCheck: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue? = builder.sourceDestCheck
    /**
     * Set to `simple` to enable enhanced networking with the Intel 82599 Virtual Function interface for the instance.
     *
     * There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this time.
     *
     * This option is supported only for HVM instances. Specifying this option with a PV instance can make it unreachable.
     */
    val sriovNetSupport: aws.sdk.kotlin.services.ec2.model.AttributeValue? = builder.sriovNetSupport
    /**
     * Changes the instance's user data to the specified value. If you are using an Amazon Web Services SDK or command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text.
     */
    val userData: aws.sdk.kotlin.services.ec2.model.BlobAttributeValue? = builder.userData
    /**
     * A new value for the attribute. Use only with the `kernel`, `ramdisk`, `userData`, `disableApiTermination`, or `instanceInitiatedShutdownBehavior` attribute.
     */
    val value: kotlin.String? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ModifyInstanceAttributeRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyInstanceAttributeRequest(")
        append("attribute=$attribute,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("disableApiStop=$disableApiStop,")
        append("disableApiTermination=$disableApiTermination,")
        append("dryRun=$dryRun,")
        append("ebsOptimized=$ebsOptimized,")
        append("enaSupport=$enaSupport,")
        append("groups=$groups,")
        append("instanceId=$instanceId,")
        append("instanceInitiatedShutdownBehavior=$instanceInitiatedShutdownBehavior,")
        append("instanceType=$instanceType,")
        append("kernel=$kernel,")
        append("ramdisk=$ramdisk,")
        append("sourceDestCheck=$sourceDestCheck,")
        append("sriovNetSupport=$sriovNetSupport,")
        append("userData=$userData,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = attribute?.hashCode() ?: 0
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (disableApiStop?.hashCode() ?: 0)
        result = 31 * result + (disableApiTermination?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (enaSupport?.hashCode() ?: 0)
        result = 31 * result + (groups?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceInitiatedShutdownBehavior?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernel?.hashCode() ?: 0)
        result = 31 * result + (ramdisk?.hashCode() ?: 0)
        result = 31 * result + (sourceDestCheck?.hashCode() ?: 0)
        result = 31 * result + (sriovNetSupport?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyInstanceAttributeRequest

        if (attribute != other.attribute) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (disableApiStop != other.disableApiStop) return false
        if (disableApiTermination != other.disableApiTermination) return false
        if (dryRun != other.dryRun) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (enaSupport != other.enaSupport) return false
        if (groups != other.groups) return false
        if (instanceId != other.instanceId) return false
        if (instanceInitiatedShutdownBehavior != other.instanceInitiatedShutdownBehavior) return false
        if (instanceType != other.instanceType) return false
        if (kernel != other.kernel) return false
        if (ramdisk != other.ramdisk) return false
        if (sourceDestCheck != other.sourceDestCheck) return false
        if (sriovNetSupport != other.sriovNetSupport) return false
        if (userData != other.userData) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ModifyInstanceAttributeRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the attribute.
         */
        var attribute: aws.sdk.kotlin.services.ec2.model.InstanceAttributeName? = null
        /**
         * Modifies the `DeleteOnTermination` attribute for volumes that are currently attached. The volume must be owned by the caller. If no value is specified for `DeleteOnTermination`, the default is `true` and the volume is deleted when the instance is terminated.
         *
         * To add instance store volumes to an Amazon EBS-backed instance, you must add them when you launch the instance. For more information, see [Update the block device mapping when launching an instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM) in the *Amazon EC2 User Guide*.
         */
        var blockDeviceMappings: List<InstanceBlockDeviceMappingSpecification>? = null
        /**
         * Indicates whether an instance is enabled for stop protection. For more information, see [Stop Protection](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Stop_Start.html#Using_StopProtection).
         */
        var disableApiStop: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue? = null
        /**
         * If the value is `true`, you can't terminate the instance using the Amazon EC2 console, CLI, or API; otherwise, you can. You cannot use this parameter for Spot Instances.
         */
        var disableApiTermination: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * Specifies whether the instance is optimized for Amazon EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
         */
        var ebsOptimized: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue? = null
        /**
         * Set to `true` to enable enhanced networking with ENA for the instance.
         *
         * This option is supported only for HVM instances. Specifying this option with a PV instance can make it unreachable.
         */
        var enaSupport: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue? = null
        /**
         * &#91;EC2-VPC&#93; Replaces the security groups of the instance with the specified security groups. You must specify at least one security group, even if it's just the default security group for the VPC. You must specify the security group ID, not the security group name.
         */
        var groups: List<String>? = null
        /**
         * The ID of the instance.
         */
        var instanceId: kotlin.String? = null
        /**
         * Specifies whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
         */
        var instanceInitiatedShutdownBehavior: aws.sdk.kotlin.services.ec2.model.AttributeValue? = null
        /**
         * Changes the instance type to the specified value. For more information, see [Instance types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the *Amazon EC2 User Guide*. If the instance type is not valid, the error returned is `InvalidInstanceAttributeValue`.
         */
        var instanceType: aws.sdk.kotlin.services.ec2.model.AttributeValue? = null
        /**
         * Changes the instance's kernel to the specified value. We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [PV-GRUB](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html).
         */
        var kernel: aws.sdk.kotlin.services.ec2.model.AttributeValue? = null
        /**
         * Changes the instance's RAM disk to the specified value. We recommend that you use PV-GRUB instead of kernels and RAM disks. For more information, see [PV-GRUB](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html).
         */
        var ramdisk: aws.sdk.kotlin.services.ec2.model.AttributeValue? = null
        /**
         * Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives. If the value is `true`, source/destination checks are enabled; otherwise, they are disabled. The default value is `true`. You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
         */
        var sourceDestCheck: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue? = null
        /**
         * Set to `simple` to enable enhanced networking with the Intel 82599 Virtual Function interface for the instance.
         *
         * There is no way to disable enhanced networking with the Intel 82599 Virtual Function interface at this time.
         *
         * This option is supported only for HVM instances. Specifying this option with a PV instance can make it unreachable.
         */
        var sriovNetSupport: aws.sdk.kotlin.services.ec2.model.AttributeValue? = null
        /**
         * Changes the instance's user data to the specified value. If you are using an Amazon Web Services SDK or command line tool, base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide base64-encoded text.
         */
        var userData: aws.sdk.kotlin.services.ec2.model.BlobAttributeValue? = null
        /**
         * A new value for the attribute. Use only with the `kernel`, `ramdisk`, `userData`, `disableApiTermination`, or `instanceInitiatedShutdownBehavior` attribute.
         */
        var value: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ModifyInstanceAttributeRequest) : this() {
            this.attribute = x.attribute
            this.blockDeviceMappings = x.blockDeviceMappings
            this.disableApiStop = x.disableApiStop
            this.disableApiTermination = x.disableApiTermination
            this.dryRun = x.dryRun
            this.ebsOptimized = x.ebsOptimized
            this.enaSupport = x.enaSupport
            this.groups = x.groups
            this.instanceId = x.instanceId
            this.instanceInitiatedShutdownBehavior = x.instanceInitiatedShutdownBehavior
            this.instanceType = x.instanceType
            this.kernel = x.kernel
            this.ramdisk = x.ramdisk
            this.sourceDestCheck = x.sourceDestCheck
            this.sriovNetSupport = x.sriovNetSupport
            this.userData = x.userData
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ModifyInstanceAttributeRequest = ModifyInstanceAttributeRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun disableApiStop(block: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue.Builder.() -> kotlin.Unit) {
            this.disableApiStop = aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun disableApiTermination(block: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue.Builder.() -> kotlin.Unit) {
            this.disableApiTermination = aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun ebsOptimized(block: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue.Builder.() -> kotlin.Unit) {
            this.ebsOptimized = aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun enaSupport(block: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue.Builder.() -> kotlin.Unit) {
            this.enaSupport = aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun instanceInitiatedShutdownBehavior(block: aws.sdk.kotlin.services.ec2.model.AttributeValue.Builder.() -> kotlin.Unit) {
            this.instanceInitiatedShutdownBehavior = aws.sdk.kotlin.services.ec2.model.AttributeValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun instanceType(block: aws.sdk.kotlin.services.ec2.model.AttributeValue.Builder.() -> kotlin.Unit) {
            this.instanceType = aws.sdk.kotlin.services.ec2.model.AttributeValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun kernel(block: aws.sdk.kotlin.services.ec2.model.AttributeValue.Builder.() -> kotlin.Unit) {
            this.kernel = aws.sdk.kotlin.services.ec2.model.AttributeValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun ramdisk(block: aws.sdk.kotlin.services.ec2.model.AttributeValue.Builder.() -> kotlin.Unit) {
            this.ramdisk = aws.sdk.kotlin.services.ec2.model.AttributeValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue] inside the given [block]
         */
        fun sourceDestCheck(block: aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue.Builder.() -> kotlin.Unit) {
            this.sourceDestCheck = aws.sdk.kotlin.services.ec2.model.AttributeBooleanValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.AttributeValue] inside the given [block]
         */
        fun sriovNetSupport(block: aws.sdk.kotlin.services.ec2.model.AttributeValue.Builder.() -> kotlin.Unit) {
            this.sriovNetSupport = aws.sdk.kotlin.services.ec2.model.AttributeValue.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.BlobAttributeValue] inside the given [block]
         */
        fun userData(block: aws.sdk.kotlin.services.ec2.model.BlobAttributeValue.Builder.() -> kotlin.Unit) {
            this.userData = aws.sdk.kotlin.services.ec2.model.BlobAttributeValue.invoke(block)
        }
    }
}
