// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



class ModifyIpamPoolRequest private constructor(builder: Builder) {
    /**
     * Add tag allocation rules to a pool. For more information about allocation rules, see [Create a top-level pool](/vpc/latest/ipam/create-top-ipam.html) in the *Amazon VPC IPAM User Guide*.
     */
    val addAllocationResourceTags: List<RequestIpamResourceTag>? = builder.addAllocationResourceTags
    /**
     * The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
     */
    val allocationDefaultNetmaskLength: kotlin.Int? = builder.allocationDefaultNetmaskLength
    /**
     * The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.The maximum netmask length must be greater than the minimum netmask length.
     */
    val allocationMaxNetmaskLength: kotlin.Int? = builder.allocationMaxNetmaskLength
    /**
     * The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128. The minimum netmask length must be less than the maximum netmask length.
     */
    val allocationMinNetmaskLength: kotlin.Int? = builder.allocationMinNetmaskLength
    /**
     * If true, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only.
     *
     * A locale must be set on the pool for this feature to work.
     */
    val autoImport: kotlin.Boolean? = builder.autoImport
    /**
     * Clear the default netmask length allocation rule for this pool.
     */
    val clearAllocationDefaultNetmaskLength: kotlin.Boolean? = builder.clearAllocationDefaultNetmaskLength
    /**
     * The description of the IPAM pool you want to modify.
     */
    val description: kotlin.String? = builder.description
    /**
     * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The ID of the IPAM pool you want to modify.
     */
    val ipamPoolId: kotlin.String? = builder.ipamPoolId
    /**
     * Remove tag allocation rules from a pool.
     */
    val removeAllocationResourceTags: List<RequestIpamResourceTag>? = builder.removeAllocationResourceTags

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ModifyIpamPoolRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyIpamPoolRequest(")
        append("addAllocationResourceTags=$addAllocationResourceTags,")
        append("allocationDefaultNetmaskLength=$allocationDefaultNetmaskLength,")
        append("allocationMaxNetmaskLength=$allocationMaxNetmaskLength,")
        append("allocationMinNetmaskLength=$allocationMinNetmaskLength,")
        append("autoImport=$autoImport,")
        append("clearAllocationDefaultNetmaskLength=$clearAllocationDefaultNetmaskLength,")
        append("description=$description,")
        append("dryRun=$dryRun,")
        append("ipamPoolId=$ipamPoolId,")
        append("removeAllocationResourceTags=$removeAllocationResourceTags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addAllocationResourceTags?.hashCode() ?: 0
        result = 31 * result + (allocationDefaultNetmaskLength ?: 0)
        result = 31 * result + (allocationMaxNetmaskLength ?: 0)
        result = 31 * result + (allocationMinNetmaskLength ?: 0)
        result = 31 * result + (autoImport?.hashCode() ?: 0)
        result = 31 * result + (clearAllocationDefaultNetmaskLength?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (ipamPoolId?.hashCode() ?: 0)
        result = 31 * result + (removeAllocationResourceTags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyIpamPoolRequest

        if (addAllocationResourceTags != other.addAllocationResourceTags) return false
        if (allocationDefaultNetmaskLength != other.allocationDefaultNetmaskLength) return false
        if (allocationMaxNetmaskLength != other.allocationMaxNetmaskLength) return false
        if (allocationMinNetmaskLength != other.allocationMinNetmaskLength) return false
        if (autoImport != other.autoImport) return false
        if (clearAllocationDefaultNetmaskLength != other.clearAllocationDefaultNetmaskLength) return false
        if (description != other.description) return false
        if (dryRun != other.dryRun) return false
        if (ipamPoolId != other.ipamPoolId) return false
        if (removeAllocationResourceTags != other.removeAllocationResourceTags) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ModifyIpamPoolRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Add tag allocation rules to a pool. For more information about allocation rules, see [Create a top-level pool](/vpc/latest/ipam/create-top-ipam.html) in the *Amazon VPC IPAM User Guide*.
         */
        var addAllocationResourceTags: List<RequestIpamResourceTag>? = null
        /**
         * The default netmask length for allocations added to this pool. If, for example, the CIDR assigned to this pool is 10.0.0.0/8 and you enter 16 here, new allocations will default to 10.0.0.0/16.
         */
        var allocationDefaultNetmaskLength: kotlin.Int? = null
        /**
         * The maximum netmask length possible for CIDR allocations in this IPAM pool to be compliant. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128.The maximum netmask length must be greater than the minimum netmask length.
         */
        var allocationMaxNetmaskLength: kotlin.Int? = null
        /**
         * The minimum netmask length required for CIDR allocations in this IPAM pool to be compliant. Possible netmask lengths for IPv4 addresses are 0 - 32. Possible netmask lengths for IPv6 addresses are 0 - 128. The minimum netmask length must be less than the maximum netmask length.
         */
        var allocationMinNetmaskLength: kotlin.Int? = null
        /**
         * If true, IPAM will continuously look for resources within the CIDR range of this pool and automatically import them as allocations into your IPAM. The CIDRs that will be allocated for these resources must not already be allocated to other resources in order for the import to succeed. IPAM will import a CIDR regardless of its compliance with the pool's allocation rules, so a resource might be imported and subsequently marked as noncompliant. If IPAM discovers multiple CIDRs that overlap, IPAM will import the largest CIDR only. If IPAM discovers multiple CIDRs with matching CIDRs, IPAM will randomly import one of them only.
         *
         * A locale must be set on the pool for this feature to work.
         */
        var autoImport: kotlin.Boolean? = null
        /**
         * Clear the default netmask length allocation rule for this pool.
         */
        var clearAllocationDefaultNetmaskLength: kotlin.Boolean? = null
        /**
         * The description of the IPAM pool you want to modify.
         */
        var description: kotlin.String? = null
        /**
         * A check for whether you have the required permissions for the action without actually making the request and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The ID of the IPAM pool you want to modify.
         */
        var ipamPoolId: kotlin.String? = null
        /**
         * Remove tag allocation rules from a pool.
         */
        var removeAllocationResourceTags: List<RequestIpamResourceTag>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ModifyIpamPoolRequest) : this() {
            this.addAllocationResourceTags = x.addAllocationResourceTags
            this.allocationDefaultNetmaskLength = x.allocationDefaultNetmaskLength
            this.allocationMaxNetmaskLength = x.allocationMaxNetmaskLength
            this.allocationMinNetmaskLength = x.allocationMinNetmaskLength
            this.autoImport = x.autoImport
            this.clearAllocationDefaultNetmaskLength = x.clearAllocationDefaultNetmaskLength
            this.description = x.description
            this.dryRun = x.dryRun
            this.ipamPoolId = x.ipamPoolId
            this.removeAllocationResourceTags = x.removeAllocationResourceTags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ModifyIpamPoolRequest = ModifyIpamPoolRequest(this)
    }
}
