// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Contains the parameters for ModifyVpcEndpoint.
 */
class ModifyVpcEndpointRequest private constructor(builder: Builder) {
    /**
     * (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
     */
    val addRouteTableIds: List<String>? = builder.addRouteTableIds
    /**
     * (Interface endpoint) One or more security group IDs to associate with the network interface.
     */
    val addSecurityGroupIds: List<String>? = builder.addSecurityGroupIds
    /**
     * (Interface and Gateway Load Balancer endpoints) One or more subnet IDs in which to serve the endpoint. For a Gateway Load Balancer endpoint, you can specify only one subnet.
     */
    val addSubnetIds: List<String>? = builder.addSubnetIds
    /**
     * The DNS options for the endpoint.
     */
    val dnsOptions: aws.sdk.kotlin.services.ec2.model.DnsOptionsSpecification? = builder.dnsOptions
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The IP address type for the endpoint.
     */
    val ipAddressType: aws.sdk.kotlin.services.ec2.model.IpAddressType? = builder.ipAddressType
    /**
     * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON format.
     */
    val policyDocument: kotlin.String? = builder.policyDocument
    /**
     * (Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.
     */
    val privateDnsEnabled: kotlin.Boolean? = builder.privateDnsEnabled
    /**
     * (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
     */
    val removeRouteTableIds: List<String>? = builder.removeRouteTableIds
    /**
     * (Interface endpoint) One or more security group IDs to disassociate from the network interface.
     */
    val removeSecurityGroupIds: List<String>? = builder.removeSecurityGroupIds
    /**
     * (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
     */
    val removeSubnetIds: List<String>? = builder.removeSubnetIds
    /**
     * (Gateway endpoint) Specify `true` to reset the policy document to the default policy. The default policy allows full access to the service.
     */
    val resetPolicy: kotlin.Boolean? = builder.resetPolicy
    /**
     * The ID of the endpoint.
     */
    val vpcEndpointId: kotlin.String? = builder.vpcEndpointId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ModifyVpcEndpointRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyVpcEndpointRequest(")
        append("addRouteTableIds=$addRouteTableIds,")
        append("addSecurityGroupIds=$addSecurityGroupIds,")
        append("addSubnetIds=$addSubnetIds,")
        append("dnsOptions=$dnsOptions,")
        append("dryRun=$dryRun,")
        append("ipAddressType=$ipAddressType,")
        append("policyDocument=$policyDocument,")
        append("privateDnsEnabled=$privateDnsEnabled,")
        append("removeRouteTableIds=$removeRouteTableIds,")
        append("removeSecurityGroupIds=$removeSecurityGroupIds,")
        append("removeSubnetIds=$removeSubnetIds,")
        append("resetPolicy=$resetPolicy,")
        append("vpcEndpointId=$vpcEndpointId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addRouteTableIds?.hashCode() ?: 0
        result = 31 * result + (addSecurityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (addSubnetIds?.hashCode() ?: 0)
        result = 31 * result + (dnsOptions?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (policyDocument?.hashCode() ?: 0)
        result = 31 * result + (privateDnsEnabled?.hashCode() ?: 0)
        result = 31 * result + (removeRouteTableIds?.hashCode() ?: 0)
        result = 31 * result + (removeSecurityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (removeSubnetIds?.hashCode() ?: 0)
        result = 31 * result + (resetPolicy?.hashCode() ?: 0)
        result = 31 * result + (vpcEndpointId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyVpcEndpointRequest

        if (addRouteTableIds != other.addRouteTableIds) return false
        if (addSecurityGroupIds != other.addSecurityGroupIds) return false
        if (addSubnetIds != other.addSubnetIds) return false
        if (dnsOptions != other.dnsOptions) return false
        if (dryRun != other.dryRun) return false
        if (ipAddressType != other.ipAddressType) return false
        if (policyDocument != other.policyDocument) return false
        if (privateDnsEnabled != other.privateDnsEnabled) return false
        if (removeRouteTableIds != other.removeRouteTableIds) return false
        if (removeSecurityGroupIds != other.removeSecurityGroupIds) return false
        if (removeSubnetIds != other.removeSubnetIds) return false
        if (resetPolicy != other.resetPolicy) return false
        if (vpcEndpointId != other.vpcEndpointId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ModifyVpcEndpointRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * (Gateway endpoint) One or more route tables IDs to associate with the endpoint.
         */
        var addRouteTableIds: List<String>? = null
        /**
         * (Interface endpoint) One or more security group IDs to associate with the network interface.
         */
        var addSecurityGroupIds: List<String>? = null
        /**
         * (Interface and Gateway Load Balancer endpoints) One or more subnet IDs in which to serve the endpoint. For a Gateway Load Balancer endpoint, you can specify only one subnet.
         */
        var addSubnetIds: List<String>? = null
        /**
         * The DNS options for the endpoint.
         */
        var dnsOptions: aws.sdk.kotlin.services.ec2.model.DnsOptionsSpecification? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The IP address type for the endpoint.
         */
        var ipAddressType: aws.sdk.kotlin.services.ec2.model.IpAddressType? = null
        /**
         * (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the service. The policy must be in valid JSON format.
         */
        var policyDocument: kotlin.String? = null
        /**
         * (Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.
         */
        var privateDnsEnabled: kotlin.Boolean? = null
        /**
         * (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.
         */
        var removeRouteTableIds: List<String>? = null
        /**
         * (Interface endpoint) One or more security group IDs to disassociate from the network interface.
         */
        var removeSecurityGroupIds: List<String>? = null
        /**
         * (Interface endpoint) One or more subnets IDs in which to remove the endpoint.
         */
        var removeSubnetIds: List<String>? = null
        /**
         * (Gateway endpoint) Specify `true` to reset the policy document to the default policy. The default policy allows full access to the service.
         */
        var resetPolicy: kotlin.Boolean? = null
        /**
         * The ID of the endpoint.
         */
        var vpcEndpointId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ModifyVpcEndpointRequest) : this() {
            this.addRouteTableIds = x.addRouteTableIds
            this.addSecurityGroupIds = x.addSecurityGroupIds
            this.addSubnetIds = x.addSubnetIds
            this.dnsOptions = x.dnsOptions
            this.dryRun = x.dryRun
            this.ipAddressType = x.ipAddressType
            this.policyDocument = x.policyDocument
            this.privateDnsEnabled = x.privateDnsEnabled
            this.removeRouteTableIds = x.removeRouteTableIds
            this.removeSecurityGroupIds = x.removeSecurityGroupIds
            this.removeSubnetIds = x.removeSubnetIds
            this.resetPolicy = x.resetPolicy
            this.vpcEndpointId = x.vpcEndpointId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ModifyVpcEndpointRequest = ModifyVpcEndpointRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.DnsOptionsSpecification] inside the given [block]
         */
        fun dnsOptions(block: aws.sdk.kotlin.services.ec2.model.DnsOptionsSpecification.Builder.() -> kotlin.Unit) {
            this.dnsOptions = aws.sdk.kotlin.services.ec2.model.DnsOptionsSpecification.invoke(block)
        }
    }
}
