// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the private IPv4 address of a network interface.
 */
class NetworkInterfacePrivateIpAddress private constructor(builder: Builder) {
    /**
     * The association information for an Elastic IP address (IPv4) associated with the network interface.
     */
    val association: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation? = builder.association
    /**
     * Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
     */
    val primary: kotlin.Boolean? = builder.primary
    /**
     * The private DNS name.
     */
    val privateDnsName: kotlin.String? = builder.privateDnsName
    /**
     * The private IPv4 address.
     */
    val privateIpAddress: kotlin.String? = builder.privateIpAddress

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.NetworkInterfacePrivateIpAddress = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInterfacePrivateIpAddress(")
        append("association=$association,")
        append("primary=$primary,")
        append("privateDnsName=$privateDnsName,")
        append("privateIpAddress=$privateIpAddress)")
    }

    override fun hashCode(): kotlin.Int {
        var result = association?.hashCode() ?: 0
        result = 31 * result + (primary?.hashCode() ?: 0)
        result = 31 * result + (privateDnsName?.hashCode() ?: 0)
        result = 31 * result + (privateIpAddress?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkInterfacePrivateIpAddress

        if (association != other.association) return false
        if (primary != other.primary) return false
        if (privateDnsName != other.privateDnsName) return false
        if (privateIpAddress != other.privateIpAddress) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.NetworkInterfacePrivateIpAddress = Builder(this).apply(block).build()

    class Builder {
        /**
         * The association information for an Elastic IP address (IPv4) associated with the network interface.
         */
        var association: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation? = null
        /**
         * Indicates whether this IPv4 address is the primary private IPv4 address of the network interface.
         */
        var primary: kotlin.Boolean? = null
        /**
         * The private DNS name.
         */
        var privateDnsName: kotlin.String? = null
        /**
         * The private IPv4 address.
         */
        var privateIpAddress: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.NetworkInterfacePrivateIpAddress) : this() {
            this.association = x.association
            this.primary = x.primary
            this.privateDnsName = x.privateDnsName
            this.privateIpAddress = x.privateIpAddress
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.NetworkInterfacePrivateIpAddress = NetworkInterfacePrivateIpAddress(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation] inside the given [block]
         */
        fun association(block: aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation.Builder.() -> kotlin.Unit) {
            this.association = aws.sdk.kotlin.services.ec2.model.NetworkInterfaceAssociation.invoke(block)
        }
    }
}
