// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the configuration of On-Demand Instances in an EC2 Fleet.
 */
class OnDemandOptions private constructor(builder: Builder) {
    /**
     * The strategy that determines the order of the launch template overrides to use in fulfilling On-Demand capacity.
     *
     * `lowest-price` - EC2 Fleet uses price to determine the order, launching the lowest price first.
     *
     * `prioritized` - EC2 Fleet uses the priority that you assigned to each launch template override, launching the highest priority first.
     *
     * Default: `lowest-price`
     */
    val allocationStrategy: aws.sdk.kotlin.services.ec2.model.FleetOnDemandAllocationStrategy? = builder.allocationStrategy
    /**
     * The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
     *
     * Supported only for fleets of type `instant`.
     */
    val capacityReservationOptions: aws.sdk.kotlin.services.ec2.model.CapacityReservationOptions? = builder.capacityReservationOptions
    /**
     * The maximum amount per hour for On-Demand Instances that you're willing to pay.
     */
    val maxTotalPrice: kotlin.String? = builder.maxTotalPrice
    /**
     * The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances.
     *
     * Supported only for fleets of type `instant`.
     *
     * At least one of the following must be specified: `SingleAvailabilityZone` | `SingleInstanceType`
     */
    val minTargetCapacity: kotlin.Int? = builder.minTargetCapacity
    /**
     * Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.
     *
     * Supported only for fleets of type `instant`.
     */
    val singleAvailabilityZone: kotlin.Boolean? = builder.singleAvailabilityZone
    /**
     * Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.
     *
     * Supported only for fleets of type `instant`.
     */
    val singleInstanceType: kotlin.Boolean? = builder.singleInstanceType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.OnDemandOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OnDemandOptions(")
        append("allocationStrategy=$allocationStrategy,")
        append("capacityReservationOptions=$capacityReservationOptions,")
        append("maxTotalPrice=$maxTotalPrice,")
        append("minTargetCapacity=$minTargetCapacity,")
        append("singleAvailabilityZone=$singleAvailabilityZone,")
        append("singleInstanceType=$singleInstanceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationStrategy?.hashCode() ?: 0
        result = 31 * result + (capacityReservationOptions?.hashCode() ?: 0)
        result = 31 * result + (maxTotalPrice?.hashCode() ?: 0)
        result = 31 * result + (minTargetCapacity ?: 0)
        result = 31 * result + (singleAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (singleInstanceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OnDemandOptions

        if (allocationStrategy != other.allocationStrategy) return false
        if (capacityReservationOptions != other.capacityReservationOptions) return false
        if (maxTotalPrice != other.maxTotalPrice) return false
        if (minTargetCapacity != other.minTargetCapacity) return false
        if (singleAvailabilityZone != other.singleAvailabilityZone) return false
        if (singleInstanceType != other.singleInstanceType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.OnDemandOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * The strategy that determines the order of the launch template overrides to use in fulfilling On-Demand capacity.
         *
         * `lowest-price` - EC2 Fleet uses price to determine the order, launching the lowest price first.
         *
         * `prioritized` - EC2 Fleet uses the priority that you assigned to each launch template override, launching the highest priority first.
         *
         * Default: `lowest-price`
         */
        var allocationStrategy: aws.sdk.kotlin.services.ec2.model.FleetOnDemandAllocationStrategy? = null
        /**
         * The strategy for using unused Capacity Reservations for fulfilling On-Demand capacity.
         *
         * Supported only for fleets of type `instant`.
         */
        var capacityReservationOptions: aws.sdk.kotlin.services.ec2.model.CapacityReservationOptions? = null
        /**
         * The maximum amount per hour for On-Demand Instances that you're willing to pay.
         */
        var maxTotalPrice: kotlin.String? = null
        /**
         * The minimum target capacity for On-Demand Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances.
         *
         * Supported only for fleets of type `instant`.
         *
         * At least one of the following must be specified: `SingleAvailabilityZone` | `SingleInstanceType`
         */
        var minTargetCapacity: kotlin.Int? = null
        /**
         * Indicates that the fleet launches all On-Demand Instances into a single Availability Zone.
         *
         * Supported only for fleets of type `instant`.
         */
        var singleAvailabilityZone: kotlin.Boolean? = null
        /**
         * Indicates that the fleet uses a single instance type to launch all On-Demand Instances in the fleet.
         *
         * Supported only for fleets of type `instant`.
         */
        var singleInstanceType: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.OnDemandOptions) : this() {
            this.allocationStrategy = x.allocationStrategy
            this.capacityReservationOptions = x.capacityReservationOptions
            this.maxTotalPrice = x.maxTotalPrice
            this.minTargetCapacity = x.minTargetCapacity
            this.singleAvailabilityZone = x.singleAvailabilityZone
            this.singleInstanceType = x.singleInstanceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.OnDemandOptions = OnDemandOptions(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.CapacityReservationOptions] inside the given [block]
         */
        fun capacityReservationOptions(block: aws.sdk.kotlin.services.ec2.model.CapacityReservationOptions.Builder.() -> kotlin.Unit) {
            this.capacityReservationOptions = aws.sdk.kotlin.services.ec2.model.CapacityReservationOptions.invoke(block)
        }
    }
}
