// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the parameters for PurchaseReservedInstancesOffering.
 */
class PurchaseReservedInstancesOfferingRequest private constructor(builder: Builder) {
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The number of Reserved Instances to purchase.
     */
    val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved Instances are not purchased at unexpected prices.
     */
    val limitPrice: aws.sdk.kotlin.services.ec2.model.ReservedInstanceLimitPrice? = builder.limitPrice
    /**
     * The time at which to purchase the Reserved Instance, in UTC format (for example, *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
     */
    val purchaseTime: aws.smithy.kotlin.runtime.time.Instant? = builder.purchaseTime
    /**
     * The ID of the Reserved Instance offering to purchase.
     */
    val reservedInstancesOfferingId: kotlin.String? = builder.reservedInstancesOfferingId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.PurchaseReservedInstancesOfferingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PurchaseReservedInstancesOfferingRequest(")
        append("dryRun=$dryRun,")
        append("instanceCount=$instanceCount,")
        append("limitPrice=$limitPrice,")
        append("purchaseTime=$purchaseTime,")
        append("reservedInstancesOfferingId=$reservedInstancesOfferingId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun?.hashCode() ?: 0
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (limitPrice?.hashCode() ?: 0)
        result = 31 * result + (purchaseTime?.hashCode() ?: 0)
        result = 31 * result + (reservedInstancesOfferingId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PurchaseReservedInstancesOfferingRequest

        if (dryRun != other.dryRun) return false
        if (instanceCount != other.instanceCount) return false
        if (limitPrice != other.limitPrice) return false
        if (purchaseTime != other.purchaseTime) return false
        if (reservedInstancesOfferingId != other.reservedInstancesOfferingId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.PurchaseReservedInstancesOfferingRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The number of Reserved Instances to purchase.
         */
        var instanceCount: kotlin.Int? = null
        /**
         * Specified for Reserved Instance Marketplace offerings to limit the total order and ensure that the Reserved Instances are not purchased at unexpected prices.
         */
        var limitPrice: aws.sdk.kotlin.services.ec2.model.ReservedInstanceLimitPrice? = null
        /**
         * The time at which to purchase the Reserved Instance, in UTC format (for example, *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
         */
        var purchaseTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the Reserved Instance offering to purchase.
         */
        var reservedInstancesOfferingId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.PurchaseReservedInstancesOfferingRequest) : this() {
            this.dryRun = x.dryRun
            this.instanceCount = x.instanceCount
            this.limitPrice = x.limitPrice
            this.purchaseTime = x.purchaseTime
            this.reservedInstancesOfferingId = x.reservedInstancesOfferingId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.PurchaseReservedInstancesOfferingRequest = PurchaseReservedInstancesOfferingRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.ReservedInstanceLimitPrice] inside the given [block]
         */
        fun limitPrice(block: aws.sdk.kotlin.services.ec2.model.ReservedInstanceLimitPrice.Builder.() -> kotlin.Unit) {
            this.limitPrice = aws.sdk.kotlin.services.ec2.model.ReservedInstanceLimitPrice.invoke(block)
        }
    }
}
