// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the parameters for RequestSpotInstances.
 */
class RequestSpotInstancesRequest private constructor(builder: Builder) {
    /**
     * The user-specified name for a logical grouping of requests.
     *
     * When you specify an Availability Zone group in a Spot Instance request, all Spot Instances in the request are launched in the same Availability Zone. Instance proximity is maintained with this parameter, but the choice of Availability Zone is not. The group applies only to requests for Spot Instances of the same instance type. Any additional Spot Instance requests that are specified with the same Availability Zone group name are launched in that same Availability Zone, as long as at least one instance from the group is still active.
     *
     * If there is no active instance running in the Availability Zone group that you specify for a new Spot Instance request (all instances are terminated, the request is expired, or the maximum price you specified falls below current Spot price), then Amazon EC2 launches the instance in any Availability Zone where the constraint can be met. Consequently, the subsequent set of Spot Instances could be placed in a different zone from the original request, even if you specified the same Availability Zone group.
     *
     * Default: Instances are launched in any available Availability Zone.
     */
    val availabilityZoneGroup: kotlin.String? = builder.availabilityZoneGroup
    /**
     * Deprecated.
     */
    val blockDurationMinutes: kotlin.Int? = builder.blockDurationMinutes
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to Ensure Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html) in the *Amazon EC2 User Guide for Linux Instances*.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
     */
    val dryRun: kotlin.Boolean? = builder.dryRun
    /**
     * The maximum number of Spot Instances to launch.
     *
     * Default: 1
     */
    val instanceCount: kotlin.Int? = builder.instanceCount
    /**
     * The behavior when a Spot Instance is interrupted. The default is `terminate`.
     */
    val instanceInterruptionBehavior: aws.sdk.kotlin.services.ec2.model.InstanceInterruptionBehavior? = builder.instanceInterruptionBehavior
    /**
     * The instance launch group. Launch groups are Spot Instances that launch together and terminate together.
     *
     * Default: Instances are launched and terminated individually
     */
    val launchGroup: kotlin.String? = builder.launchGroup
    /**
     * The launch specification.
     */
    val launchSpecification: aws.sdk.kotlin.services.ec2.model.RequestSpotLaunchSpecification? = builder.launchSpecification
    /**
     * The maximum price per hour that you are willing to pay for a Spot Instance. The default is the On-Demand price.
     */
    val spotPrice: kotlin.String? = builder.spotPrice
    /**
     * The key-value pair for tagging the Spot Instance request on creation. The value for `ResourceType` must be `spot-instances-request`, otherwise the Spot Instance request fails. To tag the Spot Instance request after it has been created, see [CreateTags](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html).
     */
    val tagSpecifications: List<TagSpecification>? = builder.tagSpecifications
    /**
     * The Spot Instance request type.
     *
     * Default: `one-time`
     */
    val type: aws.sdk.kotlin.services.ec2.model.SpotInstanceType? = builder.type
    /**
     * The start date of the request. If this is a one-time request, the request becomes active at this date and time and remains active until all instances launch, the request expires, or the request is canceled. If the request is persistent, the request becomes active at this date and time and remains active until it expires or is canceled.
     *
     * The specified start date and time cannot be equal to the current date and time. You must specify a start date and time that occurs after the current date and time.
     */
    val validFrom: aws.smithy.kotlin.runtime.time.Instant? = builder.validFrom
    /**
     * The end date of the request, in UTC format (*YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
     * + For a persistent request, the request remains active until the `ValidUntil` date and time is reached. Otherwise, the request remains active until you cancel it.
     * + For a one-time request, the request remains active until all instances launch, the request is canceled, or the `ValidUntil` date and time is reached. By default, the request is valid for 7 days from the date the request was created.
     */
    val validUntil: aws.smithy.kotlin.runtime.time.Instant? = builder.validUntil

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.RequestSpotInstancesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RequestSpotInstancesRequest(")
        append("availabilityZoneGroup=$availabilityZoneGroup,")
        append("blockDurationMinutes=$blockDurationMinutes,")
        append("clientToken=$clientToken,")
        append("dryRun=$dryRun,")
        append("instanceCount=$instanceCount,")
        append("instanceInterruptionBehavior=$instanceInterruptionBehavior,")
        append("launchGroup=$launchGroup,")
        append("launchSpecification=$launchSpecification,")
        append("spotPrice=$spotPrice,")
        append("tagSpecifications=$tagSpecifications,")
        append("type=$type,")
        append("validFrom=$validFrom,")
        append("validUntil=$validUntil)")
    }

    override fun hashCode(): kotlin.Int {
        var result = availabilityZoneGroup?.hashCode() ?: 0
        result = 31 * result + (blockDurationMinutes ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (dryRun?.hashCode() ?: 0)
        result = 31 * result + (instanceCount ?: 0)
        result = 31 * result + (instanceInterruptionBehavior?.hashCode() ?: 0)
        result = 31 * result + (launchGroup?.hashCode() ?: 0)
        result = 31 * result + (launchSpecification?.hashCode() ?: 0)
        result = 31 * result + (spotPrice?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (validFrom?.hashCode() ?: 0)
        result = 31 * result + (validUntil?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RequestSpotInstancesRequest

        if (availabilityZoneGroup != other.availabilityZoneGroup) return false
        if (blockDurationMinutes != other.blockDurationMinutes) return false
        if (clientToken != other.clientToken) return false
        if (dryRun != other.dryRun) return false
        if (instanceCount != other.instanceCount) return false
        if (instanceInterruptionBehavior != other.instanceInterruptionBehavior) return false
        if (launchGroup != other.launchGroup) return false
        if (launchSpecification != other.launchSpecification) return false
        if (spotPrice != other.spotPrice) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (type != other.type) return false
        if (validFrom != other.validFrom) return false
        if (validUntil != other.validUntil) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.RequestSpotInstancesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The user-specified name for a logical grouping of requests.
         *
         * When you specify an Availability Zone group in a Spot Instance request, all Spot Instances in the request are launched in the same Availability Zone. Instance proximity is maintained with this parameter, but the choice of Availability Zone is not. The group applies only to requests for Spot Instances of the same instance type. Any additional Spot Instance requests that are specified with the same Availability Zone group name are launched in that same Availability Zone, as long as at least one instance from the group is still active.
         *
         * If there is no active instance running in the Availability Zone group that you specify for a new Spot Instance request (all instances are terminated, the request is expired, or the maximum price you specified falls below current Spot price), then Amazon EC2 launches the instance in any Availability Zone where the constraint can be met. Consequently, the subsequent set of Spot Instances could be placed in a different zone from the original request, even if you specified the same Availability Zone group.
         *
         * Default: Instances are launched in any available Availability Zone.
         */
        var availabilityZoneGroup: kotlin.String? = null
        /**
         * Deprecated.
         */
        var blockDurationMinutes: kotlin.Int? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request. For more information, see [How to Ensure Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html) in the *Amazon EC2 User Guide for Linux Instances*.
         */
        var clientToken: kotlin.String? = null
        /**
         * Checks whether you have the required permissions for the action, without actually making the request, and provides an error response. If you have the required permissions, the error response is `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
         */
        var dryRun: kotlin.Boolean? = null
        /**
         * The maximum number of Spot Instances to launch.
         *
         * Default: 1
         */
        var instanceCount: kotlin.Int? = null
        /**
         * The behavior when a Spot Instance is interrupted. The default is `terminate`.
         */
        var instanceInterruptionBehavior: aws.sdk.kotlin.services.ec2.model.InstanceInterruptionBehavior? = null
        /**
         * The instance launch group. Launch groups are Spot Instances that launch together and terminate together.
         *
         * Default: Instances are launched and terminated individually
         */
        var launchGroup: kotlin.String? = null
        /**
         * The launch specification.
         */
        var launchSpecification: aws.sdk.kotlin.services.ec2.model.RequestSpotLaunchSpecification? = null
        /**
         * The maximum price per hour that you are willing to pay for a Spot Instance. The default is the On-Demand price.
         */
        var spotPrice: kotlin.String? = null
        /**
         * The key-value pair for tagging the Spot Instance request on creation. The value for `ResourceType` must be `spot-instances-request`, otherwise the Spot Instance request fails. To tag the Spot Instance request after it has been created, see [CreateTags](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html).
         */
        var tagSpecifications: List<TagSpecification>? = null
        /**
         * The Spot Instance request type.
         *
         * Default: `one-time`
         */
        var type: aws.sdk.kotlin.services.ec2.model.SpotInstanceType? = null
        /**
         * The start date of the request. If this is a one-time request, the request becomes active at this date and time and remains active until all instances launch, the request expires, or the request is canceled. If the request is persistent, the request becomes active at this date and time and remains active until it expires or is canceled.
         *
         * The specified start date and time cannot be equal to the current date and time. You must specify a start date and time that occurs after the current date and time.
         */
        var validFrom: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The end date of the request, in UTC format (*YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
         * + For a persistent request, the request remains active until the `ValidUntil` date and time is reached. Otherwise, the request remains active until you cancel it.
         * + For a one-time request, the request remains active until all instances launch, the request is canceled, or the `ValidUntil` date and time is reached. By default, the request is valid for 7 days from the date the request was created.
         */
        var validUntil: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.RequestSpotInstancesRequest) : this() {
            this.availabilityZoneGroup = x.availabilityZoneGroup
            this.blockDurationMinutes = x.blockDurationMinutes
            this.clientToken = x.clientToken
            this.dryRun = x.dryRun
            this.instanceCount = x.instanceCount
            this.instanceInterruptionBehavior = x.instanceInterruptionBehavior
            this.launchGroup = x.launchGroup
            this.launchSpecification = x.launchSpecification
            this.spotPrice = x.spotPrice
            this.tagSpecifications = x.tagSpecifications
            this.type = x.type
            this.validFrom = x.validFrom
            this.validUntil = x.validUntil
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.RequestSpotInstancesRequest = RequestSpotInstancesRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.RequestSpotLaunchSpecification] inside the given [block]
         */
        fun launchSpecification(block: aws.sdk.kotlin.services.ec2.model.RequestSpotLaunchSpecification.Builder.() -> kotlin.Unit) {
            this.launchSpecification = aws.sdk.kotlin.services.ec2.model.RequestSpotLaunchSpecification.invoke(block)
        }
    }
}
