// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a route in a route table.
 */
class Route private constructor(builder: Builder) {
    /**
     * The ID of the carrier gateway.
     */
    val carrierGatewayId: kotlin.String? = builder.carrierGatewayId
    /**
     * The Amazon Resource Name (ARN) of the core network.
     */
    val coreNetworkArn: kotlin.String? = builder.coreNetworkArn
    /**
     * The IPv4 CIDR block used for the destination match.
     */
    val destinationCidrBlock: kotlin.String? = builder.destinationCidrBlock
    /**
     * The IPv6 CIDR block used for the destination match.
     */
    val destinationIpv6CidrBlock: kotlin.String? = builder.destinationIpv6CidrBlock
    /**
     * The prefix of the Amazon Web Service.
     */
    val destinationPrefixListId: kotlin.String? = builder.destinationPrefixListId
    /**
     * The ID of the egress-only internet gateway.
     */
    val egressOnlyInternetGatewayId: kotlin.String? = builder.egressOnlyInternetGatewayId
    /**
     * The ID of a gateway attached to your VPC.
     */
    val gatewayId: kotlin.String? = builder.gatewayId
    /**
     * The ID of a NAT instance in your VPC.
     */
    val instanceId: kotlin.String? = builder.instanceId
    /**
     * The ID of Amazon Web Services account that owns the instance.
     */
    val instanceOwnerId: kotlin.String? = builder.instanceOwnerId
    /**
     * The ID of the local gateway.
     */
    val localGatewayId: kotlin.String? = builder.localGatewayId
    /**
     * The ID of a NAT gateway.
     */
    val natGatewayId: kotlin.String? = builder.natGatewayId
    /**
     * The ID of the network interface.
     */
    val networkInterfaceId: kotlin.String? = builder.networkInterfaceId
    /**
     * Describes how the route was created.
     * + `CreateRouteTable` - The route was automatically created when the route table was created.
     * + `CreateRoute` - The route was manually added to the route table.
     * + `EnableVgwRoutePropagation` - The route was propagated by route propagation.
     */
    val origin: aws.sdk.kotlin.services.ec2.model.RouteOrigin? = builder.origin
    /**
     * The state of the route. The `blackhole` state indicates that the route's target isn't available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been terminated).
     */
    val state: aws.sdk.kotlin.services.ec2.model.RouteState? = builder.state
    /**
     * The ID of a transit gateway.
     */
    val transitGatewayId: kotlin.String? = builder.transitGatewayId
    /**
     * The ID of a VPC peering connection.
     */
    val vpcPeeringConnectionId: kotlin.String? = builder.vpcPeeringConnectionId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.Route = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Route(")
        append("carrierGatewayId=$carrierGatewayId,")
        append("coreNetworkArn=$coreNetworkArn,")
        append("destinationCidrBlock=$destinationCidrBlock,")
        append("destinationIpv6CidrBlock=$destinationIpv6CidrBlock,")
        append("destinationPrefixListId=$destinationPrefixListId,")
        append("egressOnlyInternetGatewayId=$egressOnlyInternetGatewayId,")
        append("gatewayId=$gatewayId,")
        append("instanceId=$instanceId,")
        append("instanceOwnerId=$instanceOwnerId,")
        append("localGatewayId=$localGatewayId,")
        append("natGatewayId=$natGatewayId,")
        append("networkInterfaceId=$networkInterfaceId,")
        append("origin=$origin,")
        append("state=$state,")
        append("transitGatewayId=$transitGatewayId,")
        append("vpcPeeringConnectionId=$vpcPeeringConnectionId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = carrierGatewayId?.hashCode() ?: 0
        result = 31 * result + (coreNetworkArn?.hashCode() ?: 0)
        result = 31 * result + (destinationCidrBlock?.hashCode() ?: 0)
        result = 31 * result + (destinationIpv6CidrBlock?.hashCode() ?: 0)
        result = 31 * result + (destinationPrefixListId?.hashCode() ?: 0)
        result = 31 * result + (egressOnlyInternetGatewayId?.hashCode() ?: 0)
        result = 31 * result + (gatewayId?.hashCode() ?: 0)
        result = 31 * result + (instanceId?.hashCode() ?: 0)
        result = 31 * result + (instanceOwnerId?.hashCode() ?: 0)
        result = 31 * result + (localGatewayId?.hashCode() ?: 0)
        result = 31 * result + (natGatewayId?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaceId?.hashCode() ?: 0)
        result = 31 * result + (origin?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayId?.hashCode() ?: 0)
        result = 31 * result + (vpcPeeringConnectionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Route

        if (carrierGatewayId != other.carrierGatewayId) return false
        if (coreNetworkArn != other.coreNetworkArn) return false
        if (destinationCidrBlock != other.destinationCidrBlock) return false
        if (destinationIpv6CidrBlock != other.destinationIpv6CidrBlock) return false
        if (destinationPrefixListId != other.destinationPrefixListId) return false
        if (egressOnlyInternetGatewayId != other.egressOnlyInternetGatewayId) return false
        if (gatewayId != other.gatewayId) return false
        if (instanceId != other.instanceId) return false
        if (instanceOwnerId != other.instanceOwnerId) return false
        if (localGatewayId != other.localGatewayId) return false
        if (natGatewayId != other.natGatewayId) return false
        if (networkInterfaceId != other.networkInterfaceId) return false
        if (origin != other.origin) return false
        if (state != other.state) return false
        if (transitGatewayId != other.transitGatewayId) return false
        if (vpcPeeringConnectionId != other.vpcPeeringConnectionId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.Route = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the carrier gateway.
         */
        var carrierGatewayId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the core network.
         */
        var coreNetworkArn: kotlin.String? = null
        /**
         * The IPv4 CIDR block used for the destination match.
         */
        var destinationCidrBlock: kotlin.String? = null
        /**
         * The IPv6 CIDR block used for the destination match.
         */
        var destinationIpv6CidrBlock: kotlin.String? = null
        /**
         * The prefix of the Amazon Web Service.
         */
        var destinationPrefixListId: kotlin.String? = null
        /**
         * The ID of the egress-only internet gateway.
         */
        var egressOnlyInternetGatewayId: kotlin.String? = null
        /**
         * The ID of a gateway attached to your VPC.
         */
        var gatewayId: kotlin.String? = null
        /**
         * The ID of a NAT instance in your VPC.
         */
        var instanceId: kotlin.String? = null
        /**
         * The ID of Amazon Web Services account that owns the instance.
         */
        var instanceOwnerId: kotlin.String? = null
        /**
         * The ID of the local gateway.
         */
        var localGatewayId: kotlin.String? = null
        /**
         * The ID of a NAT gateway.
         */
        var natGatewayId: kotlin.String? = null
        /**
         * The ID of the network interface.
         */
        var networkInterfaceId: kotlin.String? = null
        /**
         * Describes how the route was created.
         * + `CreateRouteTable` - The route was automatically created when the route table was created.
         * + `CreateRoute` - The route was manually added to the route table.
         * + `EnableVgwRoutePropagation` - The route was propagated by route propagation.
         */
        var origin: aws.sdk.kotlin.services.ec2.model.RouteOrigin? = null
        /**
         * The state of the route. The `blackhole` state indicates that the route's target isn't available (for example, the specified gateway isn't attached to the VPC, or the specified NAT instance has been terminated).
         */
        var state: aws.sdk.kotlin.services.ec2.model.RouteState? = null
        /**
         * The ID of a transit gateway.
         */
        var transitGatewayId: kotlin.String? = null
        /**
         * The ID of a VPC peering connection.
         */
        var vpcPeeringConnectionId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.Route) : this() {
            this.carrierGatewayId = x.carrierGatewayId
            this.coreNetworkArn = x.coreNetworkArn
            this.destinationCidrBlock = x.destinationCidrBlock
            this.destinationIpv6CidrBlock = x.destinationIpv6CidrBlock
            this.destinationPrefixListId = x.destinationPrefixListId
            this.egressOnlyInternetGatewayId = x.egressOnlyInternetGatewayId
            this.gatewayId = x.gatewayId
            this.instanceId = x.instanceId
            this.instanceOwnerId = x.instanceOwnerId
            this.localGatewayId = x.localGatewayId
            this.natGatewayId = x.natGatewayId
            this.networkInterfaceId = x.networkInterfaceId
            this.origin = x.origin
            this.state = x.state
            this.transitGatewayId = x.transitGatewayId
            this.vpcPeeringConnectionId = x.vpcPeeringConnectionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.Route = Route(this)
    }
}
