// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a route table.
 */
class RouteTable private constructor(builder: Builder) {
    /**
     * The associations between the route table and one or more subnets or a gateway.
     */
    val associations: List<RouteTableAssociation>? = builder.associations
    /**
     * The ID of the Amazon Web Services account that owns the route table.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * Any virtual private gateway (VGW) propagating routes.
     */
    val propagatingVgws: List<PropagatingVgw>? = builder.propagatingVgws
    /**
     * The ID of the route table.
     */
    val routeTableId: kotlin.String? = builder.routeTableId
    /**
     * The routes in the route table.
     */
    val routes: List<Route>? = builder.routes
    /**
     * Any tags assigned to the route table.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the VPC.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.RouteTable = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RouteTable(")
        append("associations=$associations,")
        append("ownerId=$ownerId,")
        append("propagatingVgws=$propagatingVgws,")
        append("routeTableId=$routeTableId,")
        append("routes=$routes,")
        append("tags=$tags,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = associations?.hashCode() ?: 0
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (propagatingVgws?.hashCode() ?: 0)
        result = 31 * result + (routeTableId?.hashCode() ?: 0)
        result = 31 * result + (routes?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RouteTable

        if (associations != other.associations) return false
        if (ownerId != other.ownerId) return false
        if (propagatingVgws != other.propagatingVgws) return false
        if (routeTableId != other.routeTableId) return false
        if (routes != other.routes) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.RouteTable = Builder(this).apply(block).build()

    class Builder {
        /**
         * The associations between the route table and one or more subnets or a gateway.
         */
        var associations: List<RouteTableAssociation>? = null
        /**
         * The ID of the Amazon Web Services account that owns the route table.
         */
        var ownerId: kotlin.String? = null
        /**
         * Any virtual private gateway (VGW) propagating routes.
         */
        var propagatingVgws: List<PropagatingVgw>? = null
        /**
         * The ID of the route table.
         */
        var routeTableId: kotlin.String? = null
        /**
         * The routes in the route table.
         */
        var routes: List<Route>? = null
        /**
         * Any tags assigned to the route table.
         */
        var tags: List<Tag>? = null
        /**
         * The ID of the VPC.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.RouteTable) : this() {
            this.associations = x.associations
            this.ownerId = x.ownerId
            this.propagatingVgws = x.propagatingVgws
            this.routeTableId = x.routeTableId
            this.routes = x.routes
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.RouteTable = RouteTable(this)
    }
}
