// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a launch request for one or more instances, and includes owner, requester, and security group information that applies to all instances in the launch request.
 */
class RunInstancesResponse private constructor(builder: Builder) {
    /**
     * &#91;EC2-Classic only&#93; The security groups.
     */
    val groups: List<GroupIdentifier>? = builder.groups
    /**
     * The instances.
     */
    val instances: List<Instance>? = builder.instances
    /**
     * The ID of the Amazon Web Services account that owns the reservation.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * The ID of the requester that launched the instances on your behalf (for example, Amazon Web Services Management Console or Auto Scaling).
     */
    val requesterId: kotlin.String? = builder.requesterId
    /**
     * The ID of the reservation.
     */
    val reservationId: kotlin.String? = builder.reservationId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.RunInstancesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RunInstancesResponse(")
        append("groups=$groups,")
        append("instances=$instances,")
        append("ownerId=$ownerId,")
        append("requesterId=$requesterId,")
        append("reservationId=$reservationId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = groups?.hashCode() ?: 0
        result = 31 * result + (instances?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (requesterId?.hashCode() ?: 0)
        result = 31 * result + (reservationId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RunInstancesResponse

        if (groups != other.groups) return false
        if (instances != other.instances) return false
        if (ownerId != other.ownerId) return false
        if (requesterId != other.requesterId) return false
        if (reservationId != other.reservationId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.RunInstancesResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * &#91;EC2-Classic only&#93; The security groups.
         */
        var groups: List<GroupIdentifier>? = null
        /**
         * The instances.
         */
        var instances: List<Instance>? = null
        /**
         * The ID of the Amazon Web Services account that owns the reservation.
         */
        var ownerId: kotlin.String? = null
        /**
         * The ID of the requester that launched the instances on your behalf (for example, Amazon Web Services Management Console or Auto Scaling).
         */
        var requesterId: kotlin.String? = null
        /**
         * The ID of the reservation.
         */
        var reservationId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.RunInstancesResponse) : this() {
            this.groups = x.groups
            this.instances = x.instances
            this.ownerId = x.ownerId
            this.requesterId = x.requesterId
            this.reservationId = x.reservationId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.RunInstancesResponse = RunInstancesResponse(this)
    }
}
