// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the recurring schedule for a Scheduled Instance.
 */
class ScheduledInstanceRecurrence private constructor(builder: Builder) {
    /**
     * The frequency (`Daily`, `Weekly`, or `Monthly`).
     */
    val frequency: kotlin.String? = builder.frequency
    /**
     * The interval quantity. The interval unit depends on the value of `frequency`. For example, every 2 weeks or every 2 months.
     */
    val interval: kotlin.Int? = builder.interval
    /**
     * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday).
     */
    val occurrenceDaySet: List<Int>? = builder.occurrenceDaySet
    /**
     * Indicates whether the occurrence is relative to the end of the specified week or month.
     */
    val occurrenceRelativeToEnd: kotlin.Boolean? = builder.occurrenceRelativeToEnd
    /**
     * The unit for `occurrenceDaySet` (`DayOfWeek` or `DayOfMonth`).
     */
    val occurrenceUnit: kotlin.String? = builder.occurrenceUnit

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.ScheduledInstanceRecurrence = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledInstanceRecurrence(")
        append("frequency=$frequency,")
        append("interval=$interval,")
        append("occurrenceDaySet=$occurrenceDaySet,")
        append("occurrenceRelativeToEnd=$occurrenceRelativeToEnd,")
        append("occurrenceUnit=$occurrenceUnit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = frequency?.hashCode() ?: 0
        result = 31 * result + (interval ?: 0)
        result = 31 * result + (occurrenceDaySet?.hashCode() ?: 0)
        result = 31 * result + (occurrenceRelativeToEnd?.hashCode() ?: 0)
        result = 31 * result + (occurrenceUnit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledInstanceRecurrence

        if (frequency != other.frequency) return false
        if (interval != other.interval) return false
        if (occurrenceDaySet != other.occurrenceDaySet) return false
        if (occurrenceRelativeToEnd != other.occurrenceRelativeToEnd) return false
        if (occurrenceUnit != other.occurrenceUnit) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.ScheduledInstanceRecurrence = Builder(this).apply(block).build()

    class Builder {
        /**
         * The frequency (`Daily`, `Weekly`, or `Monthly`).
         */
        var frequency: kotlin.String? = null
        /**
         * The interval quantity. The interval unit depends on the value of `frequency`. For example, every 2 weeks or every 2 months.
         */
        var interval: kotlin.Int? = null
        /**
         * The days. For a monthly schedule, this is one or more days of the month (1-31). For a weekly schedule, this is one or more days of the week (1-7, where 1 is Sunday).
         */
        var occurrenceDaySet: List<Int>? = null
        /**
         * Indicates whether the occurrence is relative to the end of the specified week or month.
         */
        var occurrenceRelativeToEnd: kotlin.Boolean? = null
        /**
         * The unit for `occurrenceDaySet` (`DayOfWeek` or `DayOfMonth`).
         */
        var occurrenceUnit: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.ScheduledInstanceRecurrence) : this() {
            this.frequency = x.frequency
            this.interval = x.interval
            this.occurrenceDaySet = x.occurrenceDaySet
            this.occurrenceRelativeToEnd = x.occurrenceRelativeToEnd
            this.occurrenceUnit = x.occurrenceUnit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.ScheduledInstanceRecurrence = ScheduledInstanceRecurrence(this)
    }
}
