// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a security group.
 */
class SecurityGroup private constructor(builder: Builder) {
    /**
     * A description of the security group.
     */
    val description: kotlin.String? = builder.description
    /**
     * The ID of the security group.
     */
    val groupId: kotlin.String? = builder.groupId
    /**
     * The name of the security group.
     */
    val groupName: kotlin.String? = builder.groupName
    /**
     * The inbound rules associated with the security group.
     */
    val ipPermissions: List<IpPermission>? = builder.ipPermissions
    /**
     * &#91;VPC only&#93; The outbound rules associated with the security group.
     */
    val ipPermissionsEgress: List<IpPermission>? = builder.ipPermissionsEgress
    /**
     * The Amazon Web Services account ID of the owner of the security group.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * Any tags assigned to the security group.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * &#91;VPC only&#93; The ID of the VPC for the security group.
     */
    val vpcId: kotlin.String? = builder.vpcId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.SecurityGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityGroup(")
        append("description=$description,")
        append("groupId=$groupId,")
        append("groupName=$groupName,")
        append("ipPermissions=$ipPermissions,")
        append("ipPermissionsEgress=$ipPermissionsEgress,")
        append("ownerId=$ownerId,")
        append("tags=$tags,")
        append("vpcId=$vpcId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (groupId?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (ipPermissions?.hashCode() ?: 0)
        result = 31 * result + (ipPermissionsEgress?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecurityGroup

        if (description != other.description) return false
        if (groupId != other.groupId) return false
        if (groupName != other.groupName) return false
        if (ipPermissions != other.ipPermissions) return false
        if (ipPermissionsEgress != other.ipPermissionsEgress) return false
        if (ownerId != other.ownerId) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.SecurityGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * A description of the security group.
         */
        var description: kotlin.String? = null
        /**
         * The ID of the security group.
         */
        var groupId: kotlin.String? = null
        /**
         * The name of the security group.
         */
        var groupName: kotlin.String? = null
        /**
         * The inbound rules associated with the security group.
         */
        var ipPermissions: List<IpPermission>? = null
        /**
         * &#91;VPC only&#93; The outbound rules associated with the security group.
         */
        var ipPermissionsEgress: List<IpPermission>? = null
        /**
         * The Amazon Web Services account ID of the owner of the security group.
         */
        var ownerId: kotlin.String? = null
        /**
         * Any tags assigned to the security group.
         */
        var tags: List<Tag>? = null
        /**
         * &#91;VPC only&#93; The ID of the VPC for the security group.
         */
        var vpcId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.SecurityGroup) : this() {
            this.description = x.description
            this.groupId = x.groupId
            this.groupName = x.groupName
            this.ipPermissions = x.ipPermissions
            this.ipPermissionsEgress = x.ipPermissionsEgress
            this.ownerId = x.ownerId
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.SecurityGroup = SecurityGroup(this)
    }
}
