// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes a security group rule.
 *
 * You must specify exactly one of the following parameters, based on the rule type:
 * + CidrIpv4
 * + CidrIpv6
 * + PrefixListId
 * + ReferencedGroupId
 *
 * When you modify a rule, you cannot change the rule type. For example, if the rule uses an IPv4 address range, you must use `CidrIpv4` to specify a new IPv4 address range.
 */
class SecurityGroupRuleRequest private constructor(builder: Builder) {
    /**
     * The IPv4 CIDR range. To specify a single IPv4 address, use the /32 prefix length.
     */
    val cidrIpv4: kotlin.String? = builder.cidrIpv4
    /**
     * The IPv6 CIDR range. To specify a single IPv6 address, use the /128 prefix length.
     */
    val cidrIpv6: kotlin.String? = builder.cidrIpv6
    /**
     * The description of the security group rule.
     */
    val description: kotlin.String? = builder.description
    /**
     * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type. A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     */
    val fromPort: kotlin.Int? = builder.fromPort
    /**
     * The IP protocol name (`tcp`, `udp`, `icmp`, `icmpv6`) or number (see [Protocol Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
     *
     * Use `-1` to specify all protocols.
     */
    val ipProtocol: kotlin.String? = builder.ipProtocol
    /**
     * The ID of the prefix list.
     */
    val prefixListId: kotlin.String? = builder.prefixListId
    /**
     * The ID of the security group that is referenced in the security group rule.
     */
    val referencedGroupId: kotlin.String? = builder.referencedGroupId
    /**
     * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of `-1` indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
     */
    val toPort: kotlin.Int? = builder.toPort

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.SecurityGroupRuleRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SecurityGroupRuleRequest(")
        append("cidrIpv4=$cidrIpv4,")
        append("cidrIpv6=$cidrIpv6,")
        append("description=$description,")
        append("fromPort=$fromPort,")
        append("ipProtocol=$ipProtocol,")
        append("prefixListId=$prefixListId,")
        append("referencedGroupId=$referencedGroupId,")
        append("toPort=$toPort)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidrIpv4?.hashCode() ?: 0
        result = 31 * result + (cidrIpv6?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fromPort ?: 0)
        result = 31 * result + (ipProtocol?.hashCode() ?: 0)
        result = 31 * result + (prefixListId?.hashCode() ?: 0)
        result = 31 * result + (referencedGroupId?.hashCode() ?: 0)
        result = 31 * result + (toPort ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SecurityGroupRuleRequest

        if (cidrIpv4 != other.cidrIpv4) return false
        if (cidrIpv6 != other.cidrIpv6) return false
        if (description != other.description) return false
        if (fromPort != other.fromPort) return false
        if (ipProtocol != other.ipProtocol) return false
        if (prefixListId != other.prefixListId) return false
        if (referencedGroupId != other.referencedGroupId) return false
        if (toPort != other.toPort) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.SecurityGroupRuleRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The IPv4 CIDR range. To specify a single IPv4 address, use the /32 prefix length.
         */
        var cidrIpv4: kotlin.String? = null
        /**
         * The IPv6 CIDR range. To specify a single IPv6 address, use the /128 prefix length.
         */
        var cidrIpv6: kotlin.String? = null
        /**
         * The description of the security group rule.
         */
        var description: kotlin.String? = null
        /**
         * The start of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 type. A value of -1 indicates all ICMP/ICMPv6 types. If you specify all ICMP/ICMPv6 types, you must specify all codes.
         */
        var fromPort: kotlin.Int? = null
        /**
         * The IP protocol name (`tcp`, `udp`, `icmp`, `icmpv6`) or number (see [Protocol Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
         *
         * Use `-1` to specify all protocols.
         */
        var ipProtocol: kotlin.String? = null
        /**
         * The ID of the prefix list.
         */
        var prefixListId: kotlin.String? = null
        /**
         * The ID of the security group that is referenced in the security group rule.
         */
        var referencedGroupId: kotlin.String? = null
        /**
         * The end of port range for the TCP and UDP protocols, or an ICMP/ICMPv6 code. A value of `-1` indicates all ICMP/ICMPv6 codes. If you specify all ICMP/ICMPv6 types, you must specify all codes.
         */
        var toPort: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.SecurityGroupRuleRequest) : this() {
            this.cidrIpv4 = x.cidrIpv4
            this.cidrIpv6 = x.cidrIpv6
            this.description = x.description
            this.fromPort = x.fromPort
            this.ipProtocol = x.ipProtocol
            this.prefixListId = x.prefixListId
            this.referencedGroupId = x.referencedGroupId
            this.toPort = x.toPort
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.SecurityGroupRuleRequest = SecurityGroupRuleRequest(this)
    }
}
