// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes a snapshot.
 */
class Snapshot private constructor(builder: Builder) {
    /**
     * The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds to the data encryption key that was used to encrypt the original volume or snapshot copy. Because data encryption keys are inherited by volumes created from snapshots, and vice versa, if snapshots share the same data encryption key identifier, then they belong to the same volume/snapshot lineage. This parameter is only returned by DescribeSnapshots.
     */
    val dataEncryptionKeyId: kotlin.String? = builder.dataEncryptionKeyId
    /**
     * The description for the snapshot.
     */
    val description: kotlin.String? = builder.description
    /**
     * Indicates whether the snapshot is encrypted.
     */
    val encrypted: kotlin.Boolean? = builder.encrypted
    /**
     * The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the volume encryption key for the parent volume.
     */
    val kmsKeyId: kotlin.String? = builder.kmsKeyId
    /**
     * The ARN of the Outpost on which the snapshot is stored. For more information, see [Amazon EBS local snapshots on Outposts](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html) in the *Amazon Elastic Compute Cloud User Guide*.
     */
    val outpostArn: kotlin.String? = builder.outpostArn
    /**
     * The Amazon Web Services owner alias, from an Amazon-maintained list (`amazon`). This is not the user-configured Amazon Web Services account alias set using the IAM console.
     */
    val ownerAlias: kotlin.String? = builder.ownerAlias
    /**
     * The ID of the Amazon Web Services account that owns the EBS snapshot.
     */
    val ownerId: kotlin.String? = builder.ownerId
    /**
     * The progress of the snapshot, as a percentage.
     */
    val progress: kotlin.String? = builder.progress
    /**
     * Only for archived snapshots that are temporarily restored. Indicates the date and time when a temporarily restored snapshot will be automatically re-archived.
     */
    val restoreExpiryTime: aws.smithy.kotlin.runtime.time.Instant? = builder.restoreExpiryTime
    /**
     * The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
     */
    val snapshotId: kotlin.String? = builder.snapshotId
    /**
     * The time stamp when the snapshot was initiated.
     */
    val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The snapshot state.
     */
    val state: aws.sdk.kotlin.services.ec2.model.SnapshotState? = builder.state
    /**
     * Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for example, if the proper Key Management Service (KMS) permissions are not obtained) this field displays error state details to help you diagnose why the error occurred. This parameter is only returned by DescribeSnapshots.
     */
    val stateMessage: kotlin.String? = builder.stateMessage
    /**
     * The storage tier in which the snapshot is stored. `standard` indicates that the snapshot is stored in the standard snapshot storage tier and that it is ready for use. `archive` indicates that the snapshot is currently archived and that it must be restored before it can be used.
     */
    val storageTier: aws.sdk.kotlin.services.ec2.model.StorageTier? = builder.storageTier
    /**
     * Any tags assigned to the snapshot.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * The ID of the volume that was used to create the snapshot. Snapshots created by the CopySnapshot action have an arbitrary volume ID that should not be used for any purpose.
     */
    val volumeId: kotlin.String? = builder.volumeId
    /**
     * The size of the volume, in GiB.
     */
    val volumeSize: kotlin.Int? = builder.volumeSize

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.Snapshot = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Snapshot(")
        append("dataEncryptionKeyId=$dataEncryptionKeyId,")
        append("description=$description,")
        append("encrypted=$encrypted,")
        append("kmsKeyId=$kmsKeyId,")
        append("outpostArn=$outpostArn,")
        append("ownerAlias=$ownerAlias,")
        append("ownerId=$ownerId,")
        append("progress=$progress,")
        append("restoreExpiryTime=$restoreExpiryTime,")
        append("snapshotId=$snapshotId,")
        append("startTime=$startTime,")
        append("state=$state,")
        append("stateMessage=$stateMessage,")
        append("storageTier=$storageTier,")
        append("tags=$tags,")
        append("volumeId=$volumeId,")
        append("volumeSize=$volumeSize)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataEncryptionKeyId?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (encrypted?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyId?.hashCode() ?: 0)
        result = 31 * result + (outpostArn?.hashCode() ?: 0)
        result = 31 * result + (ownerAlias?.hashCode() ?: 0)
        result = 31 * result + (ownerId?.hashCode() ?: 0)
        result = 31 * result + (progress?.hashCode() ?: 0)
        result = 31 * result + (restoreExpiryTime?.hashCode() ?: 0)
        result = 31 * result + (snapshotId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (stateMessage?.hashCode() ?: 0)
        result = 31 * result + (storageTier?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (volumeId?.hashCode() ?: 0)
        result = 31 * result + (volumeSize ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Snapshot

        if (dataEncryptionKeyId != other.dataEncryptionKeyId) return false
        if (description != other.description) return false
        if (encrypted != other.encrypted) return false
        if (kmsKeyId != other.kmsKeyId) return false
        if (outpostArn != other.outpostArn) return false
        if (ownerAlias != other.ownerAlias) return false
        if (ownerId != other.ownerId) return false
        if (progress != other.progress) return false
        if (restoreExpiryTime != other.restoreExpiryTime) return false
        if (snapshotId != other.snapshotId) return false
        if (startTime != other.startTime) return false
        if (state != other.state) return false
        if (stateMessage != other.stateMessage) return false
        if (storageTier != other.storageTier) return false
        if (tags != other.tags) return false
        if (volumeId != other.volumeId) return false
        if (volumeSize != other.volumeSize) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.Snapshot = Builder(this).apply(block).build()

    class Builder {
        /**
         * The data encryption key identifier for the snapshot. This value is a unique identifier that corresponds to the data encryption key that was used to encrypt the original volume or snapshot copy. Because data encryption keys are inherited by volumes created from snapshots, and vice versa, if snapshots share the same data encryption key identifier, then they belong to the same volume/snapshot lineage. This parameter is only returned by DescribeSnapshots.
         */
        var dataEncryptionKeyId: kotlin.String? = null
        /**
         * The description for the snapshot.
         */
        var description: kotlin.String? = null
        /**
         * Indicates whether the snapshot is encrypted.
         */
        var encrypted: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the Key Management Service (KMS) KMS key that was used to protect the volume encryption key for the parent volume.
         */
        var kmsKeyId: kotlin.String? = null
        /**
         * The ARN of the Outpost on which the snapshot is stored. For more information, see [Amazon EBS local snapshots on Outposts](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/snapshots-outposts.html) in the *Amazon Elastic Compute Cloud User Guide*.
         */
        var outpostArn: kotlin.String? = null
        /**
         * The Amazon Web Services owner alias, from an Amazon-maintained list (`amazon`). This is not the user-configured Amazon Web Services account alias set using the IAM console.
         */
        var ownerAlias: kotlin.String? = null
        /**
         * The ID of the Amazon Web Services account that owns the EBS snapshot.
         */
        var ownerId: kotlin.String? = null
        /**
         * The progress of the snapshot, as a percentage.
         */
        var progress: kotlin.String? = null
        /**
         * Only for archived snapshots that are temporarily restored. Indicates the date and time when a temporarily restored snapshot will be automatically re-archived.
         */
        var restoreExpiryTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the snapshot. Each snapshot receives a unique identifier when it is created.
         */
        var snapshotId: kotlin.String? = null
        /**
         * The time stamp when the snapshot was initiated.
         */
        var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The snapshot state.
         */
        var state: aws.sdk.kotlin.services.ec2.model.SnapshotState? = null
        /**
         * Encrypted Amazon EBS snapshots are copied asynchronously. If a snapshot copy operation fails (for example, if the proper Key Management Service (KMS) permissions are not obtained) this field displays error state details to help you diagnose why the error occurred. This parameter is only returned by DescribeSnapshots.
         */
        var stateMessage: kotlin.String? = null
        /**
         * The storage tier in which the snapshot is stored. `standard` indicates that the snapshot is stored in the standard snapshot storage tier and that it is ready for use. `archive` indicates that the snapshot is currently archived and that it must be restored before it can be used.
         */
        var storageTier: aws.sdk.kotlin.services.ec2.model.StorageTier? = null
        /**
         * Any tags assigned to the snapshot.
         */
        var tags: List<Tag>? = null
        /**
         * The ID of the volume that was used to create the snapshot. Snapshots created by the CopySnapshot action have an arbitrary volume ID that should not be used for any purpose.
         */
        var volumeId: kotlin.String? = null
        /**
         * The size of the volume, in GiB.
         */
        var volumeSize: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.Snapshot) : this() {
            this.dataEncryptionKeyId = x.dataEncryptionKeyId
            this.description = x.description
            this.encrypted = x.encrypted
            this.kmsKeyId = x.kmsKeyId
            this.outpostArn = x.outpostArn
            this.ownerAlias = x.ownerAlias
            this.ownerId = x.ownerId
            this.progress = x.progress
            this.restoreExpiryTime = x.restoreExpiryTime
            this.snapshotId = x.snapshotId
            this.startTime = x.startTime
            this.state = x.state
            this.stateMessage = x.stateMessage
            this.storageTier = x.storageTier
            this.tags = x.tags
            this.volumeId = x.volumeId
            this.volumeSize = x.volumeSize
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.Snapshot = Snapshot(this)
    }
}
