// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the launch specification for one or more Spot Instances. If you include On-Demand capacity in your fleet request or want to specify an EFA network device, you can't use `SpotFleetLaunchSpecification`; you must use [LaunchTemplateConfig](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html).
 */
class SpotFleetLaunchSpecification private constructor(builder: Builder) {
    /**
     * Deprecated.
     */
    val addressingType: kotlin.String? = builder.addressingType
    /**
     * One or more block devices that are mapped to the Spot Instances. You can't specify both a snapshot ID and an encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume encryption status.
     */
    val blockDeviceMappings: List<BlockDeviceMapping>? = builder.blockDeviceMappings
    /**
     * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
     *
     * Default: `false`
     */
    val ebsOptimized: kotlin.Boolean? = builder.ebsOptimized
    /**
     * The IAM instance profile.
     */
    val iamInstanceProfile: aws.sdk.kotlin.services.ec2.model.IamInstanceProfileSpecification? = builder.iamInstanceProfile
    /**
     * The ID of the AMI.
     */
    val imageId: kotlin.String? = builder.imageId
    /**
     * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance types with those attributes.
     *
     * If you specify `InstanceRequirements`, you can't specify `InstanceTypes`.
     */
    val instanceRequirements: aws.sdk.kotlin.services.ec2.model.InstanceRequirements? = builder.instanceRequirements
    /**
     * The instance type.
     */
    val instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = builder.instanceType
    /**
     * The ID of the kernel.
     */
    val kernelId: kotlin.String? = builder.kernelId
    /**
     * The name of the key pair.
     */
    val keyName: kotlin.String? = builder.keyName
    /**
     * Enable or disable monitoring for the instances.
     */
    val monitoring: aws.sdk.kotlin.services.ec2.model.SpotFleetMonitoring? = builder.monitoring
    /**
     * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.
     *
     * `SpotFleetLaunchSpecification` currently does not support Elastic Fabric Adapter (EFA). To specify an EFA, you must use [LaunchTemplateConfig](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html).
     */
    val networkInterfaces: List<InstanceNetworkInterfaceSpecification>? = builder.networkInterfaces
    /**
     * The placement information.
     */
    val placement: aws.sdk.kotlin.services.ec2.model.SpotPlacement? = builder.placement
    /**
     * The ID of the RAM disk. Some kernels require additional drivers at launch. Check the kernel requirements for information about whether you need to specify a RAM disk. To find kernel requirements, refer to the Amazon Web Services Resource Center and search for the kernel ID.
     */
    val ramdiskId: kotlin.String? = builder.ramdiskId
    /**
     * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.
     */
    val securityGroups: List<GroupIdentifier>? = builder.securityGroups
    /**
     * The maximum price per unit hour that you are willing to pay for a Spot Instance. If this value is not specified, the default is the Spot price specified for the fleet. To determine the Spot price per unit hour, divide the Spot price by the value of `WeightedCapacity`.
     */
    val spotPrice: kotlin.String? = builder.spotPrice
    /**
     * The IDs of the subnets in which to launch the instances. To specify multiple subnets, separate them using commas; for example, "subnet-1234abcdeexample1, subnet-0987cdef6example2".
     */
    val subnetId: kotlin.String? = builder.subnetId
    /**
     * The tags to apply during creation.
     */
    val tagSpecifications: List<SpotFleetTagSpecification>? = builder.tagSpecifications
    /**
     * The Base64-encoded user data that instances use when starting up.
     */
    val userData: kotlin.String? = builder.userData
    /**
     * The number of units provided by the specified instance type. These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.
     *
     * If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.
     */
    val weightedCapacity: kotlin.Double? = builder.weightedCapacity

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.SpotFleetLaunchSpecification = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SpotFleetLaunchSpecification(")
        append("addressingType=$addressingType,")
        append("blockDeviceMappings=$blockDeviceMappings,")
        append("ebsOptimized=$ebsOptimized,")
        append("iamInstanceProfile=$iamInstanceProfile,")
        append("imageId=$imageId,")
        append("instanceRequirements=$instanceRequirements,")
        append("instanceType=$instanceType,")
        append("kernelId=$kernelId,")
        append("keyName=$keyName,")
        append("monitoring=$monitoring,")
        append("networkInterfaces=$networkInterfaces,")
        append("placement=$placement,")
        append("ramdiskId=$ramdiskId,")
        append("securityGroups=$securityGroups,")
        append("spotPrice=$spotPrice,")
        append("subnetId=$subnetId,")
        append("tagSpecifications=$tagSpecifications,")
        append("userData=$userData,")
        append("weightedCapacity=$weightedCapacity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressingType?.hashCode() ?: 0
        result = 31 * result + (blockDeviceMappings?.hashCode() ?: 0)
        result = 31 * result + (ebsOptimized?.hashCode() ?: 0)
        result = 31 * result + (iamInstanceProfile?.hashCode() ?: 0)
        result = 31 * result + (imageId?.hashCode() ?: 0)
        result = 31 * result + (instanceRequirements?.hashCode() ?: 0)
        result = 31 * result + (instanceType?.hashCode() ?: 0)
        result = 31 * result + (kernelId?.hashCode() ?: 0)
        result = 31 * result + (keyName?.hashCode() ?: 0)
        result = 31 * result + (monitoring?.hashCode() ?: 0)
        result = 31 * result + (networkInterfaces?.hashCode() ?: 0)
        result = 31 * result + (placement?.hashCode() ?: 0)
        result = 31 * result + (ramdiskId?.hashCode() ?: 0)
        result = 31 * result + (securityGroups?.hashCode() ?: 0)
        result = 31 * result + (spotPrice?.hashCode() ?: 0)
        result = 31 * result + (subnetId?.hashCode() ?: 0)
        result = 31 * result + (tagSpecifications?.hashCode() ?: 0)
        result = 31 * result + (userData?.hashCode() ?: 0)
        result = 31 * result + (weightedCapacity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SpotFleetLaunchSpecification

        if (addressingType != other.addressingType) return false
        if (blockDeviceMappings != other.blockDeviceMappings) return false
        if (ebsOptimized != other.ebsOptimized) return false
        if (iamInstanceProfile != other.iamInstanceProfile) return false
        if (imageId != other.imageId) return false
        if (instanceRequirements != other.instanceRequirements) return false
        if (instanceType != other.instanceType) return false
        if (kernelId != other.kernelId) return false
        if (keyName != other.keyName) return false
        if (monitoring != other.monitoring) return false
        if (networkInterfaces != other.networkInterfaces) return false
        if (placement != other.placement) return false
        if (ramdiskId != other.ramdiskId) return false
        if (securityGroups != other.securityGroups) return false
        if (spotPrice != other.spotPrice) return false
        if (subnetId != other.subnetId) return false
        if (tagSpecifications != other.tagSpecifications) return false
        if (userData != other.userData) return false
        if (weightedCapacity != other.weightedCapacity) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.SpotFleetLaunchSpecification = Builder(this).apply(block).build()

    class Builder {
        /**
         * Deprecated.
         */
        var addressingType: kotlin.String? = null
        /**
         * One or more block devices that are mapped to the Spot Instances. You can't specify both a snapshot ID and an encryption value. This is because only blank volumes can be encrypted on creation. If a snapshot is the basis for a volume, it is not blank and its encryption status is used for the volume encryption status.
         */
        var blockDeviceMappings: List<BlockDeviceMapping>? = null
        /**
         * Indicates whether the instances are optimized for EBS I/O. This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal EBS I/O performance. This optimization isn't available with all instance types. Additional usage charges apply when using an EBS Optimized instance.
         *
         * Default: `false`
         */
        var ebsOptimized: kotlin.Boolean? = null
        /**
         * The IAM instance profile.
         */
        var iamInstanceProfile: aws.sdk.kotlin.services.ec2.model.IamInstanceProfileSpecification? = null
        /**
         * The ID of the AMI.
         */
        var imageId: kotlin.String? = null
        /**
         * The attributes for the instance types. When you specify instance attributes, Amazon EC2 will identify instance types with those attributes.
         *
         * If you specify `InstanceRequirements`, you can't specify `InstanceTypes`.
         */
        var instanceRequirements: aws.sdk.kotlin.services.ec2.model.InstanceRequirements? = null
        /**
         * The instance type.
         */
        var instanceType: aws.sdk.kotlin.services.ec2.model.InstanceType? = null
        /**
         * The ID of the kernel.
         */
        var kernelId: kotlin.String? = null
        /**
         * The name of the key pair.
         */
        var keyName: kotlin.String? = null
        /**
         * Enable or disable monitoring for the instances.
         */
        var monitoring: aws.sdk.kotlin.services.ec2.model.SpotFleetMonitoring? = null
        /**
         * One or more network interfaces. If you specify a network interface, you must specify subnet IDs and security group IDs using the network interface.
         *
         * `SpotFleetLaunchSpecification` currently does not support Elastic Fabric Adapter (EFA). To specify an EFA, you must use [LaunchTemplateConfig](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_LaunchTemplateConfig.html).
         */
        var networkInterfaces: List<InstanceNetworkInterfaceSpecification>? = null
        /**
         * The placement information.
         */
        var placement: aws.sdk.kotlin.services.ec2.model.SpotPlacement? = null
        /**
         * The ID of the RAM disk. Some kernels require additional drivers at launch. Check the kernel requirements for information about whether you need to specify a RAM disk. To find kernel requirements, refer to the Amazon Web Services Resource Center and search for the kernel ID.
         */
        var ramdiskId: kotlin.String? = null
        /**
         * One or more security groups. When requesting instances in a VPC, you must specify the IDs of the security groups. When requesting instances in EC2-Classic, you can specify the names or the IDs of the security groups.
         */
        var securityGroups: List<GroupIdentifier>? = null
        /**
         * The maximum price per unit hour that you are willing to pay for a Spot Instance. If this value is not specified, the default is the Spot price specified for the fleet. To determine the Spot price per unit hour, divide the Spot price by the value of `WeightedCapacity`.
         */
        var spotPrice: kotlin.String? = null
        /**
         * The IDs of the subnets in which to launch the instances. To specify multiple subnets, separate them using commas; for example, "subnet-1234abcdeexample1, subnet-0987cdef6example2".
         */
        var subnetId: kotlin.String? = null
        /**
         * The tags to apply during creation.
         */
        var tagSpecifications: List<SpotFleetTagSpecification>? = null
        /**
         * The Base64-encoded user data that instances use when starting up.
         */
        var userData: kotlin.String? = null
        /**
         * The number of units provided by the specified instance type. These are the same units that you chose to set the target capacity in terms of instances, or a performance characteristic such as vCPUs, memory, or I/O.
         *
         * If the target capacity divided by this value is not a whole number, Amazon EC2 rounds the number of instances to the next whole number. If this value is not specified, the default is 1.
         */
        var weightedCapacity: kotlin.Double? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.SpotFleetLaunchSpecification) : this() {
            this.addressingType = x.addressingType
            this.blockDeviceMappings = x.blockDeviceMappings
            this.ebsOptimized = x.ebsOptimized
            this.iamInstanceProfile = x.iamInstanceProfile
            this.imageId = x.imageId
            this.instanceRequirements = x.instanceRequirements
            this.instanceType = x.instanceType
            this.kernelId = x.kernelId
            this.keyName = x.keyName
            this.monitoring = x.monitoring
            this.networkInterfaces = x.networkInterfaces
            this.placement = x.placement
            this.ramdiskId = x.ramdiskId
            this.securityGroups = x.securityGroups
            this.spotPrice = x.spotPrice
            this.subnetId = x.subnetId
            this.tagSpecifications = x.tagSpecifications
            this.userData = x.userData
            this.weightedCapacity = x.weightedCapacity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.SpotFleetLaunchSpecification = SpotFleetLaunchSpecification(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.IamInstanceProfileSpecification] inside the given [block]
         */
        fun iamInstanceProfile(block: aws.sdk.kotlin.services.ec2.model.IamInstanceProfileSpecification.Builder.() -> kotlin.Unit) {
            this.iamInstanceProfile = aws.sdk.kotlin.services.ec2.model.IamInstanceProfileSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.InstanceRequirements] inside the given [block]
         */
        fun instanceRequirements(block: aws.sdk.kotlin.services.ec2.model.InstanceRequirements.Builder.() -> kotlin.Unit) {
            this.instanceRequirements = aws.sdk.kotlin.services.ec2.model.InstanceRequirements.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SpotFleetMonitoring] inside the given [block]
         */
        fun monitoring(block: aws.sdk.kotlin.services.ec2.model.SpotFleetMonitoring.Builder.() -> kotlin.Unit) {
            this.monitoring = aws.sdk.kotlin.services.ec2.model.SpotFleetMonitoring.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.SpotPlacement] inside the given [block]
         */
        fun placement(block: aws.sdk.kotlin.services.ec2.model.SpotPlacement.Builder.() -> kotlin.Unit) {
            this.placement = aws.sdk.kotlin.services.ec2.model.SpotPlacement.invoke(block)
        }
    }
}
