// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the configuration of Spot Instances in an EC2 Fleet.
 */
class SpotOptions private constructor(builder: Builder) {
    /**
     * The strategy that determines how to allocate the target Spot Instance capacity across the Spot Instance pools specified by the EC2 Fleet.
     *
     * `lowest-price` - EC2 Fleet launches instances from the Spot Instance pools with the lowest price.
     *
     * `diversified` - EC2 Fleet launches instances from all of the Spot Instance pools that you specify.
     *
     * `capacity-optimized` (recommended) - EC2 Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching. To give certain instance types a higher chance of launching first, use `capacity-optimized-prioritized`. Set a priority for each instance type by using the `Priority` parameter for `LaunchTemplateOverrides`. You can assign the same priority to different `LaunchTemplateOverrides`. EC2 implements the priorities on a best-effort basis, but optimizes for capacity first. `capacity-optimized-prioritized` is supported only if your fleet uses a launch template. Note that if the On-Demand `AllocationStrategy` is set to `prioritized`, the same priority is applied when fulfilling On-Demand capacity.
     *
     * Default: `lowest-price`
     */
    val allocationStrategy: aws.sdk.kotlin.services.ec2.model.SpotAllocationStrategy? = builder.allocationStrategy
    /**
     * The behavior when a Spot Instance is interrupted.
     *
     * Default: `terminate`
     */
    val instanceInterruptionBehavior: aws.sdk.kotlin.services.ec2.model.SpotInstanceInterruptionBehavior? = builder.instanceInterruptionBehavior
    /**
     * The number of Spot pools across which to allocate your target Spot capacity. Supported only when `AllocationStrategy` is set to `lowest-price`. EC2 Fleet selects the cheapest Spot pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.
     *
     * Note that EC2 Fleet attempts to draw Spot Instances from the number of pools that you specify on a best effort basis. If a pool runs out of Spot capacity before fulfilling your target capacity, EC2 Fleet will continue to fulfill your request by drawing from the next cheapest pool. To ensure that your target capacity is met, you might receive Spot Instances from more than the number of pools that you specified. Similarly, if most of the pools have no Spot capacity, you might receive your full target capacity from fewer than the number of pools that you specified.
     */
    val instancePoolsToUseCount: kotlin.Int? = builder.instancePoolsToUseCount
    /**
     * The strategies for managing your workloads on your Spot Instances that will be interrupted. Currently only the capacity rebalance strategy is available.
     */
    val maintenanceStrategies: aws.sdk.kotlin.services.ec2.model.FleetSpotMaintenanceStrategies? = builder.maintenanceStrategies
    /**
     * The maximum amount per hour for Spot Instances that you're willing to pay.
     */
    val maxTotalPrice: kotlin.String? = builder.maxTotalPrice
    /**
     * The minimum target capacity for Spot Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances.
     *
     * Supported only for fleets of type `instant`.
     *
     * At least one of the following must be specified: `SingleAvailabilityZone` | `SingleInstanceType`
     */
    val minTargetCapacity: kotlin.Int? = builder.minTargetCapacity
    /**
     * Indicates that the fleet launches all Spot Instances into a single Availability Zone.
     *
     * Supported only for fleets of type `instant`.
     */
    val singleAvailabilityZone: kotlin.Boolean? = builder.singleAvailabilityZone
    /**
     * Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
     *
     * Supported only for fleets of type `instant`.
     */
    val singleInstanceType: kotlin.Boolean? = builder.singleInstanceType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.SpotOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SpotOptions(")
        append("allocationStrategy=$allocationStrategy,")
        append("instanceInterruptionBehavior=$instanceInterruptionBehavior,")
        append("instancePoolsToUseCount=$instancePoolsToUseCount,")
        append("maintenanceStrategies=$maintenanceStrategies,")
        append("maxTotalPrice=$maxTotalPrice,")
        append("minTargetCapacity=$minTargetCapacity,")
        append("singleAvailabilityZone=$singleAvailabilityZone,")
        append("singleInstanceType=$singleInstanceType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allocationStrategy?.hashCode() ?: 0
        result = 31 * result + (instanceInterruptionBehavior?.hashCode() ?: 0)
        result = 31 * result + (instancePoolsToUseCount ?: 0)
        result = 31 * result + (maintenanceStrategies?.hashCode() ?: 0)
        result = 31 * result + (maxTotalPrice?.hashCode() ?: 0)
        result = 31 * result + (minTargetCapacity ?: 0)
        result = 31 * result + (singleAvailabilityZone?.hashCode() ?: 0)
        result = 31 * result + (singleInstanceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SpotOptions

        if (allocationStrategy != other.allocationStrategy) return false
        if (instanceInterruptionBehavior != other.instanceInterruptionBehavior) return false
        if (instancePoolsToUseCount != other.instancePoolsToUseCount) return false
        if (maintenanceStrategies != other.maintenanceStrategies) return false
        if (maxTotalPrice != other.maxTotalPrice) return false
        if (minTargetCapacity != other.minTargetCapacity) return false
        if (singleAvailabilityZone != other.singleAvailabilityZone) return false
        if (singleInstanceType != other.singleInstanceType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.SpotOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * The strategy that determines how to allocate the target Spot Instance capacity across the Spot Instance pools specified by the EC2 Fleet.
         *
         * `lowest-price` - EC2 Fleet launches instances from the Spot Instance pools with the lowest price.
         *
         * `diversified` - EC2 Fleet launches instances from all of the Spot Instance pools that you specify.
         *
         * `capacity-optimized` (recommended) - EC2 Fleet launches instances from Spot Instance pools with optimal capacity for the number of instances that are launching. To give certain instance types a higher chance of launching first, use `capacity-optimized-prioritized`. Set a priority for each instance type by using the `Priority` parameter for `LaunchTemplateOverrides`. You can assign the same priority to different `LaunchTemplateOverrides`. EC2 implements the priorities on a best-effort basis, but optimizes for capacity first. `capacity-optimized-prioritized` is supported only if your fleet uses a launch template. Note that if the On-Demand `AllocationStrategy` is set to `prioritized`, the same priority is applied when fulfilling On-Demand capacity.
         *
         * Default: `lowest-price`
         */
        var allocationStrategy: aws.sdk.kotlin.services.ec2.model.SpotAllocationStrategy? = null
        /**
         * The behavior when a Spot Instance is interrupted.
         *
         * Default: `terminate`
         */
        var instanceInterruptionBehavior: aws.sdk.kotlin.services.ec2.model.SpotInstanceInterruptionBehavior? = null
        /**
         * The number of Spot pools across which to allocate your target Spot capacity. Supported only when `AllocationStrategy` is set to `lowest-price`. EC2 Fleet selects the cheapest Spot pools and evenly allocates your target Spot capacity across the number of Spot pools that you specify.
         *
         * Note that EC2 Fleet attempts to draw Spot Instances from the number of pools that you specify on a best effort basis. If a pool runs out of Spot capacity before fulfilling your target capacity, EC2 Fleet will continue to fulfill your request by drawing from the next cheapest pool. To ensure that your target capacity is met, you might receive Spot Instances from more than the number of pools that you specified. Similarly, if most of the pools have no Spot capacity, you might receive your full target capacity from fewer than the number of pools that you specified.
         */
        var instancePoolsToUseCount: kotlin.Int? = null
        /**
         * The strategies for managing your workloads on your Spot Instances that will be interrupted. Currently only the capacity rebalance strategy is available.
         */
        var maintenanceStrategies: aws.sdk.kotlin.services.ec2.model.FleetSpotMaintenanceStrategies? = null
        /**
         * The maximum amount per hour for Spot Instances that you're willing to pay.
         */
        var maxTotalPrice: kotlin.String? = null
        /**
         * The minimum target capacity for Spot Instances in the fleet. If the minimum target capacity is not reached, the fleet launches no instances.
         *
         * Supported only for fleets of type `instant`.
         *
         * At least one of the following must be specified: `SingleAvailabilityZone` | `SingleInstanceType`
         */
        var minTargetCapacity: kotlin.Int? = null
        /**
         * Indicates that the fleet launches all Spot Instances into a single Availability Zone.
         *
         * Supported only for fleets of type `instant`.
         */
        var singleAvailabilityZone: kotlin.Boolean? = null
        /**
         * Indicates that the fleet uses a single instance type to launch all Spot Instances in the fleet.
         *
         * Supported only for fleets of type `instant`.
         */
        var singleInstanceType: kotlin.Boolean? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.SpotOptions) : this() {
            this.allocationStrategy = x.allocationStrategy
            this.instanceInterruptionBehavior = x.instanceInterruptionBehavior
            this.instancePoolsToUseCount = x.instancePoolsToUseCount
            this.maintenanceStrategies = x.maintenanceStrategies
            this.maxTotalPrice = x.maxTotalPrice
            this.minTargetCapacity = x.minTargetCapacity
            this.singleAvailabilityZone = x.singleAvailabilityZone
            this.singleInstanceType = x.singleInstanceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.SpotOptions = SpotOptions(this)

        /**
         * construct an [aws.sdk.kotlin.services.ec2.model.FleetSpotMaintenanceStrategies] inside the given [block]
         */
        fun maintenanceStrategies(block: aws.sdk.kotlin.services.ec2.model.FleetSpotMaintenanceStrategies.Builder.() -> kotlin.Unit) {
            this.maintenanceStrategies = aws.sdk.kotlin.services.ec2.model.FleetSpotMaintenanceStrategies.invoke(block)
        }
    }
}
