// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ec2.model



/**
 * Describes the options for a transit gateway.
 */
class TransitGatewayRequestOptions private constructor(builder: Builder) {
    /**
     * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to 65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs. The default is `64512`.
     */
    val amazonSideAsn: kotlin.Long? = builder.amazonSideAsn
    /**
     * Enable or disable automatic acceptance of attachment requests. Disabled by default.
     */
    val autoAcceptSharedAttachments: aws.sdk.kotlin.services.ec2.model.AutoAcceptSharedAttachmentsValue? = builder.autoAcceptSharedAttachments
    /**
     * Enable or disable automatic association with the default association route table. Enabled by default.
     */
    val defaultRouteTableAssociation: aws.sdk.kotlin.services.ec2.model.DefaultRouteTableAssociationValue? = builder.defaultRouteTableAssociation
    /**
     * Enable or disable automatic propagation of routes to the default propagation route table. Enabled by default.
     */
    val defaultRouteTablePropagation: aws.sdk.kotlin.services.ec2.model.DefaultRouteTablePropagationValue? = builder.defaultRouteTablePropagation
    /**
     * Enable or disable DNS support. Enabled by default.
     */
    val dnsSupport: aws.sdk.kotlin.services.ec2.model.DnsSupportValue? = builder.dnsSupport
    /**
     * Indicates whether multicast is enabled on the transit gateway
     */
    val multicastSupport: aws.sdk.kotlin.services.ec2.model.MulticastSupportValue? = builder.multicastSupport
    /**
     * One or more IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a size /64 CIDR block or larger for IPv6.
     */
    val transitGatewayCidrBlocks: List<String>? = builder.transitGatewayCidrBlocks
    /**
     * Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
     */
    val vpnEcmpSupport: aws.sdk.kotlin.services.ec2.model.VpnEcmpSupportValue? = builder.vpnEcmpSupport

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ec2.model.TransitGatewayRequestOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TransitGatewayRequestOptions(")
        append("amazonSideAsn=$amazonSideAsn,")
        append("autoAcceptSharedAttachments=$autoAcceptSharedAttachments,")
        append("defaultRouteTableAssociation=$defaultRouteTableAssociation,")
        append("defaultRouteTablePropagation=$defaultRouteTablePropagation,")
        append("dnsSupport=$dnsSupport,")
        append("multicastSupport=$multicastSupport,")
        append("transitGatewayCidrBlocks=$transitGatewayCidrBlocks,")
        append("vpnEcmpSupport=$vpnEcmpSupport)")
    }

    override fun hashCode(): kotlin.Int {
        var result = amazonSideAsn?.hashCode() ?: 0
        result = 31 * result + (autoAcceptSharedAttachments?.hashCode() ?: 0)
        result = 31 * result + (defaultRouteTableAssociation?.hashCode() ?: 0)
        result = 31 * result + (defaultRouteTablePropagation?.hashCode() ?: 0)
        result = 31 * result + (dnsSupport?.hashCode() ?: 0)
        result = 31 * result + (multicastSupport?.hashCode() ?: 0)
        result = 31 * result + (transitGatewayCidrBlocks?.hashCode() ?: 0)
        result = 31 * result + (vpnEcmpSupport?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TransitGatewayRequestOptions

        if (amazonSideAsn != other.amazonSideAsn) return false
        if (autoAcceptSharedAttachments != other.autoAcceptSharedAttachments) return false
        if (defaultRouteTableAssociation != other.defaultRouteTableAssociation) return false
        if (defaultRouteTablePropagation != other.defaultRouteTablePropagation) return false
        if (dnsSupport != other.dnsSupport) return false
        if (multicastSupport != other.multicastSupport) return false
        if (transitGatewayCidrBlocks != other.transitGatewayCidrBlocks) return false
        if (vpnEcmpSupport != other.vpnEcmpSupport) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ec2.model.TransitGatewayRequestOptions = Builder(this).apply(block).build()

    class Builder {
        /**
         * A private Autonomous System Number (ASN) for the Amazon side of a BGP session. The range is 64512 to 65534 for 16-bit ASNs and 4200000000 to 4294967294 for 32-bit ASNs. The default is `64512`.
         */
        var amazonSideAsn: kotlin.Long? = null
        /**
         * Enable or disable automatic acceptance of attachment requests. Disabled by default.
         */
        var autoAcceptSharedAttachments: aws.sdk.kotlin.services.ec2.model.AutoAcceptSharedAttachmentsValue? = null
        /**
         * Enable or disable automatic association with the default association route table. Enabled by default.
         */
        var defaultRouteTableAssociation: aws.sdk.kotlin.services.ec2.model.DefaultRouteTableAssociationValue? = null
        /**
         * Enable or disable automatic propagation of routes to the default propagation route table. Enabled by default.
         */
        var defaultRouteTablePropagation: aws.sdk.kotlin.services.ec2.model.DefaultRouteTablePropagationValue? = null
        /**
         * Enable or disable DNS support. Enabled by default.
         */
        var dnsSupport: aws.sdk.kotlin.services.ec2.model.DnsSupportValue? = null
        /**
         * Indicates whether multicast is enabled on the transit gateway
         */
        var multicastSupport: aws.sdk.kotlin.services.ec2.model.MulticastSupportValue? = null
        /**
         * One or more IPv4 or IPv6 CIDR blocks for the transit gateway. Must be a size /24 CIDR block or larger for IPv4, or a size /64 CIDR block or larger for IPv6.
         */
        var transitGatewayCidrBlocks: List<String>? = null
        /**
         * Enable or disable Equal Cost Multipath Protocol support. Enabled by default.
         */
        var vpnEcmpSupport: aws.sdk.kotlin.services.ec2.model.VpnEcmpSupportValue? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ec2.model.TransitGatewayRequestOptions) : this() {
            this.amazonSideAsn = x.amazonSideAsn
            this.autoAcceptSharedAttachments = x.autoAcceptSharedAttachments
            this.defaultRouteTableAssociation = x.defaultRouteTableAssociation
            this.defaultRouteTablePropagation = x.defaultRouteTablePropagation
            this.dnsSupport = x.dnsSupport
            this.multicastSupport = x.multicastSupport
            this.transitGatewayCidrBlocks = x.transitGatewayCidrBlocks
            this.vpnEcmpSupport = x.vpnEcmpSupport
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ec2.model.TransitGatewayRequestOptions = TransitGatewayRequestOptions(this)
    }
}
